/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1996, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to read srrf files deleting foreign names
 */

#include <srrf.h>
#include <srrf/private.h>


srrf_t *
srrf_read_dfn()
{
	srrf_t		*rp;

	for (;;)
	{
		rp = srrf_read();
		if (rp)
		{
			if
			(
				!rp->name
			||
				!srrf_private_domain_member(rp->name)
			||
				(
					rp->type->local_test
				&&
					!rp->type->local_test(rp)
				)
			)
			{
				srrf_free(rp);
				continue;
			}
		}
		else
			srrf_private_domain_set((string_ty *)0);
		return rp;
	}
}
