/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1996, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to find classes by name
 */

#include <ac/string.h>

#include <srrf.h>

extern srrf_class_ty srrf_class_bootp;
extern srrf_class_ty srrf_class_bootparams;
extern srrf_class_ty srrf_class_ether;
extern srrf_class_ty srrf_class_in;

static srrf_class_ty *class_list[] =
{
	&srrf_class_bootp,
	&srrf_class_bootparams,
	&srrf_class_ether,
	&srrf_class_in,
};


srrf_class_ty *
srrf_class_by_name(name)
	char		*name;
{
	size_t		j;
	srrf_class_ty	*c;

	for (j = 0; j < SIZEOF(class_list); ++j)
	{
		c = class_list[j];
		if (!strcasecmp(c->name, name))
			return c;
	}
	return 0;
}
