/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1996, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate dynamically allocated srrf
 */

#include <error.h>
#include <mem.h>
#include <srrf.h>


srrf_t *
srrf_alloc()
{
	srrf_t		*rp;

	rp = (srrf_t *)mem_alloc(sizeof(srrf_t));
	rp->name = 0;
	rp->ttl = 0;
	rp->class = 0;
	rp->type = 0;
	strlist_zero(&rp->arg);
	rp->file_name = 0;
	rp->line_number = 0;
	return rp;
}


void
srrf_free(rp)
	srrf_t		*rp;
{
	if (rp->name)
	{
		assert(str_valid(rp->name));
		str_free(rp->name);
		rp->name = 0;
	}
	strlist_free(&rp->arg);
	if (rp->file_name)
	{
		assert(str_valid(rp->file_name));
		str_free(rp->file_name);
		rp->file_name = 0;
	}
	mem_free(rp);
}
