/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1991, 1992, 1993, 1995, 1996, 1999, 2000 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

#ifndef SRRF_H
#define SRRF_H

#include <ac/stdio.h>

#include <strlist.h>

struct srrf_t; /* forward */

typedef struct srrf_type_ty srrf_type_ty;
struct srrf_type_ty
{
	char		*name;
	int		number_of_arguments;
	void		(*check_arguments)_((struct srrf_t *));
	int		(*local_test)_((struct srrf_t *));
	int		(*print)_((struct srrf_t *, FILE *));
	void		(*abs_to_rel)_((struct srrf_t *));
	void		(*aux1)_((struct srrf_t *, void *));
	void		(*aux2)_((struct srrf_t *, void *));
};

typedef struct srrf_class_ty srrf_class_ty;
struct srrf_class_ty
{
	char		*name;
	srrf_type_ty	*type;
	size_t		ntypes;
};

typedef struct srrf_t srrf_t;
struct srrf_t
{
	string_ty	*name;
	long		ttl;
	srrf_class_ty	*class;
	srrf_type_ty	*type;
	strlist_ty	arg;
	string_ty	*file_name;
	int		line_number;
};

void srrf_open _((char *));
srrf_t *srrf_read _((void));
srrf_t *srrf_read_dfn _((void));
void srrf_close _((void));
srrf_t *srrf_alloc _((void));
void srrf_free _((srrf_t *));
int srrf_print _((FILE *, srrf_t *));
int srrf_print_config _((FILE *));
void srrf_check_for_duplicates _((srrf_t **, size_t, char *));
void srrf_automatic_time_stamp _((void));

srrf_class_ty *srrf_class_by_name _((char *));
srrf_type_ty *srrf_type_by_name _((srrf_class_ty *, char *));

void srrf_include_path _((char *));
int srrf_include_path_specified _((void));
void srrf_invoke_aux1 _((srrf_t *, void *));
void srrf_invoke_aux2 _((srrf_t *, void *));

string_ty *srrf_find _((string_ty *));

#endif /* SRRF_H */
