/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate regu_exprs
 */

#include <ac/stddef.h>
#include <sys/types.h>
#include <ac/rxposix.h>

#include <error.h>
#include <regu_expr.h>


int
regular_expression_match(formal, actual)
	char		*formal;
	char		*actual;
{
#if defined(HAVE_REGCOMP) && defined(HAVE_REGEXEC)
	/* use POSIX regular expressions */
	regex_t reg;
	int n = regcomp(&reg, formal, REG_NOSUB | REG_EXTENDED);
	if (n)
	{
		char errbuf[100];
		bomb:
		regerror(n, &reg, errbuf, sizeof(errbuf));
		fatal("pattern \"%s\" error: %s", formal, errbuf);
	}
	n = regexec(&reg, actual, 0, (regmatch_t *)0, 0);
	switch (n)
	{
	case 0:
		regfree(&reg);
		return 1;

	case REG_NOMATCH:
		regfree(&reg);
		return 0;
	
	default:
		goto bomb;
	}
#else /* !posix */
#if defined(HAVE_REGCMP) && defined(HAVE_REGEX)
	/* use ancient BSD regular expressions */
	int n;
	char *magic = regcmp(formal, (char *)0);
	if (!magic)
	{
		fatal("pattern \"%s\" error", formal);
	}
	n = regex(magic, actual);
	free(magic);
	return (n != 0);
#else /* !bsd */
#if defined(HAVE_RE_COMP) && defined(HAVE_RE_EXEC)
	/* use BSD 4.2 regular expressions */
	int n;
	char *s = re_comp(formal);
	if (s)
	{
		fatal("pattern \"%s\" error: %s", formal, s);
	}
	n = re_exec(actual);
	if (n < 0)
		fatal("pattern \"%s\" error", formal);
	return n;
#else /* !sun */
#error "Can't find any Regular Expression functions!"
	fatal("no regular expressions available");
#endif /* !sun */
#endif /* !bsd */
#endif /* !posix */
}
