/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/map_ether.c
 */

#ifndef COMMON_MAP_ETHER_H
#define COMMON_MAP_ETHER_H

#include <str.h>

typedef struct map_ether_t map_ether_t;
struct map_ether_t
{
	string_ty	*address;
	string_ty	*name;
};

map_ether_t *map_ether_new _((void));
void map_ether_delete _((map_ether_t *));

void map_ether_open _((const char *));
map_ether_t *map_ether_read _((void));
void map_ether_close _((void));

#endif /* COMMON_MAP_ETHER_H */
