/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to read ethers maps
 */

#include <mac.h>
#include <map.h>
#include <map_ether.h>
#include <mem.h>
#include <strlist.h>


map_ether_t *
map_ether_new()
{
	map_ether_t	*result;

	result = mem_alloc(sizeof(map_ether_t));
	result->address = 0;
	result->name = 0;
	return result;
}


void
map_ether_delete(mep)
	map_ether_t	*mep;
{
	if (mep->address)
	{
		str_free(mep->address);
		mep->address = 0;
	}
	if (mep->name)
	{
		str_free(mep->name);
		mep->name = 0;
	}
	mem_free(mep);
}


void
map_ether_open(fn)
	const char	*fn;
{
	map_open(fn);
}


void
map_ether_close()
{
	map_close();
}


map_ether_t *
map_ether_read()
{
	strlist_ty	sl;
	string_ty	*addr;
	map_ether_t	*result;

	for (;;)
	{
		if (!map_read(&sl))
			return 0;
		if (sl.nstrings != 2)
		{
			map_error("ethers entries require exactly 2 strings");
			strlist_free(&sl);
			continue;
		}
		break;
	}

	addr = mac_cannonicalize(sl.string[0]);
	if (!addr)
	{
		map_error
		(
			"the string \"%s\" is not a legal Ethernet address",
			sl.string[0]->str_text
		);
		addr = str_copy(sl.string[0]);
	}

	result = map_ether_new();
	result->name = str_copy(sl.string[1]);
	result->address = addr;
	strlist_free(&sl);
	return result;
}
