/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/map.h
 */

#ifndef COMMON_MAP_H
#define COMMON_MAP_H

#include <main.h>

enum map_token_ty
{
	map_token_eof,
	map_token_eoln,
	map_token_map,
	map_token_string
};
typedef enum map_token_ty map_token_ty;

extern	map_token_ty	map_token;
extern	char		*map_value;

void map_open(const char *);
void map_lex(void);
void map_error(const char *, ...);
void map_warning(const char *, ...);
void map_close(void);

struct strlist_ty; /* existence */
int map_read _((struct strlist_ty *));

#endif /* COMMON_MAP_H */
