/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1991, 1992, 1993, 1994, 1995, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to provide consistent -Help behaviour
 */

#include <ac/unistd.h>

#include <arglex.h>
#include <error.h>
#include <help.h>


void
help(name, usage)
	char		*name;
	void		(*usage)_((void));
{
	char		*argv[3];

	/*
	 * collect the rest of the command line,
	 * if necessary
	 */
	if (usage)
	{
		arglex();
		if (arglex_token != arglex_token_eoln)
			usage();
	}
	if (!name)
		name = progname;

	/*
	 * Invoke the appropriate ``man'' command.  This will find the
	 * right language on the search path, and it already knows how
	 * to translate the *roff into text.
	 */
	argv[0] = "man";
	argv[1] = progname;
	argv[2] = 0;
	error("%s %s", argv[0], argv[1]);
	execvp(argv[0], argv);
	nfatal("exec %s", argv[0]);
	/* NOTREACHED */
}
