/*
 *	dnsutl - utilities to make DNS easier to configure
 *	Copyright (C) 1991, 1992, 1993, 1999, 2000 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

#ifndef ERROR_H
#define ERROR_H

#include <main.h>

void error _((char *, ...));
void fatal _((char *, ...));
void nerror _((char *, ...));
void nfatal _((char *, ...));

#ifdef DEBUG
# ifdef __STDC__
#  define assert(c) cook_assert((c) != 0, #c, __FILE__, __LINE__)
# else
#  define assert(c) cook_assert((c) != 0, "c", __FILE__, __LINE__)
# endif
#else
# define assert(c)
#endif

void cook_assert _((int, const char *, const char *, int));

#endif /* ERROR_H */
