/* IPZoner.c v2.2 (10/29/97)                             *
 * By Drago [Drago@Drago.com]                            *
 * Please send questions || comments || ideas || bugs.   *
 *                                                       *
 * This program can be used to scan class A-C IP blocks. *
 * hey, it works for me. =)   		                 *
 *                                                       *
 * Notes: I'm sure there is a billion ways to do this    *
 * better and faster, but this is what I did, so deal    *
 * with it, and sorry for the sloppy coding :)           *
 *							 *
 * PS: well, all I can say is, it killed my cat, so 	 *
 * be carefull :P					 */

/* Use curses/ncurses (add -lncurses to the command line) */
/* #define USE_CURSES */

/* Do we want to use UDP or TCP? if you want TCP; define this, if this 
 isnt defined UDP will be used. */
/* #define USE_TCP */

/* Max build string length used for -m. */ 
#define BUILD_LENGTH 1000

/* High IP zone */
#define HIGH 255

/* Low IP zone */
#define LOW 0

/* High IP */
#define HIGHIP "255.255.255.255"

/* (secs) alarm() timeout for gethostbyaddr().  Undefine if you dont want a alarm() timeout. */
#define GETHOSTBYADDR_TIMEOUT 6

/* Use ANSI in options() (easier to read) */
#define USE_ANSI

#ifdef USE_ANSI
# define ANSIC "["
# define BOLD ANSIC "1;1m"
# define TERM ANSIC "0m"
#else
# define BOLD ""
# define TERM ""
#endif

#ifdef USE_CURSES
# warning ** if ncurses/curses errors occur undefine USE_CURSES **
#else
# warning ** if you have ncurses/curses define USE_CURSES **
#endif

#define VERSION "IPZoner 2.2 [10/29/97] (C) 1997 Drago [Drago@Drago.com]."

#include <stdio.h>
#include <netdb.h>
#include <math.h>
#include <sys/signal.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#ifdef USE_CURSES
# include <curses.h>
#endif
#include <ctype.h>
#include <unistd.h>
#ifndef AF_INET
# define AF_INET 2
#endif


struct main_struct {
   char ip_build[50];        /* String to build the IP. */
   char ip[4];               /* Holds the IP (no dots). */
   char ip_scan[50];         /* IP storage on each scan. */
   char theformat[200];      /* String storage for the -rm && -m format. */
   char build[BUILD_LENGTH]; /* Building string for format. */
   char *logfile;            /* Log file. */
   char *pexec;              /* -r && -rm exec string. */
   char *eline;              /* Used to build exec string. */
};

struct IP_struct {
   int p1;         /* XXX.x.x.x */
   int p2;         /* x.XXX.x.x */
   int p3;         /* x.x.XXX.x */
   int p4;         /* x.x.x.XXX */
};

struct toggle_struct {
   int debuger;        /* debugging */
   int xip;            /* exclude */
   int uformat;        /* format */
   int rm;             /* exec format */
   int forking;        /* forking */
   int nonull;         /* null */
   int dot;            /* dot */
   int filelogging;    /* logging */
};

struct IP_struct StartIP;
struct IP_struct ToIP;
struct IP_struct RealStartIP;
struct IP_struct ScanZone;
struct main_struct storage;
struct toggle_struct toggles;

int rc, uc, scans, counting;
FILE *fileid;

void next();
void ip_calc();
void check_and_resolve();
#ifdef GETHOSTBYADDR_TIMEOUT
void sigalrm_handling();
#endif
void sigint_handling();
void sigstp_handling();
char *parse_vars();
void make_sig();
void options();
void variables();
void bubye();
void atexit_func();

void main(int argc, char *argv[]) {
   char sw;
   int i=0, sip=0, v1=0, v2=0;
#ifdef USE_CURSES
   initscr(); cbreak(); noecho(); start_color();
#endif
   atexit(atexit_func);
   printf("%s\n", VERSION);
   if (argc < 2) {
      options(argv[0]);
      exit(0);
   }
   ScanZone.p1=1; ScanZone.p2=1; ScanZone.p3=1; ScanZone.p4=1;
/* Parse the command line options '-x'. */
   for (i=1; i!=argc; i++) {
      if (argv[i][0]=='-' || argv[i][1]=='-') {
         if (argv[i][1]=='-') sw=argv[i][2];
         else if (argv[i][0]=='-') sw=argv[i][1];
	 switch (toupper(sw)) {
	  case 'S' :
	    i++;
            if (argc >= i+1) {
	       if (sscanf(argv[i], "%d.%d.%d.%d", &StartIP.p1, &StartIP.p2, &StartIP.p3, &StartIP.p4) != 4) {
	          printf("-s\t: Need a IP that contains 4 zones (int).\n");
	          exit(0);
               }
	       if (StartIP.p1 > HIGH) {
		  printf("-s: Zone 1 is incorrect.\n");
		  exit(0);
	       }
	       if (StartIP.p2 > HIGH) { 
		  printf("-s: Zone 2 is incorrect.\n"); 
		  exit(0); 
	       }
	       if (StartIP.p3 > HIGH) { 
		  printf("-s: Zone 3 is incorrect.\n"); 
		  exit(0); 
	       }
	       if (StartIP.p4 > HIGH) { 
		  printf("-s: Zone 4 is incorrect.\n"); 
		  exit(0); 
	       }
	       sip=1;
            }
            else { printf("-s\t: Missing IP arg.\n"); exit(0); }
	    break;
	  case 'V' :
             variables();
	     exit(0);
	     break;

	  case 'H' :
            options(argv[0]);
            break;
  
	  case 'T' :
	    i++;
            if (argc >= i+1) {
	       if (sscanf(argv[i], "%d.%d.%d.%d", &ToIP.p1 , &ToIP.p2, &ToIP.p3, &ToIP.p4) != 4) {
	          printf("-t\t: Need a IP that contains 4 zones (int).\n");
	          exit(0);
	       }
	       if (ToIP.p1 > HIGH) { 
		  printf("-t: Zone 1 is incorrect.\n"); 
		  exit(0); 
	       }
	       if (ToIP.p2 > HIGH) { 
		  printf("-t: Zone 2 is incorrect.\n"); 
		  exit(0);
	       }
	       if (ToIP.p3 > HIGH) { 
		  printf("-t: Zone 3 is incorrect.\n"); 
		  exit(0);
	       }
	       if (ToIP.p4 > HIGH) {
		  printf("-t: Zone 4 is incorrect.\n");
		  exit(0);
	       }
	       toggles.xip=1;
            }
            else { printf("-t\t: Missing IP arg.\n"); exit(0); }
	    break;
	    
	  case 'R' :
	    i++;
            if (toggles.uformat) { 
	       printf("-rm\t: Option cannot be used with -m.\n"); 
	       exit(0); 
	    }
            if (argc >= i+1) {
               if (toupper(argv[i-1][2])=='M') {
                  v2=0;
                  for (v1=0; v1<strlen(argv[i]); v1++) {
	             if (argv[i][v1]=='%') { v1++; v2++; }
                  }
                  if ((int)v2 > (int)50) { 
		     printf("-rm\t: Only x < 50 variables may be used (%d).\n", (int)v2); 
		     exit(0); 
		  }
                  if ((int)v2 < (int)1) { 
		     printf("-rm\t: Atleast one variable must be used.\n"); 
		     exit(0); 
		  }
                  if (strlen(argv[i]) > 200) { 
		     printf("-rm\t: Excessive length. (argv[%i]>200).\n", i); 
		     exit(0); 
		  }
                  strncpy(storage.theformat, argv[i], 200);
                  parse_vars("x", NULL, 1);
                  printf("-rm\t: \"%s\" will be used for the system() format (%d).\n", storage.theformat, (int)v2);
                  toggles.rm=1;
	          if ((storage.pexec=(char *)malloc(strlen("nothing") * sizeof(char)))==NULL) {
                     perror("malloc");
                     exit(0);
                  }
                  strcpy(storage.pexec, "nothing");
               }	
               else if (storage.pexec==NULL) {
	          if ((storage.pexec=(char *)malloc(strlen(argv[i]) * sizeof(char)))==NULL) {
                     perror("malloc");
                     exit(0);
                  }
	          strcpy(storage.pexec, argv[i]);
	          printf("-r\t: %s will be executed with the IP as argv[1].\n", storage.pexec);
               }
	    }
	    else { 
	       printf("%s\t: Missing %s arg.\n", argv[i-1], (toupper(argv[i-1][2])=='M' ? "format" : "program")); 
	       exit(0); 
	    }
	    break;
	    
	  case 'M' :
	    i++;
            if (toggles.rm) { 
	       printf("-m\t: Option cannot be used with -rm.\n"); 
	       exit(0); 
	    }
	    if (argc >= i+1 && !toggles.uformat) {
               v2=0;
               for (v1=0; v1<strlen(argv[i]); v1++) {
                   if (argv[i][v1]=='%') { v1++; v2++; }
               }
               if ((int)v2 > (int)50) { 
		  printf("-m\t: Only x < 50 variables may be used (%d).\n", (int)v2); 
		  exit(0); 
	       }
               if ((int)v2 < (int)1) { 
		  printf("-m\t: Atleast one variable must be used.\n"); 
		  exit(0); 
	       }
               if (strlen(argv[i]) > 200) { 
		  printf("-m\t: Excessive length. (argv[%i]>200).\n", i); 
		  exit(0); 
	       }
	       strncpy(storage.theformat, argv[i], 1000);
	       parse_vars("x", "x", 0);	
	       printf("-m\t: \"%s\" will be used for the output resolving format (%d).\n", storage.theformat, (int)v2);
	       toggles.uformat=1;
	    }	
	    else if (!toggles.uformat) { 
	       printf("-m\t: Missing format arg.\n"); 
	       exit(0); 
	    }
	    break;
	    
	  case 'E' :
	    i++;
	    if (argc >= i+1) {
	       if (!strcmp(argv[i], "1")) { 
		  printf("-e\t: Zone 1 will be excluded.\n"); 
		  ScanZone.p1=0; 
	       }
	       else if (!strcmp(argv[i], "2")) { 
		  printf("-e\t: Zone 2 will be excluded.\n"); 
		  ScanZone.p2=0; 
	       }
	       else if (!strcmp(argv[i], "3")) { 
		  printf("-e\t: Zone 3 will be excluded.\n"); 
		  ScanZone.p3=0; 
	       }
	       else if (!strcmp(argv[i], "4")) { 
		  printf("-e\t: Zone 4 will be excluded.\n"); 
		  ScanZone.p4=0; 
	       }
	       else { 
		  printf("-e\t: Invalid zone arg.\n"); 
		  exit(0); 
	       }
	       if(!ScanZone.p1 && !ScanZone.p2 && !ScanZone.p3 && !ScanZone.p4) {
		  printf("You may only exclude x <= 3 zones.\n");
		  exit(0);
	       }
	    }
	    else { 
	       printf("-e\t: Missing zone arg (1, 2, 3, 4).\n"); 
	       exit(0); 
	    }
	    break;
	    
	  case 'N' :
	    if (!toggles.nonull) {
               if (toggles.rm || toggles.uformat) 
		 printf("-n\t: Exec info will not be shown.\n");
	       else 
		 printf("-n\t: IP's that return NULL || timeout will not be shown.\n");
	       toggles.nonull=1;
	    }
	    break;
	  
	  case 'D' :
	    if (!toggles.dot) {
	       printf("-d\t: A single dot will be printed on each request.\n");
	       toggles.dot=1;
	    }
	    break;
	    
	  case 'L' :
	    i++;
	    if (argc>=i+1 && !toggles.filelogging) {
	       if ((storage.logfile=(char *)malloc(strlen(argv[i]) * sizeof(char)))==NULL) {
                  perror("malloc");
                  exit(0);
               }
	       strcpy(storage.logfile,argv[i]);
	       printf("-l\t: Logging all lookup's/exec's to %s.\n", storage.logfile);
	       toggles.filelogging=1;
	       fileid=fopen(storage.logfile,"a+");
	       if (fileid==NULL) { 
		  perror("fopen(storage.logfile, \"a+\")"); 
		  exit(0); 
	       }
	    }
	    else if (!toggles.filelogging) { 
	       printf("-l\t: Missing file arg.\n"); 
	       exit(0); 
	    }
	    break;
	    
	  case 'F' :
	    if (!toggles.forking) {
	       printf("-f\t: Will fork() myself when started.\n");
	       toggles.forking=1;
	    }
	    break;
	    
	  case 'X' :
	    if (!toggles.debuger) {
	       printf("-x\t: Will print debug infomartion.\n"); 
	       toggles.debuger=1;
	    }
	    break;
	   default :
	    printf("Unkown option on the command line: argv[%i] = %s.\n", i, argv[i]);
	    exit(0);
	  break;
	 }
      }
      else {
         printf("Error: Unkown text on the command line: argv[%i] = %s.\n", i, argv[i]);
         exit(0);
      }
  }
/* Check to see if zone 1 to is lower than zone 1 start. */
   if (sip != 1) { printf("Error: Need a start IP.\n"); exit(0); }
   StartIP.p1=fabs(StartIP.p1); StartIP.p2=fabs(StartIP.p2); 
   StartIP.p3=fabs(StartIP.p3); StartIP.p4=fabs(StartIP.p4);
   if (toggles.xip) {
      if (StartIP.p1 > ToIP.p1 && ScanZone.p1) { 
	 printf("Error: -t: Zone 1 > -s: Zone1.\n"); 
	 exit(0); 
      }
   }
/* Put the start ip sections in a second set of vars. */
   RealStartIP.p1=StartIP.p1; RealStartIP.p2=StartIP.p2; 
   RealStartIP.p3=StartIP.p3; RealStartIP.p4=StartIP.p4;
   if (!toggles.xip) 
     snprintf(storage.ip_build, 50, "%d.%d.%d.%d", (ScanZone.p1 ? HIGH : RealStartIP.p1), (ScanZone.p2 ? HIGH : RealStartIP.p2), (ScanZone.p3 ? HIGH : RealStartIP.p3), (ScanZone.p4 ? HIGH : RealStartIP.p4));
   else
     snprintf(storage.ip_build, 50, "%d.%d.%d.%d", (ScanZone.p1 ? ToIP.p1 : StartIP.p1), (ScanZone.p2 ? ToIP.p2 : StartIP.p2), (ScanZone.p3 ? ToIP.p3 : StartIP.p3), (ScanZone.p4 ? ToIP.p4 : StartIP.p4));
   if (toggles.filelogging) {
      fprintf(fileid, "%s\n", VERSION);
      fprintf(fileid,"Scanning from: %d.%d.%d.%d\n", RealStartIP.p1, RealStartIP.p2, RealStartIP.p3, RealStartIP.p4);
      fprintf(fileid,"Scanning to: %s\n", storage.ip_build);
   }
   printf("Scanning from: %d.%d.%d.%d\n", RealStartIP.p1, RealStartIP.p2, RealStartIP.p3, RealStartIP.p4);
   printf("Scanning to: %s\n", storage.ip_build);
#ifdef USE_CURSES
   printf("Press any key to continue.\n");   
   fflush(stdout);
   getch();
#else
   if (1) {
      int ch;
      printf("Press enter to continue.\n");
      read(0, &ch, 1);
   }
#endif
   make_sig();
   if (toggles.forking) { if(fork()) exit(0); }
   if (toggles.filelogging) 
     printf("Logging has been started to %s, all output will be supressed.\n", storage.logfile);
#ifdef USE_TCP 
   sethostent(1);
#endif
   check_and_resolve();
   next();
   return;
}

void next(void) {
/* Where shall we go now? */
   if (toggles.filelogging && counting>=50) { fflush(fileid); counting=0; }
   if (toggles.filelogging) counting++;
   ip_calc();
   next();
   return;
}

void ip_calc(void) {
/* Fun stuff, calculation.. */
   if (StartIP.p4 >= HIGH) {
      if (ScanZone.p4) {
	 StartIP.p4=LOW;
      }
      if(ScanZone.p3) {
	 StartIP.p3++;
      }
      else if(ScanZone.p2) {
	 StartIP.p2++;
      }
      else if(ScanZone.p1) {
	 StartIP.p1++;
      }
   }
   else {
      if (ScanZone.p4) {
	 StartIP.p4++;
      }
      else if(ScanZone.p3) {
	 StartIP.p3++;
      }
      else if(ScanZone.p2) {
	 StartIP.p2++;
      }
      else if(ScanZone.p1) {
	 StartIP.p1++;
      }
   }
   check_and_resolve();
   return;
}

void check_and_resolve(void) {
/* Resolving stuff/final checking. */
   struct hostent *host;
   if (!ScanZone.p1) StartIP.p1=RealStartIP.p1;
   if (!ScanZone.p2) StartIP.p2=RealStartIP.p2;
   if (!ScanZone.p3) StartIP.p3=RealStartIP.p3;
   if (!ScanZone.p4) StartIP.p4=RealStartIP.p4;
   if (StartIP.p4 > HIGH && ScanZone.p4) { 
      StartIP.p4=LOW; 
      if (ScanZone.p3) StartIP.p3++; 
      else if (ScanZone.p2) StartIP.p2++;
      else if (ScanZone.p1) StartIP.p1++;
      return; 
   }
   if (StartIP.p3 > HIGH && ScanZone.p3) {
      StartIP.p3=LOW; 
      if (ScanZone.p2) StartIP.p2++; 
      else if(ScanZone.p1) StartIP.p1++;
      return; 
   }
   if (StartIP.p2 > HIGH && ScanZone.p2) { 
      StartIP.p2=LOW; 
      if (ScanZone.p1) StartIP.p1++; 
      return; 
   }
/* Build the IP into a string. */
   snprintf(storage.ip_scan, 50, "%d.%d.%d.%d", (ScanZone.p1 ? StartIP.p1 : RealStartIP.p1), (ScanZone.p2 ? StartIP.p2 : RealStartIP.p2), (ScanZone.p3 ? StartIP.p3 : RealStartIP.p3), (ScanZone.p4 ? StartIP.p4 : RealStartIP.p4));
   storage.ip[0]=(ScanZone.p1 ? StartIP.p1 : RealStartIP.p1); 
   storage.ip[1]=(ScanZone.p2 ? StartIP.p2 : RealStartIP.p2);
   storage.ip[2]=(ScanZone.p3 ? StartIP.p3 : RealStartIP.p3); 
   storage.ip[3]=(ScanZone.p4 ? StartIP.p4 : RealStartIP.p4);
/* duh? */
   if(!strcmp(storage.ip_scan, HIGHIP)) goto done;
   scans++;
   if (toggles.dot) {
      if (toggles.filelogging) fprintf(fileid, ".");
      else { printf("."); fflush(stdout); }
   }
   if (storage.pexec==NULL) {
#ifdef GETHOSTBYADDR_TIMEOUT
      alarm(GETHOSTBYADDR_TIMEOUT);
#endif
      host=gethostbyaddr(storage.ip, sizeof(storage.ip), AF_INET);
#ifdef GETHOSTBYADDR_TIMEOUT
      alarm(0);
#endif
      if (toggles.debuger) {
	 printf("%d: ", (int)scans); fflush(stdout); 
	 herror("debug gethostbyaddr()"); 
      }
      if (host) {
	 rc++;
	 if (toggles.filelogging && toggles.uformat) 
	   fprintf(fileid, "%s", parse_vars(storage.ip_scan, (char *)host->h_name, 0));
         else if (toggles.filelogging) 
	   fprintf(fileid, "%d: %s == %s\n", (int)scans, storage.ip_scan, host->h_name);
	 else if (toggles.uformat) { 
	    printf("%s", parse_vars(storage.ip_scan, (char *)host->h_name, 0)); 
	    fflush(stdout); 
	 }
	 else printf("%d: %s == %s\n", (int)scans, storage.ip_scan, host->h_name);
      }
      else {
	 uc++;
	 if (!toggles.nonull) {
	    if (toggles.filelogging && toggles.uformat) 
	      fprintf(fileid, "%s", parse_vars(storage.ip_scan, "NULL", 0));
	    else if (toggles.filelogging) 
	      fprintf(fileid, "%d: %s == NULL\n", (int)scans, storage.ip_scan);
	    else if (toggles.uformat) { 
	       printf("%s", parse_vars(storage.ip_scan, "NULL", 0)); 
	       fflush(stdout); 
	    }
	    else printf("%d: %s == NULL\n", (int)scans, storage.ip_scan);
	 }
      }
   }
   else {
      if (!toggles.rm) {
         if ((storage.eline=(char *)malloc((strlen(storage.pexec) * sizeof(char)) + (sizeof(char) * strlen(storage.ip_scan))))==NULL) {
            perror("malloc");
            exit(0);
         }
         sprintf(storage.eline, "%s %s", storage.pexec, storage.ip_scan);
      }
      else 
	sprintf(storage.eline, "%s", parse_vars(storage.ip_scan, "NULL", 1));
      if (!toggles.filelogging && !toggles.nonull) 
	printf("%d: executing '%s'\n", (int)scans, storage.eline);
      else if (!toggles.nonull) 
	fprintf(fileid, "%d: executing '%s'\n", (int)scans, storage.eline);
      fflush(stdout);
      system(storage.eline);
      free(storage.eline);
   }
   done:
   if (toggles.xip) { 
      if(!strcmp(storage.ip_scan, storage.ip_build))  {
	 bubye(1);
#ifdef USE_TCP
	 endhostent();
#endif
	 exit(0);
      }
   }
   if((ScanZone.p1 ? HIGH : RealStartIP.p1) <= StartIP.p1 && (ScanZone.p2 ? HIGH : RealStartIP.p2) <= StartIP.p2 && (ScanZone.p3 ? HIGH : RealStartIP.p3) <= StartIP.p3 && (ScanZone.p4 ? HIGH : RealStartIP.p4) <= StartIP.p4) {
      bubye(1);
#ifdef USE_TCP
      endhostent();
#endif
      exit(0);
   }
   fflush(stdout);
   return;
}

#ifdef GETHOSTBYADDR_TIMEOUT
void sigalrm_handling(void) {
/* SIGALRM signal handling */
   if (toggles.debuger) {
      printf("%d: ", (int)scans); fflush(stdout); 
      printf("debug gethostbyaddr(): Timeout! (SIGALRM - %ds)\n", GETHOSTBYADDR_TIMEOUT); 
   }
   if (!toggles.nonull) {
      if (toggles.filelogging && toggles.uformat) 
	fprintf(fileid, "%s", parse_vars(storage.ip_scan, "NULL (SIGALARM - %ds)", 0, GETHOSTBYADDR_TIMEOUT));
      else if (toggles.filelogging) 
	fprintf(fileid, "%d: %s == NULL (SIGALARM - %ds)\n", (int)scans, storage.ip_scan, GETHOSTBYADDR_TIMEOUT);
      else if (toggles.uformat) { 
         char temp[100];
         snprintf(temp, 100, "NULL (SIGALARM %ds)", GETHOSTBYADDR_TIMEOUT);
	 printf("%s", parse_vars(storage.ip_scan, temp, 0)); 
	 fflush(stdout); 
      }
      else printf("%d: %s == NULL (SIGALARM %ds)\n", (int)scans, storage.ip_scan, GETHOSTBYADDR_TIMEOUT);
   }
   uc++;
   signal(SIGALRM, (void (*)())sigalrm_handling);
   next();
   return;
}
#endif

void sigint_handling(void) {
/* ^C signal handling(SIGINT) */
   bubye(0);
   exit(0);
   return;
}

void sigstp_handling(void) {
/* ^Z signal handling(SIGTSTP). */
   char x;
   signal(SIGTSTP, SIG_IGN);
   signal(SIGINT, (void (*)())sigint_handling);
   bah:
   printf("\n(s)top/(f)ork/s(u)spend/(c)ancel: ");
   fflush(stdout);
#ifdef USE_CURSES
   x=getch();
#else
   read(0, &x, 1);
#endif
   signal(SIGTSTP, (void (*)())sigstp_handling);
   switch(toupper(x)) {
      case 'S' : sigint_handling(); break;
      case 'U' : signal(SIGTSTP, SIG_DFL); raise(SIGTSTP); make_sig(); break;	
      case 'F' :
         if (storage.pexec!=NULL || toggles.rm==1) {
            /* I wasnt able to figure out why I couldnt fork in -r||-rm mode, care to tell me? =) */
            printf("Error: No SIGTSTP support for forking in -r || -rm mode.\n");
            goto bah;
         }
         else {
            toggles.forking=1;
            signal(SIGINT, (void (*)())sigint_handling);
            signal(SIGTSTP, SIG_DFL);
            if (fork()) exit(0);
         }
      break;
    default : make_sig(); break;
   }
   return;
}

char * parse_vars(char * theip, char * thehost, int h){
   int i, bw=0;
   bzero(storage.build, strlen(storage.build));
   for (i=0;i<strlen(storage.theformat);i++) {
      if ((storage.theformat[i]=='%' && storage.theformat[i+1]=='%') ||
	  (storage.theformat[i]=='%' && i+1>=strlen(storage.theformat))) { 
	 storage.build[bw]='%';
	 bw++;
	 i+=1;
	 continue;
       }
      if (storage.theformat[i]=='%' && storage.theformat[i+1]!='%') { 
	 i++;
	 switch(toupper(storage.theformat[i])) {	    
	    
	  case 'H':
            if (h) {
	       printf("-rm: Invalid variable: storage.theformat[%i] = %%%c.\n",i-1,storage.theformat[i]);
	       exit(0);
	       break;
	    }
            if ((int)strlen(storage.build)+strlen(thehost)>=BUILD_LENGTH) {
	       if (!toggles.filelogging) 
		 printf("%s: Unable to build string! (strlen(storage.build)+strlen(thehost) >= %d) == %d | (%s == %s)\n", storage.theformat, BUILD_LENGTH, (strlen(storage.build)+strlen(thehost)), theip, thehost);
	       else 
		 fprintf(fileid,"%s: Unable to build string! (strlen(storage.build)+strlen(thehost) >= %d) == %d | (%s == %s)\n", storage.theformat, BUILD_LENGTH, (strlen(storage.build)+strlen(thehost)), theip, thehost);
               return "";
	    }
            snprintf(storage.build, BUILD_LENGTH, "%s%s", storage.build, thehost);
            bw=strlen(storage.build);
	    break;
	    
	  case 'I':
            if ((int)strlen(storage.build)+strlen(theip)>=BUILD_LENGTH) {
	       if (!toggles.filelogging) 
		 printf("%s: Unable to build string! (strlen(storage.build)+strlen(theip) >= %d) == %d | (%s == %s)\n", storage.theformat, BUILD_LENGTH, strlen(storage.build)+strlen(theip), theip, thehost);
	       else 
		 fprintf(fileid,"%s: Unable to build string! (strlen(storage.build)+strlen(theip) >= %d) == %d | (%s == %s)\n", storage.theformat, BUILD_LENGTH, strlen(storage.build)+strlen(theip), theip, thehost);
               return "";
	    }
            snprintf(storage.build, BUILD_LENGTH, "%s%s", storage.build, theip);
            bw=strlen(storage.build);
	    break;
	    
	  case 'N':
            if ((int)strlen(storage.build)+2>=BUILD_LENGTH) {
	       if (!toggles.filelogging) 
		 printf("%s: Unable to build string! (strlen(storage.build)+2 >= %d) == %d | (%s == %s)\n",storage.theformat, BUILD_LENGTH,(strlen(storage.build)+2),theip, thehost);
	       else 
		 fprintf(fileid,"%s: Unable to build string! (strlen(storage.build)+2 >= %d) == %d | (%s == %s)\n",storage.theformat, BUILD_LENGTH,(strlen(storage.build)+2),theip, thehost);
               return "";
	    }
	    storage.build[bw]='\n';
	    bw++;
	    break;
	    
	  case 'T':
            if ((int)strlen(storage.build)+2>=BUILD_LENGTH) {
	       if (!toggles.filelogging) 
		 printf("%s: Unable to build string! (strlen(storage.build)+2 >= %d) == %d | (%s == %s)\n",storage.theformat, BUILD_LENGTH,(strlen(storage.build)+2),theip, thehost);
	       else 
		 fprintf(fileid,"%s: Unable to build string! (strlen(storage.build)+2 >= %d) == %d | (%s == %s)\n",storage.theformat, BUILD_LENGTH,(strlen(storage.build)+2),theip, thehost);
               return "";
	    }
	    storage.build[bw]='\t';
	    bw++;
	    break;
	    
	  case 'S':
            if ((int)strlen(storage.build)+2>=BUILD_LENGTH) {
	       if (!toggles.filelogging) 
		 printf("%s: Unable to build string! (strlen(storage.build)+2 >= %d) == %d | (%s == %s)\n",storage.theformat, BUILD_LENGTH,(strlen(storage.build)+2),theip, thehost);
	       else 
		 fprintf(fileid,"%s: Unable to build string! (strlen(storage.build)+2 >= %d) == %d | (%s == %s)\n",storage.theformat, BUILD_LENGTH,(strlen(storage.build)+2),theip, thehost);
               return "";
	    }
	    storage.build[bw]=' ';
	    bw++;
	    break;
	    
	  case 'D':
            if ((int)strlen(storage.build)+2>=BUILD_LENGTH) {
	       if (!toggles.filelogging) 
		 printf("%s: Unable to build string! (strlen(storage.build)+2 >= %d) == %d | (%s == %s)\n",storage.theformat, BUILD_LENGTH,(strlen(storage.build)+2),theip, thehost);
	       else 
		 fprintf(fileid,"%s: Unable to build string! (strlen(storage.build)+2 >= %d) == %d | (%s == %s)\n",storage.theformat, BUILD_LENGTH,(strlen(storage.build)+2),theip, thehost);
               return "";
	    }
	    snprintf(storage.build, BUILD_LENGTH, "%s%d", storage.build, (int)scans);
	    bw=strlen(storage.build);
	    break;
	  default: 
	    printf("%s: Invalid variable: storage.theformat[%i] = %%%c.\n",(h==1)?"-rm":"-m", i-1, storage.theformat[i]); 
	    exit(0); 
	    break;
         }
      }
      else { 
	 storage.build[bw] = storage.theformat[i]; bw++; }
   }
   if (h) 
     if ((storage.eline = (char *) malloc((strlen(storage.build) * sizeof(char))))==NULL) {
        perror("malloc");
        exit(0);
     }
   return((char *)storage.build);
}

void make_sig(void) {
/* lalala, we do want to tell this damn thing what to do when we get hit with these signals, dont we? */
#ifdef GETHOSTBYADDR_TIMEOUT
   signal(SIGALRM, (void (*)())sigalrm_handling);
#endif
   signal(SIGINT, (void (*)())sigint_handling);
   signal(SIGTSTP, (void (*)())sigstp_handling);
   return;
}

void options(char * arg0){
/* Ok ok, this is a given, and whats the answer to the $1000 question? */
   printf("%s-s%s <IP>   : Start IP.	%s-t%s <IP>\t: End IP.
%s-r%s <prog> : Don't resolve hosts, execute this program 
            with the IP as argv[1].
%s-rm%s <arg> : Same as -r but use format option just like 
            -m but without %%h.
            Example: \"<prog> %%i\".
%s-e%s <zone> : Don't scan this zone. 
%s-l%s <file> : Log all lookups to this file.
            If -r || -rm is used, exec info will be logged.
%s-m%s <arg>  : Format for output on lookups.
            Example: \"%%d:%%s%%i%%s==%%s%%h%%n\".
%s-n%s : Don't output IP's that return NULL || timeout.
     If -r || -rm executing info will not be printed.
%s-d%s : Print a single dot before each request is sent.
     If -r || -rm is used print a dot also.
%s-f%s : fork() into background.
%s-x%s : Print debug information for gethostbyaddr().
%s-v%s : Display a list of variables used with -m && -rm.
%sZones%s: 1.2.3.4\n", BOLD, TERM, BOLD, TERM, BOLD, TERM, BOLD, TERM, BOLD, TERM, BOLD, TERM, BOLD, TERM, BOLD, TERM, BOLD, TERM, BOLD, TERM, BOLD, TERM, BOLD, TERM, BOLD, TERM);
    printf("%sUsage%s: %s [options]\n",BOLD, TERM, arg0);
    exit(0);
}

void variables(void) {
   puts("%i: IP.
%h: Hostname (only in -m).
%d: Number of scans.
%n: Character return (enter).
%t: Tab.
%s: Space.
%%: %.");
}

void bubye(int type) {   
   printf("\n-----------------------%s-----------------------\n",(type)?"COMPLETE":"INTERRUPT");
      printf("Scanned               : %d.%d.%d.%d - %s\n", RealStartIP.p1, RealStartIP.p2, RealStartIP.p3, RealStartIP.p4, storage.ip_build);
   if (storage.pexec==NULL && toggles.rm == 0) {
      printf("Successfull           : %3.1f%%\n", (rc+uc==0)?(float)0:(float)(rc) * (float)100 / ((float)rc+(float)uc));
      printf("Unuccessfull          : %3.1f%%\n", (rc+uc==0)?(float)0:(((float)rc+(float)uc) - (float)rc) * (float)100 / ((float)rc+(float)uc)); 
   }
   printf("Total checks          : %d\n", (storage.pexec!=NULL || toggles.rm == 1) ? (int)scans : (int)rc+(int)uc);
   if (storage.pexec==NULL && toggles.rm == 0) {
      printf("Successfull checks    : %d\n", (int)rc);
      printf("Unsuccessfull checks  : %d\n", (int)uc);
   }
   printf("Options               :%s%s%s%s%s%s%s%s%s%s%s%s\n",
      (toggles.debuger)?"'-x'":"",
      (toggles.xip)?" '-t'":"",
      (toggles.uformat)?" '-m'":"",
      (toggles.rm)?" '-rm'":"",
      (toggles.forking)?" '-f'":"",
      (toggles.nonull)?" '-n'":"",
      (toggles.dot)?" '-d'":"",
      (toggles.filelogging)?" '-l'":"",
      (!ScanZone.p1)?" '-e 1'":"",
      (!ScanZone.p2)?" '-e 2'":"",
      (!ScanZone.p3)?" '-e 3'":"",
      (!ScanZone.p4)?" '-e 4'":"");
   if (storage.pexec!=NULL || toggles.rm == 1) 
     printf("No other finishing information, -r || -rm mode used.\a\n");
   printf("Done!\n\a");
   if (toggles.filelogging) {
      fprintf(fileid, "\n-----------------------%s-----------------------\n",(type)?"COMPLETE":"INTERRUPT");
      fprintf(fileid, "Scanned               : %d.%d.%d.%d - %s\n", RealStartIP.p1, RealStartIP.p2, RealStartIP.p3, RealStartIP.p4, storage.ip_build);
      if (storage.pexec==NULL && toggles.rm == 0) {
         fprintf(fileid, "Successfull           : %3.1f%%\n", (rc+uc==0)?(float)0:(float)(rc) * (float)100 / ((float)rc+(float)uc));
         fprintf(fileid, "Unuccessfull          : %3.1f%%\n", (rc+uc==0)?(float)0:(((float)rc+(float)uc) - (float)rc) * (float)100 / ((float)rc+(float)uc)); 
      }
      fprintf(fileid, "Total checks          : %d\n", (storage.pexec!=NULL || toggles.rm == 1) ? (int)scans : (int)rc+(int)uc);
      if (storage.pexec==NULL && toggles.rm == 0) {
         fprintf(fileid, "Successfull checks    : %d\n", (int)rc);
         fprintf(fileid, "Unsuccessfull checks  : %d\n", (int)uc);
      }
      fprintf(fileid,"Options               :%s%s%s%s%s%s%s%s%s%s%s%s\n",
         (toggles.debuger)?"'-x'":"",
         (toggles.xip)?" '-t'":"",
         (toggles.uformat)?" '-m'":"",
         (toggles.rm)?" '-rm'":"",
         (toggles.forking)?" '-f'":"",
         (toggles.nonull)?" '-n'":"",
         (toggles.dot)?" '-d'":"",
         (toggles.filelogging)?" '-l'":"",
         (!ScanZone.p1)?" '-e 1'":"",
         (!ScanZone.p2)?" '-e 2'":"",
         (!ScanZone.p3)?" '-e 3'":"",
         (!ScanZone.p4)?" '-e 4'":"");
      if (storage.pexec!=NULL || toggles.rm == 1) 
	fprintf(fileid, "No other finishing information, -r || -rm mode used.\a\n");
      fprintf(fileid, "Done!\n");
      fflush(fileid);
      fclose(fileid);
   }
   return;
}

void atexit_func(void){
   free(storage.logfile);
   free(storage.pexec);
#ifdef USE_CURSES
   endwin();
#endif
   return;
}

/* EOF */
