/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * By Jean-Marc Jacquet <littleigloo@chez.com> 
 * Copyright (C) 1998 Little Igloo Org  http://www.chez.com/littleigloo
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include "protos.h"


static GtkWidget *msg_file_sel;



static int
samba_post (gchar * header_text, char *temp_filename)
{
  FILE *output;
  gchar command_line[2048];
  gchar buf_line[80];
  int i;

  /* -- launch smbclient and read output from pipe -- */
  sprintf (command_line, "cat %s | smbclient -M \"%s\"", temp_filename, header_text);
  output = popen (command_line, "r");
  i = fread (command_line, 1, sizeof (command_line), output);
  pclose (output);
  command_line[i] = 0;

  /* -- sommaire investigation of the output -- */
  if (strstr (command_line, "nknown host"))
    {
      sprintf (buf_line, "\n\nUnknown host : %s", header_text);
      alert_ok ("Error", buf_line, "ok");
      return FALSE;
    }
  if (strstr (command_line, "error connecting to"))
    {
      sprintf (buf_line, "\n\nHost unreachable: %s", header_text);
      alert_ok ("Error", buf_line, "ok");
      return FALSE;
    }
  if (strstr (command_line, "Control-D\nsent") && strstr (command_line, "bytes (status was"))
    {
      alert_ok ("LinPopUp", "\n\nMessage succesfully sent.", "ok");
      return TRUE;
    }

  alert_ok_text (command_line);
  return TRUE;
}



void
send_send (GtkWidget * widget, gpointer * data)
{
  GtkWidget *send_text;
  GtkWidget *send_header;
  gchar *header_text;
  gchar message_text[2048];
  guint message_length;
  char IS_TRUNCATED = FALSE;
  char *temp_filename;
  int file_handle_temp;


/*-- retrieving send_header and send_text data previously marqued with gtk_object_set_data(...) --*/
  send_header = gtk_object_get_data (GTK_OBJECT (send_window), "send_header");
  send_text = gtk_object_get_data (GTK_OBJECT (send_window), "text");

  /* -- retrieving header text, and checking for a  destination -- */
  if (!strlen (header_text = gtk_entry_get_text (GTK_ENTRY (send_header))))
    {
      alert_ok (" Error", "\nPlease enter a destination.", "Ok");
      return;
    }

  /* -- retrieving message text, cut big texts in parts -- */
  message_length = gtk_text_get_length (GTK_TEXT (send_text));
  if (message_length > 1500)
    {
      IS_TRUNCATED = TRUE;
      strcpy (message_text, gtk_editable_get_chars (GTK_EDITABLE (send_text), 0, 1500));
      message_length = 1500;
      while (message_text[message_length] != 10)
	--message_length;
      message_text[message_length] = 0;
      strcat (message_text, "\n=== TO BE CONTINUED ===");

      gtk_text_freeze (GTK_TEXT (send_text));
      gtk_text_set_point (GTK_TEXT (send_text), message_length);
      gtk_text_backward_delete (GTK_TEXT (send_text), message_length);
      gtk_text_set_point (GTK_TEXT (send_text), 0);

      gtk_text_thaw (GTK_TEXT (send_text));
    }
  else
    {
      strcpy (message_text, gtk_editable_get_chars (GTK_EDITABLE (send_text), 0, -1));
    }

  /* -- write message text to a tempory file -- */
  temp_filename = tmpnam (NULL);
  file_handle_temp = open (temp_filename, O_RDWR | O_CREAT | O_TRUNC, DATA_PERM);
  write (file_handle_temp, message_text, strlen (message_text));
  close (file_handle_temp);

  /* -- cowardly posting it via samba, and close the send window in many case-- */
  if (samba_post (header_text, temp_filename) && !IS_TRUNCATED)
    gtk_widget_destroy (send_window);

  /* -- then remove the tempory file -- */
  unlink (temp_filename);
}



static void
send_cancel (GtkWidget * widget, gpointer * data)
{
  GtkWidget *send_text;

/*-- retrieving send_text data previously marqued with gtk_object_set_data(...) --*/
  send_text = gtk_object_get_data (GTK_OBJECT (send_window), "text");

  /* -- if a message was entered, asking for confirmation -- */
  if (gtk_text_get_length (GTK_TEXT (send_text)))
    if (alert_dialog ("", "\nA new message was entered.\n\nCancel anyway ?", "Yes", "No", 2) == 2)
      return;

  gtk_widget_destroy (send_window);
}




static void
message_load_ok (GtkWidget * widget, GtkFileSelection * file_sel)
{
  char *filename;

  filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION (file_sel));
  if (filename != NULL)
    {
      FILE *in;
      char buf[1024];

      in = fopen (filename, "r");
      if (in == NULL)
	{
	  sprintf (buf, "\n    Unable to Open '%s'    \n", filename);
	  alert_ok ("File Error", buf, "ok");
	}
      else
	{
	  GtkWidget *send_text;

	  send_text = gtk_object_get_data (GTK_OBJECT (send_window), "text");
	  gtk_text_freeze (GTK_TEXT (send_text));
	  while (fgets (buf, 1024, in))
	    {
	      gtk_text_insert (GTK_TEXT (send_text), NULL, &send_text->style->black, NULL, buf, strlen (buf));
	    }
	  gtk_text_thaw (GTK_TEXT (send_text));
	  fclose (in);
	}
    }

  gtk_widget_destroy (GTK_WIDGET (file_sel));
  msg_file_sel = NULL;
}



static void
message_load_cancel (GtkWidget * widget, GtkFileSelection * file_sel)
{
  gtk_widget_destroy (GTK_WIDGET (file_sel));
  msg_file_sel = NULL;
}



void
message_load (GtkWidget * widget, gpointer data)
{
  if (msg_file_sel == NULL)
    {
      msg_file_sel = gtk_file_selection_new ("Load Message text...");
      gtk_signal_connect (GTK_OBJECT (msg_file_sel), "destroy",
			GTK_SIGNAL_FUNC (gtk_widget_destroy), msg_file_sel);
      gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (msg_file_sel)->ok_button), "clicked",
			  GTK_SIGNAL_FUNC (message_load_ok), msg_file_sel);
      gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (msg_file_sel)->cancel_button), "clicked",
		       GTK_SIGNAL_FUNC (message_load_cancel), msg_file_sel);
    }

  if (GTK_WIDGET_VISIBLE (msg_file_sel))
    return;
  else
    gtk_widget_show (msg_file_sel);
}



void
reply_message (void)
{

  if (current_showed_message)
    {
      is_it_a_reply = TRUE;
      send_message ();
    }
}



void
send_message (void)
{
  GtkWidget *send_vbox;
  GtkWidget *send_statusbar;
  GtkWidget *send_frame;
  GtkWidget *send_table;
  GtkWidget *send_button_send;
  GtkWidget *send_button_cancel;
  GtkWidget *send_header;
  GtkWidget *send_text;
  int send_context_id;
  gint x, y;


  msg_file_sel = NULL;

  /* -- First, the window -- */
  send_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_widget_set_usize (GTK_WIDGET (send_window), 425, 400);
  gtk_widget_realize (send_window);
  gtk_window_set_title (GTK_WINDOW (send_window), "LinPopUp");
  gtk_container_border_width (GTK_CONTAINER (send_window), 1);
  gdk_window_get_origin (window->window, &x, &y);
  gtk_widget_set_uposition (send_window, x, y);

  /* -- Vbox as container -- */
  send_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (send_window), send_vbox);
  gtk_widget_show (send_vbox);

  /* -- Top frame first packed to the vbox -- */
  send_frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (send_frame), " Send to :  ");
  gtk_container_border_width (GTK_CONTAINER (send_frame), 2);
  gtk_frame_set_shadow_type (GTK_FRAME (send_frame), GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (send_vbox), send_frame, FALSE, TRUE, 0);

  /* -- Creating frame's widgets -- */
  send_header = gtk_entry_new ();
  gtk_entry_set_editable (GTK_ENTRY (send_header), 1);
  gtk_object_set_data (GTK_OBJECT (send_window), "send_header", send_header);
  gtk_widget_show (send_header);

  send_button_send = gtk_button_new_with_label ("Send");
  gtk_signal_connect (GTK_OBJECT (send_button_send), "clicked",
		      GTK_SIGNAL_FUNC (send_send), NULL);
  gtk_widget_show (send_button_send);

  send_button_cancel = gtk_button_new_with_label ("Cancel");
  gtk_signal_connect (GTK_OBJECT (send_button_cancel), "clicked",
		      GTK_SIGNAL_FUNC (send_cancel), NULL);
  gtk_widget_show (send_button_cancel);

/*-- attaching frame's widget to a table, and packing it to the frame --*/
  send_table = gtk_table_new (2, 4, TRUE);
  gtk_table_set_col_spacings (GTK_TABLE (send_table), 5);
  gtk_table_set_row_spacings (GTK_TABLE (send_table), 5);
  gtk_container_border_width (GTK_CONTAINER (send_table), 10);
  gtk_table_attach (GTK_TABLE (send_table), send_header, 0, 3, 0, 1,
		    GTK_FILL,
		    GTK_FILL, 0, 0);
  gtk_table_attach (GTK_TABLE (send_table), send_button_send, 3, 4, 0, 1,
		    GTK_FILL,
		    GTK_FILL, 0, 0);
  gtk_table_attach (GTK_TABLE (send_table), send_button_cancel, 3, 4, 1, 2,
		    GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
  gtk_container_add (GTK_CONTAINER (send_frame), send_table);
  gtk_widget_show (send_table);
  gtk_widget_show (send_frame);

  /* -- create a menu below the top frame via create_send_menu defined in menu.c-- */
  create_send_menu (send_vbox);

  /* -- and a text area via create_text defined in text.c -- */
  send_text = create_text (send_vbox);
  gtk_text_set_editable (GTK_TEXT (send_text), 1);
  gtk_object_set_data (GTK_OBJECT (send_window), "text", send_text);

  /* -- and finally a statusbar -- */
  send_statusbar = gtk_statusbar_new ();
  gtk_box_pack_start (GTK_BOX (send_vbox), send_statusbar, FALSE, TRUE, 0);
  gtk_widget_show (send_statusbar);
  send_context_id = gtk_statusbar_get_context_id (GTK_STATUSBAR (send_statusbar), " ");

  /* -- show the window -- */
  gtk_widget_show (send_window);

  /* -- connecting the send_cancel function to the delete event -- */
  gtk_signal_connect (GTK_OBJECT (send_window), "delete_event", GTK_SIGNAL_FUNC (send_cancel), NULL);


  /* -- fill the deliver adress if required -- */
  switch (user_rc.deliver)
    {
    case BLANK:
      break;
    case DHOST:
      gtk_entry_set_text (GTK_ENTRY (send_header), user_rc.deliver_adr);
      gtk_editable_select_region (GTK_EDITABLE (send_header), 0, -1);
      break;
    case GUESS:
      if (!strcmp (user_rc.guess_adr, "?"))
	gtk_entry_set_text (GTK_ENTRY (send_header), user_rc.deliver_adr);
      else
	gtk_entry_set_text (GTK_ENTRY (send_header), user_rc.guess_adr);
      gtk_editable_select_region (GTK_EDITABLE (send_header), 0, -1);
      break;
    default:
      break;
    }


  /* -- If this is a reply, fill the destination and text field -- */
  if (is_it_a_reply)
    {
      struct linpopup_message this_message;
      char buf[2045];
      int char_pos_text, char_pos_buf;
      GdkColormap *colormap;

      colormap = gtk_widget_get_colormap (send_window);
      gdk_color_alloc (colormap, &user_rc.quoted_text_col);

      read_message (current_showed_message, &this_message);
      gtk_entry_set_text (GTK_ENTRY (send_header), this_message.host);	//We answer to a host not to a user

      sprintf (buf, "%c %s \n%c ---\n", user_rc.quote, user_rc.quote_string, user_rc.quote);
      strexpand (buf, "HOST", this_message.host);
      strexpand (buf, "USER", this_message.sender);

      gtk_text_freeze (GTK_TEXT (send_text));
      gtk_text_insert (GTK_TEXT (send_text), NULL, &user_rc.quoted_text_col, NULL, buf, -1);

      char_pos_buf = 0;
      buf[char_pos_buf++] = user_rc.quote;
      buf[char_pos_buf++] = 32;

      for (char_pos_text = 0; char_pos_text < strlen (this_message.text); char_pos_text++)
	{
	  buf[char_pos_buf++] = this_message.text[char_pos_text];
	  if (this_message.text[char_pos_text] == 10)
	    {
	      buf[char_pos_buf++] = user_rc.quote;
	      buf[char_pos_buf++] = 32;
	    }
	}
      buf[char_pos_buf++] = 0;
      buf[char_pos_buf++] = 10;
      buf[char_pos_buf] = user_rc.quote;;

      /* -- quoted text appears in user defined color -- */
      strcat (buf, "---");
      gtk_text_insert (GTK_TEXT (send_text), NULL, &user_rc.quoted_text_col, NULL, buf, -1);
      gtk_text_insert (GTK_TEXT (send_text), NULL, &send_text->style->black, NULL, "\n", -1);

      gtk_text_thaw (GTK_TEXT (send_text));
      gtk_text_set_editable (GTK_TEXT (send_text), 1);
      gtk_widget_grab_focus (send_text);

      is_it_a_reply = FALSE;
    }
}
