/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * By Jean-Marc Jacquet <littleigloo@chez.com> 
 * Copyright (C) 1998 Little Igloo Org  http://www.chez.com/littleigloo
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include "protos.h"


static char rc_path[2048];
static GtkWidget *rc_window;
static GtkWidget *rc_spin;
static GtkWidget *rc_quote;
static GtkWidget *rc_header;
static GtkWidget *rc_dhost;
static struct linpopup_custom previous_user_rc;
static char check_flag = 0;
// static GtkWidget *rc_drawingarea_quoted_text; 


static void
save_rc (void)
{
  int file_handle;
  file_handle = open (rc_path, O_CREAT | O_TRUNC | O_WRONLY, RC_PERM);
  write (file_handle, &user_rc, sizeof (user_rc));
  close (file_handle);
}



static void
create_rc (void)
{
  version (user_rc.version);
  user_rc.toolbar_style = GTK_TOOLBAR_BOTH;
  user_rc.message_check_interval = 2000;
  user_rc.hcolors = TRUE;
  user_rc.quote = '|';
  strcpy (user_rc.quote_string, "USER on HOST wrote :");
  user_rc.quoted_text_col.red = 0x8000;
  user_rc.quoted_text_col.green = 0;
  user_rc.quoted_text_col.blue = 0;
  user_rc.deliver = GUESS;
  compile_host (user_rc.deliver_adr);
  strcpy (user_rc.guess_adr, "?");
  save_rc ();
}



static void
read_rc (void)
{
  int file_handle;
  char this_version[6];
  version (this_version);
  file_handle = open (rc_path, O_RDONLY, RC_PERM);
  read (file_handle, &user_rc, sizeof (user_rc));
  close (file_handle);
#ifdef DEBUG
  printf ("\npath :%s\n\n", rc_path);
  printf ("\n version :%s\n check : %i\n quote : %c\n quote_string : %s\n", user_rc.version, user_rc.message_check_interval, user_rc.quote, user_rc.quote_string);
#endif
  if (strcmp (this_version, user_rc.version))
    create_rc ();
}



void
rc_init (void)
{
  char *p;
  if (!(p = getenv ("HOME")))
    fatal_error (2, "HOME");
  sprintf (rc_path, "%s/.linpopuprc", p);
#ifdef DEBUG
  printf ("\n%s\n", rc_path);
#endif
  if (access (rc_path, F_OK))
    create_rc ();
  else
    read_rc ();
}



static void
toolbar_set_style (GtkWidget * widget, GtkToolbarStyle style)
{
  GtkWidget *this_toolbar;

/*-- retrieving main window  toolbar previously marqued with gtk_object_set_data(...) --*/
  this_toolbar = gtk_object_get_data (GTK_OBJECT (window), "toolbar");
  gtk_toolbar_set_style (GTK_TOOLBAR (this_toolbar), style);
  user_rc.toolbar_style = style;
}



static void
icons_set_colors (GtkWidget * widget, char IS_HEIGHT)
{
  user_rc.hcolors = IS_HEIGHT;
}



static void
check_set_interval (GtkWidget * widget, char MUST_CHECK)
{
  check_flag = MUST_CHECK;
  if (!check_flag)
    gtk_widget_hide (rc_spin);
  else
    gtk_widget_show (rc_spin);
}



static void
reply_set_adr (GtkWidget * widget, char deliver)
{
  user_rc.deliver = deliver;
}



static void
custom_ok (GtkWidget * widget)
{
  if (check_flag)
    user_rc.message_check_interval = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (rc_spin)) * 1000;
  else
    user_rc.message_check_interval = 0;
  user_rc.quote = *gtk_entry_get_text (GTK_ENTRY (rc_quote));
  strcpy (user_rc.quote_string, gtk_entry_get_text (GTK_ENTRY (rc_header)));
  strcpy (user_rc.deliver_adr, gtk_entry_get_text (GTK_ENTRY (rc_dhost)));
  save_rc ();
  gtk_widget_destroy (rc_window);
}



static void
custom_cancel (GtkWidget * widget)
{
  user_rc = previous_user_rc;
  toolbar_set_style (widget, user_rc.toolbar_style);
  save_rc ();
  gtk_widget_destroy (rc_window);
}


static void
custom_reset (GtkWidget * widget)
{
  create_rc ();
  toolbar_set_style (widget, user_rc.toolbar_style);
  gtk_widget_destroy (rc_window);
}



void
custom_notebook (void)
{
  GtkWidget *rc_table;
  GtkWidget *rc_notebook;
  GtkWidget *rc_vbox;
  GtkWidget *rc_frame;
  GtkWidget *rc_frame_table;
  GtkWidget *rc_radio_text;
  GtkWidget *rc_radio_icons;
  GtkWidget *rc_radio_both;
  GtkWidget *rc_radio_check;
  GtkWidget *rc_radio_never;
  GtkWidget *rc_radio_hcolors;
  GtkWidget *rc_radio_mcolors;
  GtkWidget *rc_radio_default;
  GtkWidget *rc_radio_guess;
  GtkWidget *rc_radio_blank;
  GtkWidget *rc_label;
  GtkWidget *rc_button_ok;
  GtkWidget *rc_button_cancel;
  GtkWidget *rc_button_reset;
  GtkObject *rc_adj;
  gint check_interval;
  char quote[2];
  gint x, y;


  previous_user_rc = user_rc;

  /* -- create the window and place it -- */
  rc_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_widget_set_usize (GTK_WIDGET (rc_window), 425, 400);
  gtk_widget_realize (rc_window);
  gtk_window_set_title (GTK_WINDOW (rc_window), "Preferences");
  gtk_container_border_width (GTK_CONTAINER (rc_window), 1);
  gdk_window_get_origin (window->window, &x, &y);
  gtk_widget_set_uposition (rc_window, x, y);

  gtk_signal_connect (GTK_OBJECT (rc_window), "delete_event", GTK_SIGNAL_FUNC (custom_cancel), NULL);


  /* -- a table to pack widgets -- */
  rc_table = gtk_table_new (15, 17, FALSE);
  gtk_container_add (GTK_CONTAINER (rc_window), rc_table);
  gtk_container_border_width (GTK_CONTAINER (rc_table), 5);

  /* -- Create a new notebook, and pack it to the table -- */
  rc_notebook = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (rc_notebook), GTK_POS_TOP);
  gtk_table_attach (GTK_TABLE (rc_table), rc_notebook, 0, 15, 0, 16, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);
  gtk_widget_show (rc_notebook);



  /* -- Toolbar properties  page -- */
  rc_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (rc_vbox), 5);
  gtk_widget_show (rc_vbox);

  /* -- The view Frame -- */
  rc_frame = gtk_frame_new (" View :  ");
  gtk_container_border_width (GTK_CONTAINER (rc_frame), 0);
  gtk_widget_set_usize (rc_frame, 400, 150);
  gtk_box_pack_start (GTK_BOX (rc_vbox), rc_frame, FALSE, FALSE, 0);
  gtk_widget_show (rc_frame);

  rc_frame_table = gtk_table_new (1, 5, TRUE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);

  rc_radio_both = gtk_radio_button_new_with_label (NULL, "Icons and text");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_both, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_both);

  rc_radio_icons = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_both)), "Icons only");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_icons, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_icons);

  rc_radio_text = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_both)), "Text only");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_text, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_text);

  gtk_signal_connect_object (GTK_OBJECT (rc_radio_both), "clicked", GTK_SIGNAL_FUNC (toolbar_set_style), GINT_TO_POINTER (GTK_TOOLBAR_BOTH));
  gtk_signal_connect_object (GTK_OBJECT (rc_radio_icons), "clicked", GTK_SIGNAL_FUNC (toolbar_set_style), GINT_TO_POINTER (GTK_TOOLBAR_ICONS));
  gtk_signal_connect_object (GTK_OBJECT (rc_radio_text), "clicked", GTK_SIGNAL_FUNC (toolbar_set_style), GINT_TO_POINTER (GTK_TOOLBAR_TEXT));

  switch (user_rc.toolbar_style)
    {
    case GTK_TOOLBAR_TEXT:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_text), TRUE);
      break;
    case GTK_TOOLBAR_ICONS:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_icons), TRUE);
      break;
    default:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_both), TRUE);
    }

  gtk_container_add (GTK_CONTAINER (rc_frame), rc_frame_table);
  gtk_widget_show (rc_frame_table);


  /* -- the icons default frame -- */
  rc_frame = gtk_frame_new (" *Icons default :   ");
  gtk_container_border_width (GTK_CONTAINER (rc_frame), 0);
  gtk_widget_set_usize (rc_frame, 400, 125);
  gtk_box_pack_start (GTK_BOX (rc_vbox), rc_frame, TRUE, FALSE, 0);
  gtk_widget_show (rc_frame);

  rc_frame_table = gtk_table_new (1, 4, TRUE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);

  rc_radio_hcolors = gtk_radio_button_new_with_label (NULL, "High colors set");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_hcolors, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_hcolors);

  rc_radio_mcolors = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_hcolors)), "Minimum colors set");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_mcolors, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_mcolors);

  gtk_container_add (GTK_CONTAINER (rc_frame), rc_frame_table);
  gtk_widget_show (rc_frame_table);

  gtk_signal_connect_object (GTK_OBJECT (rc_radio_hcolors), "clicked", GTK_SIGNAL_FUNC (icons_set_colors), GINT_TO_POINTER (TRUE));
  gtk_signal_connect_object (GTK_OBJECT (rc_radio_mcolors), "clicked", GTK_SIGNAL_FUNC (icons_set_colors), GINT_TO_POINTER (FALSE));

  if (user_rc.hcolors)
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_hcolors), TRUE);
  else
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_mcolors), TRUE);

  rc_label = gtk_label_new (" Toolbar properties  ");
  gtk_notebook_append_page (GTK_NOTEBOOK (rc_notebook), rc_vbox, rc_label);




  /* -- Messages  page -- */
  rc_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (rc_vbox), 5);
  gtk_widget_show (rc_vbox);


  /* -- Check interval frame -- */
  rc_frame = gtk_frame_new (" *Check for incoming messages :  ");
  gtk_container_border_width (GTK_CONTAINER (rc_frame), 0);
  gtk_widget_set_usize (rc_frame, 400, 80);
  gtk_box_pack_start (GTK_BOX (rc_vbox), rc_frame, FALSE, FALSE, 0);
  gtk_widget_show (rc_frame);


  rc_frame_table = gtk_table_new (2, 5, FALSE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);


  rc_radio_check = gtk_radio_button_new_with_label (NULL, "Every ... second(s)");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_check, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_check);

  rc_radio_never = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_check)), "Never");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_never, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_never);

  if (user_rc.message_check_interval)
    check_interval = (guint32) user_rc.message_check_interval / 1000;
  else
    check_interval = 2;

  rc_adj = gtk_adjustment_new (check_interval, 1, 10, 1, 0, 0);
  rc_spin = gtk_spin_button_new (GTK_ADJUSTMENT (rc_adj), 0, 0);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (rc_spin), GTK_UPDATE_ALWAYS);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_spin, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_spin);

  gtk_signal_connect_object (GTK_OBJECT (rc_radio_check), "clicked", GTK_SIGNAL_FUNC (check_set_interval), GINT_TO_POINTER (TRUE));
  gtk_signal_connect_object (GTK_OBJECT (rc_radio_never), "clicked", GTK_SIGNAL_FUNC (check_set_interval), GINT_TO_POINTER (FALSE));


  if (!user_rc.message_check_interval)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_never), TRUE);
      check_flag = FALSE;
    }
  else
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_check), TRUE);
      check_flag = TRUE;
    }

  gtk_container_add (GTK_CONTAINER (rc_frame), rc_frame_table);
  gtk_widget_show (rc_frame_table);



  /* -- Reply frame -- */
  rc_frame = gtk_frame_new (" Reply :  ");
  gtk_container_border_width (GTK_CONTAINER (rc_frame), 0);
  gtk_widget_set_usize (rc_frame, 400, 80);
  gtk_box_pack_start (GTK_BOX (rc_vbox), rc_frame, FALSE, FALSE, 5);
  gtk_widget_show (rc_frame);

  rc_frame_table = gtk_table_new (2, 5, FALSE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);


  gtk_container_add (GTK_CONTAINER (rc_frame), rc_frame_table);
  gtk_widget_show (rc_frame_table);

  rc_label = gtk_label_new ("Quote character :");
  gtk_misc_set_alignment (GTK_MISC (rc_label), 0, 0);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_label);

  sprintf (quote, "%c", user_rc.quote);

  rc_quote = gtk_entry_new_with_max_length (1);
  gtk_entry_set_text (GTK_ENTRY (rc_quote), quote);
  gtk_entry_set_editable (GTK_ENTRY (rc_quote), 1);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_quote, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_quote);


  rc_label = gtk_label_new ("Reply Header :");
  gtk_misc_set_alignment (GTK_MISC (rc_label), 0, 0);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_label);

  rc_header = gtk_entry_new_with_max_length (50);
  gtk_entry_set_text (GTK_ENTRY (rc_header), user_rc.quote_string);
  gtk_entry_set_editable (GTK_ENTRY (rc_header), 1);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_header, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_header);


  /* -- host frame -- */
  rc_frame = gtk_frame_new (" Delivery adress :  ");
  gtk_container_border_width (GTK_CONTAINER (rc_frame), 0);
  gtk_widget_set_usize (rc_frame, 400, 100);
  gtk_box_pack_start (GTK_BOX (rc_vbox), rc_frame, FALSE, FALSE, 5);
  gtk_widget_show (rc_frame);

  rc_frame_table = gtk_table_new (2, 5, FALSE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);


  gtk_container_add (GTK_CONTAINER (rc_frame), rc_frame_table);
  gtk_widget_show (rc_frame_table);



  rc_radio_default = gtk_radio_button_new_with_label (NULL, "Use default host :");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_default, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_default);

  rc_radio_guess = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_default)), "Guess");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_guess, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_guess);

  rc_radio_blank = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_default)), "Leave blank");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_blank, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_blank);


  rc_dhost = gtk_entry_new_with_max_length (100);
  gtk_entry_set_text (GTK_ENTRY (rc_dhost), user_rc.deliver_adr);
  gtk_entry_set_editable (GTK_ENTRY (rc_dhost), 1);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_dhost, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 10, 0);
  gtk_widget_show (rc_dhost);

  gtk_signal_connect_object (GTK_OBJECT (rc_radio_default), "clicked", GTK_SIGNAL_FUNC (reply_set_adr), GINT_TO_POINTER (DHOST));
  gtk_signal_connect_object (GTK_OBJECT (rc_radio_blank), "clicked", GTK_SIGNAL_FUNC (reply_set_adr), GINT_TO_POINTER (BLANK));
  gtk_signal_connect_object (GTK_OBJECT (rc_radio_guess), "clicked", GTK_SIGNAL_FUNC (reply_set_adr), GINT_TO_POINTER (GUESS));


  switch (user_rc.deliver)
    {
    case DHOST:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_default), TRUE);
      break;
    case BLANK:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_blank), TRUE);
      break;
    default:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_guess), TRUE);
    }



  rc_label = gtk_label_new (" Messages  ");
  gtk_notebook_append_page (GTK_NOTEBOOK (rc_notebook), rc_vbox, rc_label);



  /* -- and here are the 3 buttons "DONE"   "CANCEL" and "RESET"-- */
  rc_button_ok = gtk_button_new_with_label ("Done");
  gtk_table_attach (GTK_TABLE (rc_table), rc_button_ok, 0, 6, 16, 17, GTK_FILL,
		    GTK_FILL | GTK_EXPAND, 0, 5);
  gtk_widget_show (rc_button_ok);

  GTK_WIDGET_SET_FLAGS (rc_button_ok, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (rc_button_ok);

  rc_button_cancel = gtk_button_new_with_label ("Cancel");
  gtk_table_attach (GTK_TABLE (rc_table), rc_button_cancel, 7, 12, 16, 17, GTK_FILL,
		    GTK_FILL | GTK_EXPAND, 0, 5);
  gtk_widget_show (rc_button_cancel);

  rc_button_reset = gtk_button_new_with_label ("Reset Defaults");
  gtk_table_attach (GTK_TABLE (rc_table), rc_button_reset, 13, 15, 16, 17, GTK_FILL,
		    GTK_FILL, 0, 5);
  gtk_widget_show (rc_button_reset);

  gtk_signal_connect_object (GTK_OBJECT (rc_button_ok), "clicked", GTK_SIGNAL_FUNC (custom_ok), NULL);
  gtk_signal_connect_object (GTK_OBJECT (rc_button_cancel), "clicked", GTK_SIGNAL_FUNC (custom_cancel), NULL);
  gtk_signal_connect_object (GTK_OBJECT (rc_button_reset), "clicked", GTK_SIGNAL_FUNC (custom_reset), NULL);


  gtk_widget_show (rc_table);
  gtk_widget_show (rc_window);
}
