/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * By Jean-Marc Jacquet <littleigloo@chez.com>  
 * Copyright (C) 1998 Little Igloo Org  http://www.chez.com/littleigloo
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "protos.h"


static GtkWidget *colorseldlg = NULL;
static GtkWidget *current_drawingarea;
static GdkColor initial_selected_color;



void
drawingarea_paint (GtkWidget * widget, GdkColor * that_color)
{
  GdkColormap *colormap;
  GdkColor this_color;


  this_color.red = that_color->red;
  this_color.green = that_color->green;
  this_color.blue = that_color->blue;
  colormap = gdk_window_get_colormap (widget->window);
  gdk_color_alloc (colormap, &this_color);
  gdk_window_set_background (widget->window, &this_color);
  gdk_window_clear (widget->window);
  gdk_window_show (widget->window);

}




static void
color_select_ok (GtkWidget * widget, gpointer * data)
{
  gtk_widget_destroy (colorseldlg);
  colorseldlg = NULL;
}



static void
color_select_cancel (GtkWidget * widget, gpointer * data)
{
  selected_color = initial_selected_color;
  //drawingarea_paint (current_drawingarea);
  gtk_widget_destroy (colorseldlg);
  colorseldlg = NULL;
}



static void
color_changed_cb (GtkWidget * widget, GtkColorSelection * colorsel)
{
  gdouble color[3];
  //GdkColor gdk_color;
  GdkColormap *colormap;

  colormap = gdk_window_get_colormap (current_drawingarea->window);

  gtk_color_selection_get_color (colorsel, color);

  selected_color.red = (guint16) (color[0] * 65535.0);
  selected_color.green = (guint16) (color[1] * 65535.0);
  selected_color.blue = (guint16) (color[2] * 65535.0);

  gdk_color_alloc (colormap, &selected_color);
  gdk_window_set_background (current_drawingarea->window, &selected_color);
  gdk_window_clear (current_drawingarea->window);
}


void
colorselec (GtkWidget * widget)
{
  GtkWidget *colorsel;
  gdouble color[3];


  if (colorseldlg == NULL)
    {
      current_drawingarea = widget;

      initial_selected_color = selected_color;

      //selected_color=widget->style->bg[4];

      colorseldlg = gtk_color_selection_dialog_new ("Select  color");
      colorsel = GTK_COLOR_SELECTION_DIALOG (colorseldlg)->colorsel;


      gtk_signal_connect (GTK_OBJECT (colorsel), "color_changed", (GtkSignalFunc) color_changed_cb, (gpointer) colorsel);
      gtk_widget_hide (GTK_WIDGET (GTK_COLOR_SELECTION_DIALOG (colorseldlg)->help_button));

      color[0] = ((gdouble) selected_color.red) / 65535.0;
      color[1] = ((gdouble) selected_color.green) / 65535.0;
      color[2] = ((gdouble) selected_color.blue) / 65535.0;

      gtk_color_selection_set_color (GTK_COLOR_SELECTION (colorsel), color);
      gtk_signal_connect_object (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (colorseldlg)->ok_button), "clicked",
				 GTK_SIGNAL_FUNC (color_select_ok), NULL);
      gtk_signal_connect_object (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (colorseldlg)->cancel_button), "clicked",
			       GTK_SIGNAL_FUNC (color_select_cancel), NULL);
      gtk_widget_show (colorseldlg);
    }

}
