#include <stdio.h>
#include <unistd.h>

#include "config.h"

#define OPTIONS "dDsr21R"

int   DEBUG  =0;
FILE *PS2    =NULL;
int   HPS2;
char *DEVICE =PS2_DEVICE;

void           w(unsigned char cmd);
unsigned char  r(void);
void           sampleRate(unsigned char rate);
void           resolution(unsigned char resolution);
void           by2(void);
void           by1(void);
void           reset(void);

void           usage(char *name);

int main(int argc,char * argv[])
{
int   response;

  if (argc==1) { usage(argv[0]);return 1; }
  
  response=getopt(argc,argv,OPTIONS);
  while (response!=EOF) {
    switch(response) {
      case 'd' : DEBUG=1;
      break;
      case 'D' : { if (PS2!=NULL) { 
                     fprintf(stderr,"Already opened device '%s'\n",DEVICE);
                     exit(1);
                   }
                   else { 
                     DEVICE=argv[optind]; 
                     printf("setting device to '%s'\n",DEVICE);
                   }
                  }
      break;
      case 's' : { int rate=atoi(argv[optind]);
                     sampleRate(rate);
                 }
      break;
      case 'r' : { int count=atoi(argv[optind]);
                     resolution(count);
                 }
      break;
      case '2' : { by2(); }
      break;
      case '1' : { by1(); }
      break;
      case 'R' : { reset(); }
      break;
    } 
    response=getopt(argc,argv,OPTIONS);
  }

return 0;
}

void w(unsigned char cmd)
{
int count;
   if (PS2==NULL) {
     PS2=fopen(DEVICE,"a+b");
     if (PS2==NULL) { 
       fprintf(stderr,"Can't open device '%s'\n",DEVICE);
       exit(1);
     }
     HPS2=fileno(PS2);
   }

   count=write(HPS2,&cmd,1);
   if (DEBUG) { 
     printf("w %-02x %d\n",cmd,count);
   }
   if (count!=1) { 
     fprintf(stderr,"Can't write device '%s'\n",DEVICE);
     exit(1);
   }
}

unsigned char r(void)
{
unsigned char response;
int count;

   if (PS2==NULL) {
     fprintf(stderr,"No device has been opened\n");
     exit(1);
   }

   count=read(HPS2,&response,1);
   if (DEBUG) {
     printf("r %-02x %d\n",response,count);
   }
   if (count!=1) {
     fprintf(stderr,"Can't read device '%s'\n",DEVICE);
     exit(1);
   }

return response;
}

void sampleRate(unsigned char rate)
{
   switch(rate) {
     case 10:
     case 20:
     case 40:
     case 60:
     case 80:
     case 100:
     case 200:
     break;
     default:
       fprintf(stderr,"%d is not a valid sample rate\n",rate);
       rate=100;
   }
   printf("Setting ps2 sample rate to %d\n",rate);
   w(0xf3);r();
   w(rate);r();
}

void resolution(unsigned char count)
{
char res;
   switch(count) {
      case 1 : res=0x00;
      break;
      case 2 : res=0x01;
      break;
      case 4 : res=0x02;
      break;
      case 8 : res=0x03;
      break;
      default:
        fprintf(stderr,"%d is not a valid resolution (count/mm)\n",count);
        resolution(4);
        return;
   }
   printf("Setting ps2 resolution to %d/mm\n",count);
   w(0xe8);r();
   w(res);r();
}

void by2(void)
{
  printf("Setting ps2 scaling to 2:1\n");
  w(0xe7);r();
}

void by1(void)
{
  printf("Setting ps2 scaling to 1:1\n");
  w(0xe6);r();
}

void reset(void)
{
  printf("Resetting ps2 device\n");
  w(0xff);r();r();r();
}

void usage(char *name)
{
  fprintf(stderr,"ps2set v1.1\n"
                 "\n"
                 "usage: ps2set <option(s)>\n"
                 "       -d --> enter debug mode\n"
                 "       -D <device>\n"
                 "       -R reset\n"
                 "       -s <Sample Rate (10,20,40,60,80,100,200)>\n"
                 "       -r <resolution  (Counts/mm)\n"
                 "       -2 scaling 2:1\n"
                 "       -1 scaling 1:1\n"
                 "\n"
                 "  Note: order of the options matters\n"
                 "\n"
                 "(c/p) Hans Dijkema 2001, License GPL2\n"
         );
}
