
HASH		"#"
SPACES		(" "|\t)*
INCLUDE 	include
OPEN		("<"|["])
CLOSE		(">"|["])
NOTCLOSE	([^>"\n]*)

COMMENT_BEGIN	"/*"
COMMENT_END	"*/"
COMMENT		"//"(.*)

INCLSTMT	{HASH}{SPACES}{INCLUDE}{SPACES}{OPEN}{NOTCLOSE}{CLOSE}

%{
#include <stdio.h>
#include <string.h>
#ifdef HPUX
#ifndef GCC
#include <strings.h>

//#include <abc.h>
//#include "abc.h"

char *strdup(char *);
#endif
#endif

#define SPACE(a)	(a==' ' || a=='\t')
#define MAXFILES  	10000

static int skip=0;
static char *files[MAXFILES];
static int Nfiles=0;

static char *trim(char *s);
static void  prt(char *t); 

%}

%%
{INCLSTMT}	{ if (!skip) { prt(yytext); } }
{COMMENT_BEGIN}	{ skip+=1; }
{COMMENT_END}	{ skip-=1;if (skip<0) { skip=0; } }
{COMMENT}	{}
.		{}
\n		{}

%%
static char *trim(char *s)
{
int  i;
static char line[1024],*l;
  strcpy(line,s);
  for(i=strlen(line)-1;SPACE(line[i]);i--);
  line[i+1]='\0';
  for(l=line;SPACE(l[0]);l++);
return l;
}

static void prt(char *yytext)
{
  if (!skip) {
    int i;
    char *s;
      for(s=yytext;s[0]!='<' && s[0]!='"';s++);
      s+=1;
      for(i=0;s[i]!='>' && s[i]!='"';i++);
      s[i]='\0'; 
      files[Nfiles++]=strdup(trim(s));
  }
}


static int in(char **list,char *s)
{
  /* 
     `find .` gives ./FILE in stead of FILE
     list[0]+2 takes that into account.
  */

  for(;list[0]!=NULL && strcmp(s,list[0])!=0 && strcmp(s,list[0]+2)!=0;list++);
return list[0]!=NULL;
}

int main(int argc,char *argv[])
{
int i;
  yylex();

  files[Nfiles]=NULL;
  for(i=0;i<Nfiles;i++) {
    if (in(&argv[1],files[i]) && !in(&files[i+1],files[i])) {
      printf("%s\n",files[i]);
    }
  }
  printf("\n");

return 0;
}

