/*
	MultiMouse - bind MULTIple mice into a MOUSE -
	Copyright (C) 1995 Takashi MANABE (manabe@papilio.tutics.tut.ac.jp)

	MultiMouse is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published
	by the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	MultiMouse is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <termios.h>
#include <sys/types.h>
#include <sys/time.h>
#include <signal.h>

#include "mumse.h"

static
void InitMouse(int mfd, u_short baud, u_short cflag)
{
    struct termios mio;

    tcgetattr(mfd, &mio);
    mio.c_iflag = IGNBRK | IGNPAR;
    mio.c_oflag = mio.c_lflag = mio.c_line = 0;
    mio.c_cc[VTIME] = 0;
    mio.c_cc[VMIN] = 1;
    mio.c_cflag = cflag | baud;
    tcsetattr(mfd, TCSAFLUSH, &mio);
    mio.c_cflag = cflag | B1200;
    write(mfd, "*n", 2);
    usleep(100000);
    tcsetattr(mfd, TCSAFLUSH, &mio);
}

static
int SetupMouse(int argc, char **argv)
{
    int i, type, fd, n, noemu, nodaemon=0, num;

    struct mouseConf {
	const char *name;
	int cFlag;
	struct mouseProtocol mp;
    } miceConf[] = {
	{"Microsoft", (CS7|CREAD|CLOCAL|HUPCL),
	     {0x40, 0x40, 0x40, 3}},
	{"BusMouse", 0,
	     {0xf8, 0x80, 0x00, 5}},
	{"MmSeries", (CS8|PARENB|PARODD|CREAD|CLOCAL|HUPCL),
	     {0xe0, 0x80, 0x80, 3}},
	{"Logitech", (CS8|CSTOPB|CREAD|CLOCAL|HUPCL),
	     {0xe0, 0x80, 0x80, 3}},
	{"PS2", 0,
	     {0xc0, 0x00, 0x40, 3}},
	{"MouseSystems", (CS8|CSTOPB|CREAD|CLOCAL|HUPCL),
	     {0xf8, 0x80, 0x00, 5}}
    };

    for (num = 0, i = 1; i < argc && num < MAX_MICE; i ++) {
	if (*argv[i] == '-') {
	    for (type = 0; type < MOUSE_NOMOUSE; type ++) {
		int len;
		char *name;

		name = (char*)miceConf[type].name;
		len = strlen(name);
		if (!strncasecmp(argv[i] + 1, name, len)) {
		    if (!(noemu = strcasecmp(argv[i] + 1 + len, "-emu")))
			fprintf(stderr,
				" -- \"%s\" 3 buttons emu mode.\n",
				argv[i] + 1);
		    break;
		}
	    }
	}
	if (type < MOUSE_NOMOUSE) {
	    if (++ i >= argc) {
		fprintf(stderr, " -- No device is specified for \"%s\".\n",
			argv[i-1]);
		continue;
	    }
	    if ((fd = open(argv[i], O_RDONLY)) < 0) {
		perror(argv[i]);
		fprintf(stderr, " -- option \"%s %s\" is ignored.\n",
			argv[i-1], argv[i]);
		continue;
	    }
	    msInfo[num].type = type;
	    msInfo[num].noemu = noemu;
	    msInfo[num].fd = fd;
	    msInfo[num].mp = miceConf[type].mp;
	    if (type != MOUSE_BUSMOUSE && type != MOUSE_PS2) {
		InitMouse(fd, B9600, miceConf[type].cFlag);
		InitMouse(fd, B4800, miceConf[type].cFlag);
		InitMouse(fd, B2400, miceConf[type].cFlag);
		InitMouse(fd, B1200, miceConf[type].cFlag);
		if (type == MOUSE_LOGITECH) {
		    write(fd, "S", 1);
		    InitMouse(fd, B1200,
			      CS8|PARENB|PARODD|CREAD|CLOCAL|HUPCL);
		}
	    }
	    write(fd, "Q", 1);
	    num ++;
	}
	else if (!strcasecmp(argv[i], "-nodaemon")) nodaemon = 1;
    }
    if (num <= 0) {
	fprintf(stderr, "Usage: %s {-<protocol> <dev>}\n"
		"   protocol(s):",
		argv[0]);
	for (type = 0; type < MOUSE_NOMOUSE; type ++)
	    fprintf(stderr, " %s", miceConf[type].name);
	fprintf(stderr, "\n");
	return(EOF);
    }
    msFifo = open(MOUSE_FIFO, O_RDWR|O_NONBLOCK);
    if (!nodaemon && MakeMeDaemon()) return(EOF);
    return(num);
}

int main(int argc, char **argv)
{
    int numMouse;

    fprintf(stderr, "MultiMouse version "VERSION"\n");
    if (!access(PATH_PID, F_OK)) {
	fprintf(stderr, " -- MultiMouse is already running\n"
		"    or "PATH_PID" isn't removed.\n");
	return(EOF);
    }
    numMouse = SetupMouse(argc, argv);
    if (numMouse < 0) exit(EOF);
    SetSignals();
    Selection(numMouse);
    exit(0);
}
