/* ---------------------------------------------------------------------------
 *
 *    VMSCRYPT	Unix crypt()-like front-end to the Shawn Clifford's lgi$hpwd()
 *		function. This function may be used from various programs 
 *		dealing with user authentication (e.g. login, radius server,
 *		proxy and Web server authenticators etc.), when OpenVMS (TM)
 *		password are needed to be used. Since it is very similar to
 *		standard crypt(), code changes necessary for using this
 *		function are minimal.
 *
 *    Author:	Berislav Todorovic <BERI@etf.bg.ac.yu>, (C) 06/06/1999
 *
 *    Credits:	This program makes use of the HPWD package, originally written
 *		by Shawn A. Clifford <sysop@robot.nuceng.ufl.edu>, slightly
 *		modified - to perform exit() only in fatal internal error
 *		conditions. The original HPWD package may be obtained from
 *		ftp://ftp.spc.edu/macro32/savesets/hpwd.zip.
 *
 *    Usage:	char *VMScrypt (
 *			const char *username,  -> User login name
 *			const char *password,  -> Clear-text password
 *			unsigned char encrypt, -> VMS crypt algorithm (1-3)
 *			unsigned short salt    -> 4-byte VMS encryption salt
 *
 *    Returns:	VMS-encrypted password ("hashed password"), enclosed in the
 *		27-byte long character string of the following format:
 *
 *			##/e/ssss/hhhhhhhh/llllllll
 *
 *		where e = encryption algorithm (1-3), ssss = 4-byte salt,
 *		hhhhhhhh = high hash quadword, llllllll = low hash quadword
 *		(1 quadword = 8 bytes). The "##" string denotes VMS
 *		password and allows mixed usage of OpenVMS (TM) and Unix
 *		passwords in the same passwd file.
 *
 *    License:  This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *
 * ---------------------------------------------------------------------------
 */

#include <stdio.h>
#ifdef VMS
#	include <string.h>		/* For memset/memcpy */
#else
#	include <memory.h>
#endif

#include "descrip.h"

#define SS$_NORMAL 1
#define SS$_ABORT  44

typedef struct dsc$descriptor_s string;

extern int lgi$hpwd (
	string *output_hash,
	string *password,
	unsigned char encrypt,
	unsigned short salt,
	string *username);

extern void reverse_buf (char *buf, int size);

char result[27];			/* Result - ##/e/salt/highquad/low_quad */

char *VMScrypt (
		const char *username,	/* User login name */
		const char *cleartext,	/* User's cleartext password */
		unsigned char encrypt,	/* Value of UAI$_ENCRYPT field */
		unsigned short salt)	/* Value of UAI$_SALT field */
{
char obuf[8];				/* Output buffer */
char pbuf[31];				/* Password buffer */
char ubuf[31];				/* Username buffer */
unsigned long l_low, l_high;		/* High and low part of hash */
int temp, i, status;

/* Initialize descriptors & buffers */
struct dsc$descriptor_s outdsc = {sizeof(obuf),0,0,obuf};
struct dsc$descriptor_s pwddsc = {sizeof(pbuf),0,0,pbuf};
struct dsc$descriptor_s usrdsc = {sizeof(ubuf),0,0,ubuf};

memset (obuf, 0, sizeof(obuf));
memset (pbuf, 0, sizeof(pbuf));
memset (ubuf, 0, sizeof(ubuf));

strncpy(ubuf, username, 12);			/* fgets stores the newline    */
usrdsc.dsc$w_length = strlen(ubuf);

strncpy(pbuf, cleartext, 31);
pwddsc.dsc$w_length = strlen(pbuf);

for (i=0; i<strlen(ubuf); i++)
   ubuf[i] = toupper(ubuf[i]);

for (i=0; i<strlen(pbuf); i++)
   pbuf[i] = toupper(pbuf[i]);

/* Hash the password */
if ( lgi$hpwd(&outdsc, &pwddsc, encrypt, salt, &usrdsc) != SS$_NORMAL )
   return NULL;

memcpy(&l_low, obuf, 4);
memcpy(&l_high, obuf+4, 4);

#ifdef DEBUG
printf("\nNumeric result (high low):  %08X %08X\n", l_high, l_low);
#endif

sprintf (result, "##/%1d/%04X/%08X/%08X\0", encrypt, salt, l_high, l_low);
return (&result[0]);

} /* VMScrypt() */
