/* ---------------------------------------------------------------------------
 *
 *    VMSAUTH 	A sample authenticator program, which servers as an example
 *		to the VMScrypt() function usage, along with the existing
 *              fgetpwnam() Unix interface.
 *
 *    Author:	Berislav Todorovic <BERI@etf.bg.ac.yu>, (C) 06/06/1999
 *
 *    Remarks:	A passwd-like file, called passwd.vms, should be present in
 *		the current directory. The name and location of that file
 *		can be easily changed (see # define PASSWDFILE ...). That
 *		file should be prepared on an OpenVMS system, by using one
 *		of the fortran programs, included in this distribution
 *		(vms/uaf2pwd1.for, vms/uaf2pwd2.for).
 *
 *    License:  This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *
 * ---------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>

#define  PRINT_RESULT	1
#define  PASSWDFILE	"passwd.vms"	

char username[31];
char password[31];
unsigned char encrypt;
unsigned short salt;

struct passwd *pw;

main (int argc, char *argv[]) {
	int i;
	FILE *file;
	char saltbuff[5];

	if ( argc < 3 ) {
	   printf ("Username: ");
	   scanf ("%s", username);
	   strncpy ((char *) password, (char *) getpass ("Password: "), 31);
	} else {
	   strncpy ((char *) username, (char *) argv[1], 12);
	   strncpy ((char *) password, (char *) argv[2], 31); 
	} 
	if ( !(file = fopen (PASSWDFILE, "r")) ) {
	   printf ("Could not open passwd file\n");
	   exit (2);
	}
	while ( !feof(file) ) {
	   pw = fgetpwent (file);
	   if (feof(file)) {
#ifdef PRINT_RESULT
	      fprintf (stderr, "*** FAILED - No such user! ***\n");
#endif
	      fclose (file);
	      exit (0);
	   }
	   if ( strncmp (username, pw->pw_name, strlen(pw->pw_name)) )
	      continue;
	   fclose(file);
	   encrypt=(pw->pw_passwd)[3] - '0';
	   strncpy ((char *) saltbuff, (char *) (pw->pw_passwd+5), 4);
	   saltbuff[4] = '\0';
   	   sscanf (saltbuff, "%X", &salt);
	   if (!strncmp ((char *) VMScrypt (username, password, encrypt, salt), (char *) pw->pw_passwd, 27)) {
#ifdef PRINT_RESULT
	      fprintf (stderr, "OK\n");
#endif
	      exit (1);
	   } else {
#ifdef PRINT_RESULT
	      fprintf (stderr, "*** FAILED - Invalid password! ***\n");
#endif
	      exit (0);
	   }
	}
} /* main () */
