C -----------------------------------------------------------------------------
C
C    UAF2PASSWD.FOR - Convert user information from OpenVMS user database
C                     (SYSUAF.DAT) to Un*x passwd file.
C
C    AUTHOR         - Berislav Todorovic, (C) 06/06/1999.
C
C    COMPILATION    - FORTRAN/EXTEND_SOURCE/CHECK=NOOVERFLOW UAF2PASSWD
C
C    ARGUMENTS      - Unix uid of the first user. If ommitted, default of
C                     10000 is assumed.
C
C    REMARKS        - Unix gid's correspond to octal value of UIC group.
C                     Reading of UAF record is brute-force and dirty, but
C                     it works, with extremely good performance. More
C                     proper way would be to use $GETUAI after reading
C                     usernames. However, that slows down the program.
C
C -----------------------------------------------------------------------------

	program uaf to passwd
  	   character*1412 record
           character user*12, owner*32, dismail*3, password*8, buffer*132
	   integer*4 usrlen, ownlen, uic(2), epasswd(2), uid0
	   integer*2 salt
	   byte encrypt

	   call lib$get_foreign (buffer, 'First uid [10000]: ', len_buffer)
	   read (buffer(1:len_buffer), '(I)') uid0
	   if ( uid0.lt.0 .or. uid0.gt.65535 ) then
	      write (*,*) '%UAF2PASSWD-F-INVUID, uid must be between 1 and 65535 !!!'
	      call exit
	   end if
	   if ( uid0.eq.0 ) uid0 = 10000

 	   open (21, file='sys$system:sysuaf.dat', access='sequential',
     *        readonly, shared, status='old', organization='indexed')
	   open (22, file='passwd.vms', status='new', carriage control='list')

     	   irec = 0
	   read (21,100,iostat=ios) record ! --- First record in UAF is unused
	   if (ios.ne.0) call exit

	   do while (.true.)
	      read (21,100,iostat=ios) record
	      if (ios.ne.0) goto 50
	      user(1:12)=record(5:17)
	      j=0
	      do i=1,12
	         ind = index('_-$0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ', user(i:i))
	         if (ind .gt. 0) then
	            j=j+1
	            user(j:j) = user(i:i)
	            if (ind .gt. 13)
     *                 user(j:j) = char(ichar(user(j:j))+ichar('a')-ichar('A'))
	         end if
	      end do
	      owner=record(86:116)
	      uic(1)=uid0 + irec
	      uic(2)=ichar(record(39:39)) + 256*ichar(record(40:40))
	      irec = irec + 1
	      password(1:8)=record(341:348)
	      salt = ichar(record(359:359)) + 256*ichar(record(360:360))
	      encrypt = ichar(record(361:361))
	      call genpasswd (password, epasswd)

	      call str$trim (owner, owner)
	      len_owner = index(owner, '  ') - 1
	      if (len_owner .le. 0) len_owner = len(owner)

              write (22,350) user(1:j), encrypt, salt,
     *	         epasswd(2), epasswd(1), uic(1), uic(2),
     *           owner(1:len_owner)
	   end do

50	   close(21)
	   close(22)
100	   format (A)
350	   format (A, ':##/', I1, '/', Z4.4, '/', Z8.8, '/', Z8.8,
     *             ':', I5, ':', O5, ':', A, ':::::')
	end



	subroutine genpasswd (password, epasswd)
	character*8 password
	integer*4 epasswd(2), mul, i

	epasswd(1) = 0
	epasswd(2) = 0
	mul = 1

	do i=1,8
	   epasswd((i-1)/4+1) = epasswd((i-1)/4+1) + ichar(password(i:i))*mul
	   if (mod(i,4) .ne. 0) then
	      mul = mul*256
	   else
	      mul = 1
	   end if
	end do

	end
