C -----------------------------------------------------------------------------
C
C    UAF2PASSWD.FOR - Convert user information from OpenVMS user database
C                     (SYSUAF.DAT) to Un*x passwd file.
C
C    AUTHOR         - Berislav Todorovic, (C) 06/06/1999.
C
C    COMPILATION    - FORTRAN/EXTEND_SOURCE UAF2PASSWD
C
C    ARGUMENTS      - Unix uid of the first user. If ommitted, default of
C                     10000 is assumed.
C
C    REMARKS        - Unix gid's correspond to octal value of UIC group.
C
C -----------------------------------------------------------------------------

	program uaf to passwd
 	   include '($uaidef)'
  	   character*1412 record
           character user*12, owner*32, dismail*3, password*8, buffer*132
	   integer*4 status, SYS$GETUAI, checkheld
	   integer*4 epasswd(2), uid0, uid, gid
	   integer*2 salt, uic(2)
	   byte encrypt

           structure /itmlist/ ! "VMS usage: item_list_3"
              union
                 map
                    integer*2 bufferlen
                    integer*2 itemcode	
                    integer*4 bufferaddr 
                    integer*4 lengthaddr 
                 end map
                 map
                    integer*4 endlist
                 end map
              end union
           end structure

	   record /itmlist/ item(6)

	   item(1).bufferlen=8
           item(1).itemcode=UAI$_PWD
	   item(1).bufferaddr=%LOC(epasswd)
	   item(1).lengthaddr=%LOC(len_pwd)

	   item(2).bufferlen=2
           item(2).itemcode=UAI$_SALT
	   item(2).bufferaddr=%LOC(salt)
	   item(2).lengthaddr=%LOC(len_salt)

	   item(3).bufferlen=1
           item(3).itemcode=UAI$_ENCRYPT
	   item(3).bufferaddr=%LOC(encrypt)
	   item(3).lengthaddr=%LOC(len_encrypt)

	   item(4).bufferlen=31
	   item(4).itemcode=UAI$_OWNER
	   item(4).bufferaddr=%LOC(owner)
	   item(4).lengthaddr=%LOC(len_owner)

	   item(5).bufferlen=8
	   item(5).itemcode=UAI$_UIC
	   item(5).bufferaddr=%LOC(uic)
	   item(5).lengthaddr=%LOC(len_uic)

	   item(6).endlist=0
	   
	   call lib$get_foreign (buffer, 'First uid [10000]: ', len_buffer)
	   read (buffer(1:len_buffer), '(I)') uid0
	   if ( uid0.lt.0 .or. uid0.gt.65535 ) then
	      write (*,*) '%UAF2PASSWD-F-INVUID, uid must be between 1 and 65535 !!!'
	      call exit
	   end if
	   if ( uid0.eq.0 ) uid0 = 10000

 	   open (21, file='sys$system:sysuaf.dat', access='sequential',
     *        readonly, shared, status='old', organization='indexed')
	   open (22, file='passwd.vms', status='new', carriage control='list')

     	   irec = 0
	   read (21,100,iostat=ios) record
	   if (ios.ne.0) call exit

	   do while (.true.)
	      read (21,100,iostat=ios) user
	      if (ios.ne.0) goto 50
   	      status = SYS$GETUAI (, , user(1:12), item, , , )
	      if (.not. status) goto 25
	      j=0
	      do i=1,12
	         ind = index('_-$0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ', user(i:i))
	         if (ind .gt. 0) then
	            j=j+1
	            user(j:j) = user(i:i)
	            if (ind .gt. 13)
     *                 user(j:j) = char(ichar(user(j:j))+ichar('a')-ichar('A'))
	         end if
	      end do

	      uid = uid0 + irec
	      gid = uic(2)
	      irec = irec + 1

	      call str$trim (owner, owner)
	      new_len_owner = index(owner,'  ') - 1
	      if (new_len_owner .gt. 0) len_owner = new_len_owner

              write (22,350) user(1:j), encrypt, salt,
     *	         epasswd(2), epasswd(1), uid, gid,
     *           owner(2:len_owner)

25            continue
	   end do

50	   close(21)
	   close(22)
100	   format (4X, A12)
350	   format (A, ':##/', I1, '/', Z4.4, '/', Z8.8, '/', Z8.8,
     *             ':', I5, ':', O5, ':', A, ':::::')
	end
