/* file:	tree.c
   author:	Dmitri Tikhonov
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Copyright (C) 1999 Dmitri Tikhonov					   *
 *									   *	
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or	   *
 *  (at your option) any later version.					   *
 *									   *
 *  This program is distributed in the hope that it will be useful,	   *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *  GNU General Public License for more details.			   *
 *									   *
 *  You should have received a copy of the GNU General Public License	   *
 *  along with this program; if not, write to the Free Software		   *
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* 	Tree: 	displays a tree of files and directories
	Author: Dmitri Tikhonov
	Date:	June 23, 1999
	E-Mail:	dxt2431@megahertz.njit.edu
*/

#include <dirent.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "bool.h"
#include "action.h"
#include "colors.h"
#include "option.h"
#include "version.h"

extern BOOL insert(char ***, char *, int *, int *, BOOL, ACTION);
extern int compare(const void *, const void *);
extern BOOL filetest(int, char *);
extern void color_print(char *, char *);
extern void init(void);
extern BOOL process_options(int, char **, char **);
extern void help(char *);
extern void print_version(void);
extern void print_classify(char *);

extern struct color color[numlast];
extern struct opt option;

/* hi-tech!  :) */
char last[256];

/* make `/usr/src' out of `/usr' and `src' */

static BOOL chain_directory(char **dest, char *base_path, char *end_path) {
	if (! (*dest=(char *) malloc(strlen(base_path)+strlen(end_path)+2)))
		return FALSE;
	
	/* manipulate the strings: */
	strcpy(*dest, base_path);
	if ('/' != *(base_path+strlen(base_path)-1) && '/' != *end_path)
		strcat(*dest, "/");
	strcat(*dest, end_path);

	return TRUE;
}

BOOL walk_tree(char *path, int level) {
	DIR *dir;
	BOOL is_dir;
	struct dirent *dirt;
	char *aux;

	char **array = NULL;
	int i, t, y, z;	/* these do some dirty work */

	if (option.level && (level == option.level)) return TRUE;

	if (filetest(directory, path)) {
		if (access(path, R_OK)) {
			if (!(option.level && (option.level == level))) {
			fprintf(stderr, "\e[0m%s: permission denied.\n", path);
			return FALSE;
			}
		}
		if (NULL == (dir = opendir(path))) {
			fprintf(stderr, "\e[0m%s: cannot read.\n", path);
			return FALSE;
		}
	} else {
		fprintf(stderr, "%s: is not a directory.\n", path);
		return FALSE;
	}

	insert(&array, NULL, &y, &z, TRUE, RESET);

	while (dirt = readdir(dir)) {
		/* do not bother with the "." and ".." directory entries: */
		if (strcmp(".", dirt->d_name) == 0 ||
		    strcmp("..", dirt->d_name) == 0)
			continue;
		
		/* Do we show all files? */
		if (option.no_dots && ('.' == *dirt->d_name)) continue;

		chain_directory(&aux, path, dirt->d_name);
		is_dir = filetest(directory, aux);

		/* Do we only show directories? */
		if (option.dir_only && !is_dir) continue;

		insert(&array, dirt->d_name, &y, &z, is_dir, INSERT);
			
		free(aux);
	}

	closedir(dir);

	if (option.sort) qsort(array, z, sizeof(char *), compare);

	for (i=0; i<z; ++i) {
		chain_directory(&aux, path, &(array[i][1]));

		/* take care of *kewl* graphics  :)  hehe. */
		for (t=0; t<level; ++t) printf("%c\t", last[t]);
		if (i == z-1) {
			printf("`");
			last[t] = ' ';
		} else {
			printf("|");
		}
		printf("-------");
		
		if (option.color) {
			color_print(aux, &(array[i][1]));
		} else {
			printf("%s", &(array[i][1]));
			if (option.classify) print_classify(aux);
		}

		if (filetest(sym_link, aux) && option.read_symlink) {
			char p[256];
			memset(p, 0, 256);
			readlink(aux, p, 256);
			p[255] = '\0';
			printf("------->");
			if (option.color) {
				char *aux1;
				if ('/' == *p) {
					color_print(p, p);
				} else {
					chain_directory(&aux1, path, p);
					color_print(aux1, p);
					free(aux1);
				}
			} else {
				printf("%s", p);
			}
		}

		printf("\n"), fflush(NULL);

		if ('d' == array[i][0])
				walk_tree(aux, level+1);
		free(aux);
		last[t] = '|';
	}

	insert(&array, NULL, &y, &z, TRUE, RESET);

	return TRUE;
}

static void ver_or_help(char *a) {
	if (option.help) {
		help(a);
		exit(0);
	}
	if (option.show_ver) {
		print_version();
		exit(0);
	}

	return;
}

int main(int argc, char **argv) {
	char *path = NULL;
	memset(last, '|', 256*sizeof(char));

	if (process_options(argc, argv, &path)) {
		ver_or_help(*argv);
		init();
		walk_tree(path, 0);
		free(path);
	} else {
		ver_or_help(*argv);
		init();
		walk_tree(getenv("PWD"), 0);
	}

	exit(0);
}
