/* file:	option.h
   author:	Dmitri Tikhonov
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Copyright (C) 1999 Dmitri Tikhonov					   *
 *									   *	
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or	   *
 *  (at your option) any later version.					   *
 *									   *
 *  This program is distributed in the hope that it will be useful,	   *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *  GNU General Public License for more details.			   *
 *									   *
 *  You should have received a copy of the GNU General Public License	   *
 *  along with this program; if not, write to the Free Software		   *
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef __OPTION_H__
#define __OPTION_H__

#include "bool.h"

struct opt {
	BOOL color;	/* TRUE: use color, FALSE: do not (default) */
	BOOL sort;	/* TRUE: sort directory (default), FALSE: do not */
	BOOL read_symlink;	/* TRUE: print contents of symbolic links,
				FALSE: do not (default) */
	BOOL help;	/* TRUE: display help and exit,
			FALSE: do not (default) */
	BOOL def;	/* TRUE: use default colors (only valid when
			opt.color is also TRUE, FALSE: do not (default) */
	BOOL dir_only;	/* TRUE: display directories only,
			FALSE: do not (default) */
	BOOL no_dots;	/* TRUE: do not show hidden files,
			FALSE: show everything (default) */
	BOOL show_ver;	/* TRUE: show version and exit,
			FALSE: do not (default) */
	BOOL classify;	/* TRUE: equivalent to ls(1)'s -F option
			FALSE: do not show the extra information (default) */
	BOOL level;	/* TRUE: depth specified; FALSE: it's not (default) */
};

/* Note on default values:
	Default values are specified in the file default.h
*/

#endif /* __OPTION_H__ */
