/* file:	option.c
   author:	Dmitri Tikhonov
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Copyright (C) 1999 Dmitri Tikhonov					   *
 *									   *	
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or	   *
 *  (at your option) any later version.					   *
 *									   *
 *  This program is distributed in the hope that it will be useful,	   *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *  GNU General Public License for more details.			   *
 *									   *
 *  You should have received a copy of the GNU General Public License	   *
 *  along with this program; if not, write to the Free Software		   *
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "option.h"
#include "default.h"

/* The following specifies the behaviour of the program when necountering
   an unknown option:
*/

#define EXIT_WHEN_UNKNOWN TRUE
#define NUL '\0'

static BOOL level = FALSE;

struct opt option = {	DEFAULT_COLOR,
			DEFAULT_SORT,
			DEFAULT_READ_SYMLINK,
			DEFAULT_HELP,
			DEFAULT_DEF,
			DEFAULT_DIR_ONLY,
			DEFAULT_NO_DOTS,
			DEFAULT_SHOW_VERSION,
			DEFAULT_CLASSIFY,
			DEFAULT_LEVEL,
		    };

static BOOL one_letter(char *a) {
	for (; *a; ++a) {
		switch(*a) {
			case 'a':
				option.no_dots =
					(option.no_dots==DEFAULT_NO_DOTS?
					FLIP(DEFAULT_NO_DOTS):
					option.no_dots);
				break;
			case 'c':
				option.color =
					(option.color==DEFAULT_COLOR?
					FLIP(DEFAULT_COLOR):
					option.color);
				break;
			case 'd':
				option.def =
					(option.def==DEFAULT_DEF?
					FLIP(DEFAULT_DEF):
					option.def);
				break;
			case 'f':
			case 'F':
				option.classify = 
					(option.classify==DEFAULT_CLASSIFY?
					FLIP(DEFAULT_CLASSIFY):
					option.classify);
				break;
			case 'h':
				option.help =
					(option.help==DEFAULT_HELP?
					FLIP(DEFAULT_HELP):
					option.help);
				break;
			case 'i':
				option.dir_only =
					(option.dir_only==DEFAULT_DIR_ONLY?
					FLIP(DEFAULT_DIR_ONLY):
					option.dir_only);
				break;
			case 'l':
				level = TRUE;
				if (*(a+1) == NUL) return FALSE;
				if (!isdigit(*(a+1))) {
					fprintf(stderr, "option '-l' should be"
					"followed by a number.\n%s is not a"
					"number.\n", a+1);
					exit(2);
				}
				option.level = atoi(a+1);
				return (!(level = FALSE));
			case 'n':
				option.sort =
					(option.sort==DEFAULT_SORT?
					FLIP(DEFAULT_SORT):
					option.sort);
				break;
			case 's':
				option.read_symlink =
				(option.read_symlink==DEFAULT_READ_SYMLINK?
				FLIP(DEFAULT_READ_SYMLINK):
				option.read_symlink);
				break;
			case 'v':
				option.show_ver =
					(option.show_ver==DEFAULT_SHOW_VERSION?
					FLIP(DEFAULT_SHOW_VERSION):
					option.show_ver);
				break;
			default:
				fprintf(stderr, "%c: unknown option.\n", *a);
				if (EXIT_WHEN_UNKNOWN) exit(1);
				break;
		}
	}

	return TRUE;
}

static void long_opt(char *a) {
	if ((!strcmp("color", a)) || (!strcmp("colour", a))) {
		option.color = TRUE;
	} else if (!strcmp("default", a)) {
		option.def = TRUE;
	} else if (!strcmp("help", a)) {
		option.help = TRUE;
	} else if (!strcmp("dir-only", a)) {
		option.dir_only = TRUE;
	} else if (!strcmp("classify", a)) {
		option.classify = TRUE;
	} else if (!strcmp("show-hidden", a)) {
		option.no_dots = TRUE;
	} else if (!strcmp("level", a)) {
		level = TRUE;
	} else if (!strcmp("no-sort", a)) {
		option.sort = FALSE;
	} else if (!strcmp("symlink", a)) {
		option.read_symlink = TRUE;
	} else if (!strcmp("version", a)) {
		option.show_ver = TRUE;
	} else {
		fprintf(stderr, "%s: unknown option.\n", a);
		if (EXIT_WHEN_UNKNOWN) exit(1);
	}

	return;
}

BOOL process_options(int argc, char **argv, char **path) {
	int i;

	for (i = 1; i < argc; ++i) {
		if ('-' == argv[i][0]) {
			if ('-' == argv[i][1]) {
				long_opt(&(argv[i][2]));
			} else {
				if (!(one_letter(&(argv[i][1])) || level)) {
					fprintf(stderr, "option '-l' should "
					"be followed by a number.\n");
					exit(2);
				}
			}
		} else if (level) {
			if (! isdigit(*(argv[i]))) {
				fprintf(stderr, "%s is not a number.\n",
					argv[i]);
				exit(2);
			}
			option.level = atoi(argv[i]);
			level = FALSE;
		} else {
			*path = strdup(argv[i]);
			break;
		}
	}

	return (BOOL)(*path != NULL);
}
