/* file:	insert.c
   author:	Dmitri Tikhonov
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Copyright (C) 1999 Dmitri Tikhonov					   *
 *									   *	
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or	   *
 *  (at your option) any later version.					   *
 *									   *
 *  This program is distributed in the hope that it will be useful,	   *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *  GNU General Public License for more details.			   *
 *									   *
 *  You should have received a copy of the GNU General Public License	   *
 *  along with this program; if not, write to the Free Software		   *
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "bool.h"
#include "action.h"

#define BUCKET 64

BOOL insert(char ***array,	/* array[][] is maintained in walk_tree() */
	  char *name,		/* name of file */
	  int *f,		/* number of free ptrs for names in array */
	  int *index,		/* current location for insertion or reading */
	  BOOL dir,		/* whether file is a directory */
	  ACTION action) {	/* action to be taken */

	  /* action can be:
	  	0	reset	RESET
		1	insert	INSERT
	  */

	int i;

	switch (action) {
	case(RESET):
		if (*array) {
			for(i = 0; i < *index; ++i) {
				free((*array)[i]);
			}
			free(*array);
		}
		*array = NULL;
		*f = BUCKET;
		*index = 0;
		break;
	case(INSERT):
		if (!*index) *array = malloc(BUCKET * sizeof(char *));
		if (!*f) {
			*array = realloc(*array, sizeof(char *) *
				(*index + BUCKET));
			*f = BUCKET;
		}
		(*array)[*index] = calloc(strlen(name) + 2, 1);
		(*array)[*index][0] = 'x';
		if (dir) (*array)[*index][0] = 'd';
		strcpy(&((*array)[*index][1]), name);
		++*index;
		--*f;
		break;
	default:
		/* Hmm........  */
		break;
	} /* EOSwitch */

	return TRUE;
}

