/* file:	filetest.h
   author:	Dmitri Tikhonov
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Copyright (C) 1999 Dmitri Tikhonov					   *
 *									   *	
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or	   *
 *  (at your option) any later version.					   *
 *									   *
 *  This program is distributed in the hope that it will be useful,	   *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *  GNU General Public License for more details.			   *
 *									   *
 *  You should have received a copy of the GNU General Public License	   *
 *  along with this program; if not, write to the Free Software		   *
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "bool.h"
#include "colors.h"

static BOOL is_executable(char *path) {
	struct stat file;
	lstat(path, &file);
	return(S_IXUSR & file.st_mode);
}

BOOL filetest(int type, char *path) {
	struct stat file;
	lstat(path, &file);

	switch(type) {
		case directory: return(S_ISDIR(file.st_mode));
		case sym_link:  return(S_ISLNK(file.st_mode));
		case fifo:      return(S_ISFIFO(file.st_mode));
		case socket:    return(S_ISSOCK(file.st_mode));
		case c_dev:     return(S_ISCHR(file.st_mode));
		case b_dev:     return(S_ISBLK(file.st_mode));
		
		/* strange: the following case missed 'return'
		in the previous versions of the program, but it still worked.
		could it be because it is the last statement evaluating
		to int?  if you've got an answer, e-mail me. */

		case executable:return(is_executable(path));
		default:/* never happens, BABY! */
	}
	
}
