/* file:	color.c
   author:	Dmitri Tikhonov
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Copyright (C) 1999 Dmitri Tikhonov					   *
 *									   *	
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or	   *
 *  (at your option) any later version.					   *
 *									   *
 *  This program is distributed in the hope that it will be useful,	   *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *  GNU General Public License for more details.			   *
 *									   *
 *  You should have received a copy of the GNU General Public License	   *
 *  along with this program; if not, write to the Free Software		   *
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "colors.h"
#include "bool.h"
#include "option.h"

#define NUL '\0'

extern BOOL filetest(int, char *);
extern void print_classify(char *);

extern struct opt option;

struct color color[numlast];

static char filedef[numlast][3] = {	"no",
					"fi",
					"di",
					"ln",
					"pi",
					"so",
					"bd",
					"cd",
					"ex",
				  };

static char *default_color =
	"no=0:fi=0:di=32:ln=36:pi=31:so=33:bd=44;37:cd=44;37:ex=35:;:;";

/* Note:
	Without trailing ":;:;" the program segfaults;  I have no clue as to
	why it does that.  The problem is located in the extract() function,
	somewhere in the for() loop.  I am lazy, so instead of fixing the
	algorithm, I changed the variable it works with.

						- Dmitri Tikhonov
						July 2, 1999
*/


static inline void set(int *x) {
	int i;
	for (i = 0; i < 3 && x[i] != -1; ++i) printf("\e[%im", x[i]);
	return;
}

static void extract(char *type, int *x) {
	char *lscolor, *limit, *ptr1, *ptr2;
	int i;
	BOOL first;
	x[0] = -1;
	x[1] = -1;
	x[2] = -1;
	
	if (!option.def && getenv("LS_COLORS")) {
		lscolor = malloc(strlen(getenv("LS_COLORS"))+5);
		strcpy(lscolor, getenv("LS_COLORS"));
		strcat(lscolor, ":;:;");
		/* See my comment above about trailing ":;:;". */
	} else if (option.def) {
		lscolor = strdup(default_color);
	} else {
		return;
	}

	if (ptr1 = strstr(lscolor, type)) {
	
	if (!(limit = strchr(ptr1, ':'))) limit = strlen(ptr1) + ptr1;

	for (i = 0, first = TRUE; i < 3; ++i, ptr1 = ptr2 + 1, first = FALSE) {
		if (first) ptr1 = ptr1 + 3;
		if ((ptr2 = strchr(ptr1, ';')) >= limit)
			if ((ptr2 = strchr(ptr1, ':')) > limit)
				break;
		if (ptr2) *ptr2 = NUL; 
		x[i] = atoi(ptr1);
	}

	}	/* end the big IF */

	free(lscolor);

	return;
}

void init(void) {
	int i;
	if (option.color)
		for (i = 0; i < numlast; ++i)
			extract(filedef[i], color[i].color);
	return;
}

void color_print(char *path, char *filename) {
	/* take care of color:*/ 
	if (filetest(directory, path)) {
		set(color[directory].color);
	} else if (filetest(sym_link, path)) {
		set(color[sym_link].color);
	} else if (filetest(c_dev, path)) {
		set(color[c_dev].color);
	} else if (filetest(b_dev, path)) {
		set(color[b_dev].color);
	} else if (filetest(fifo, path)) {
		set(color[fifo].color);
	} else if (filetest(socket, path)) {
		set(color[socket].color);
	} else if (filetest(executable, path)) {
		set(color[executable].color);
	}
	
	printf("%s", filename);
	if (option.classify) print_classify(path);
	set(color[normal].color);
}
