/*
 * Copyright (c) 1996 Andrew Main.  All rights reserved.
 *
 * Redistribution and use, in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer
 *    in the documentation and/or other materials provided with the
 *    distribution.
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgement:
 *        This product includes software developed by Andrew Main.
 * 4. The name of Andrew Main may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ANDREW MAIN BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_STRING_H
# include <string.h>
#endif
#include <sys/utsname.h>

#ifndef HAVE_STRCHR
# define strchr index
# define strrchr rindex
#endif

static int usage()
{
  fprintf(stderr, "usage: uname [-snrvma]\n");
  exit(2);
}

int main(argc, argv)
int argc;
char **argv;
{
  int o;
  struct utsname ut;
  char const *name=strrchr(argv[0], '/');
  if(name)
    name++;
  else
    name=argv[0];
  if(!strcmp(name, "arch") || !strcmp(name, "mach"))
    o=16;
  else if(argc > 1) {
    o=0;
    for(; *++argv; ) {
      char *p=*argv;
      if(*p++!='-' || !*p) usage();
      for(; *p; p++)
	switch(*p) {
	  case 's': o|= 1; break;
	  case 'n': o|= 2; break;
	  case 'r': o|= 4; break;
	  case 'v': o|= 8; break;
	  case 'm': o|=16; break;
	  case 'a': o =31; break;
	  default: usage();
	}
    }
  } else
    o=1;
  if(uname(&ut)) {
    perror("uname");
    exit(1);
  }
  if(o& 1) printf("%s%c", ut.sysname,  o&30 ? ' ' : '\n');
  if(o& 2) printf("%s%c", ut.nodename, o&28 ? ' ' : '\n');
  if(o& 4) printf("%s%c", ut.release,  o&24 ? ' ' : '\n');
  if(o& 8) printf("%s%c", ut.version,  o&16 ? ' ' : '\n');
  if(o&16) printf("%s%c", ut.machine,               '\n');
  exit(0);
}
