/* Program to set the static priority and sched policy of a process */
/* Bradford Snow */
/* Date: 7-30-97 */

/* Includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sched.h>

/* Prints out usage information */
void usage()
{
   printf("usage: setpriority [<pid> [<schedule policy> \"other\" \"fifo\" \"rr\"] <priority>]\n"); 
}

/* Process command line arguments */
int parse_cmd_line(int argc,char **argv)
{
   if(argc!=4){usage();return -1;}
   else
     
     //Check schedule policy
     switch((int)argv[2][0])
     {
      case 'o': 
	return SCHED_OTHER;
      case 'f':  
	return SCHED_FIFO;
      case 'r':
	return SCHED_RR;
      default: 
	printf("Invalid schedule policy: %s.\n",argv[2]);
	usage();
	exit(1);
     }
} 


/* Main */
void main(int argc,char **argv)
{
   
   struct sched_param param;
   struct sched_param param2;
   int    sched_policy;
   int    min_priority, max_priority;
   
   /* Make sure that we are running as root */
   if(getuid()) {
      fprintf(stderr,"Must be root to run this!\n");
      exit(1);
   }
   
   /* Check arguments */
   sched_policy=parse_cmd_line(argc,argv);
   if(sched_policy==-1)
     exit(1);
   
   /* Fill in parm structure */
   param.sched_priority=atoi(argv[3]);
   if(param.sched_priority<(min_priority=sched_get_priority_min(sched_policy)))
     {
	printf("\nPriority %s is to low, using min allow priority %d instead!\n\n",
	       argv[3],min_priority);
	param.sched_priority=min_priority;
     }
   
  
    /* Validate priority */
    if(param.sched_priority>(max_priority=sched_get_priority_max(sched_policy)))
     {
	printf("\nPriority %s is to high, using max allow priority %d instead!\n\n",
	       argv[3],max_priority);
	param.sched_priority=max_priority;
     }
   
   /* Set the priority and scheduler */
   if(sched_setscheduler(atol(argv[1]),sched_policy,&param))
     {
	perror("sched_setscheduler");
	exit(1);
     }
   
   /* Print out info */
   printf("\nPID              : %s\n",argv[1]);
   switch( sched_getscheduler( atol(argv[1]) ) )
     {
      case SCHED_FIFO :printf("Scheduling Policy: SCHED_FIFO\n" ); break;
      case SCHED_RR   :printf("Scheduling Policy: SCHED_RR\n"   ); break;
      case SCHED_OTHER:printf("Scheduling Policy: SCHED_OTHER\n"); break;
      default: 
	perror("sched_getscheduler");
	exit(1);
     }
   
   if(sched_getparam(atol(argv[1]),&param2))
     {perror("sched_getparam");exit(1);}
   else
     printf("Static Priority  : %d\n\n",param2.sched_priority);
}


