/* Program to set the static priority and of a process */
/* Bradford Snow */
/* Date: 7-30-97 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sched.h>


void usage()
{
printf("usage: getpriority [<pid>]\n"); 
}

int parse_cmd_line(int argc,char **argv)
{
   if(argc!=2){usage();return -1;}
   else
   return 0;  
}


void main(int argc,char **argv)
{
       
   struct sched_param param;
   struct sched_param param2;
   int    sched_policy;
   
   /* Check arguments */
   
   if(parse_cmd_line(argc,argv))
   exit(1);
   
   printf("\nPID              : %s\n",argv[1]);  
   switch( sched_getscheduler(atol(argv[1])) )
     {
      case SCHED_FIFO:printf("Scheduling Policy: SCHED_FIFO\n");break;
      case SCHED_RR  :printf("Scheduling Policy: SCHED_RR\n");break;
      case SCHED_OTHER:printf("Scheduling Policy: SCHED_OTHER\n");break;
      default: 
	perror("sched_getscheduler");
	exit(1);
     }
  
   if(sched_getparam(atol(argv[1]),&param2))
     {perror("sched_getparam");exit(1);}
   else
   printf("Static Priority  : %d\n\n",param2.sched_priority);
}

