#include <string.h>
#include <iostream.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/stat.h>
#include <Xm/Notebook.h>
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/PushB.h>
#include <X11/Xmu/Editres.h>

#include "mxSetup.h"
#include "mxSetupModify.h"
static char	*modem_speed_options[]=
		{"2400","4800","9600","19200","38400","57600","115200"};
static char	*modem_port_options[]=
		{"COM 1","COM 2","COM 3","COM 4"};

mxSetupModify	*theMxSetupModify = 0;
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxSetupModify::mxSetupModify(Widget parent,
			     char *name,
			     XtCallbackProc callback,
			     XtPointer clientData)
	:akDialog(name),
	 _userCB(callback),
	 _userData(clientData),
	 _notebook((Widget)0),
	 _organisationField((akPromptString *)0),
	 _tempDirField((akPromptFile *)0),
	 _helpDirField((akPromptFile *)0),
	 _audioDirField((akPromptFile *)0),
	 _audioCheckBox((akCheckBox *)0),
	 _ftpCheckBox((akCheckBox *)0),
	 _ftpDefaultLocalDirField((akPromptString *)0),
	 _ftpDefaultRemoteDirField((akPromptString *)0),
	 _ftpProcessFilenameField((akPromptFile *)0),
	 _mailSenderField((akPromptString *)0),
	 _mailInboxField((akPromptFile *)0),
	 _mailOutboxField((akPromptFile *)0),
	 _mailAddressbookField((akPromptFile *)0),
	 _mailSpambookField((akPromptFile *)0),
	 _mailSignatureField((akPromptFile *)0),
	 _mailFolderDirectoryField((akPromptFile *)0),
	 _mailInboxReadFolderField((akPromptFile *)0),
	 _mailIndentStringField((akPromptString *)0),
	 _mailProcessFilenameField((akPromptFile *)0),
	 _mailUpdateIntervalField((akPromptIntRange *)0),
	 _mailStartupFolderList((akList *)0),
	 _mailMimeFormatField((akRadioBox *)0),
	 _newsBaseDirectoryField((akPromptFile *)0),
	 _netModemSpeedField((akOptionMenu *)0),
	 _netModemPortField((akRadioBox *)0),
	 _netModemInitField((akPromptString *)0),
	 _netModemIdleField((akPromptIntRange *)0),
	 _netModemNoRetriesField((akPromptIntRange *)0),
	 _netSupplierPhoneNoField((akPromptString *)0),
	 _netSupplierLoginField((akPromptString *)0),
	 _netSupplierPasswordField((akPromptPassword *)0),
	 _netWWWCommandField((akPromptFile *)0),
	 _netNewsCommandField((akPromptFile *)0),
	 _generalPageUsed(false),
	 _ftpPageUsed(false),
	 _mailPageUsed(false),
	 _newsPageUsed(false),
	 _netPageUsed(false)
{

//	Create setup modify panel

	initialize(parent,
		   (XtPointer)this,
		   "Save",
		   &mxSetupModify::saveCB,
		   "Cancel",
		   &mxSetupModify::cancelCB);

//	Update values in panel

	update();

//	Set panel title line

	setTitle("Configuration/Setup Control");
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxSetupModify::~mxSetupModify()
{
	if (_organisationField)
	  delete _organisationField;
	if (_tempDirField)
	  delete _tempDirField;
	if (_helpDirField)
	  delete _helpDirField;
	if (_audioDirField)
	  delete _audioDirField;
	if (_audioCheckBox)
	  delete _audioCheckBox;

	if (_ftpCheckBox)
	  delete _ftpCheckBox;
	if (_ftpDefaultLocalDirField)
	  delete _ftpDefaultLocalDirField;
	if (_ftpDefaultRemoteDirField)
	  delete _ftpDefaultRemoteDirField;
	if (_ftpProcessFilenameField)
	  delete _ftpProcessFilenameField;

	if (_mailSenderField)
	  delete _mailSenderField;
	if (_mailInboxField)
	  delete _mailInboxField;
	if (_mailOutboxField)
	  delete _mailOutboxField;
	if (_mailAddressbookField)
	  delete _mailAddressbookField;
	if (_mailSpambookField)
	  delete _mailSpambookField;
	if (_mailSignatureField)
	  delete _mailSignatureField;
	if (_mailFolderDirectoryField)
	  delete _mailFolderDirectoryField;
	if (_mailInboxReadFolderField)
	  delete _mailInboxReadFolderField;
	if (_mailIndentStringField)
	  delete _mailIndentStringField;
	if (_mailProcessFilenameField)
	  delete _mailProcessFilenameField;
	if (_mailUpdateIntervalField)
	  delete _mailUpdateIntervalField;
	if (_mailStartupFolderList)
	  delete _mailStartupFolderList;
	if (_mailMimeFormatField)
	  delete _mailMimeFormatField;

	if (_newsBaseDirectoryField)
	  delete _newsBaseDirectoryField;

	if (_netModemSpeedField)
	  delete _netModemSpeedField;
	if (_netModemPortField)
	  delete _netModemPortField;
	if (_netModemInitField)
	  delete _netModemInitField;
	if (_netModemIdleField)
	  delete _netModemIdleField;
	if (_netModemNoRetriesField)
	  delete _netModemNoRetriesField;
	if (_netSupplierPhoneNoField)
	  delete _netSupplierPhoneNoField;
	if (_netSupplierLoginField)
	  delete _netSupplierLoginField;
	if (_netSupplierPasswordField)
	  delete _netSupplierPasswordField;
	if (_netWWWCommandField)
	  delete _netWWWCommandField;
	if (_netNewsCommandField)
	  delete _netNewsCommandField;
}
////////////////////////////////////////////////////////////////////////////////
//
//	manage - manage the panel after updating it
//
////////////////////////////////////////////////////////////////////////////////
void	mxSetupModify::manage()
{
//	Re-read the file (latest values etc)

	theMxSetup->read();

//	Update the panel values

	update();

//	Manage it

	akDialog::manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	createWorkArea - create the panel contents
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxSetupModify::createWorkArea(Widget parent)
{
	Widget		form;

//	Add 'editres' support

	XtAddEventHandler(_w,(EventMask)0,TRUE,
			  (XtEventHandler)_XEditResCheckMessages,0);

//	Add a form to attach contents to

	form = XtVaCreateManagedWidget("Form",xmFormWidgetClass,parent,0);

//	Add notebook

	_notebook =
		XtVaCreateManagedWidget("Notebook",
					xmNotebookWidgetClass,
					form,
					XmNorientation,XmVERTICAL,
					XmNbackPagePlacement,XmBOTTOM_RIGHT,
					XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					0);
	XtAddCallback(_notebook,
		      XmNpageChangedCallback,
		      &mxSetupModify::pageChangedCB,
		      (XtPointer)this);

//	Add the pages

	int	i=1;
	createGeneralPage(_notebook,i);i++;
	createFtpPage(_notebook,i);i++;
	createMailPage(_notebook,i);i++;
//	createNewsPage(_notebook,i);i++;
//	createNetPage(_notebook,i);i++;

//	Update messagebox parameters

	XtVaSetValues(_w,XmNautoUnmanage,FALSE,0);
	  
	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	setSection - Set the section being viewed
//
////////////////////////////////////////////////////////////////////////////////
void	mxSetupModify::setSection(mxSetupSectionType section)
{
	int	page = (int)section + 1;
	XtVaSetValues(_notebook,
		      XmNcurrentPageNumber,page,
		      0);
}
////////////////////////////////////////////////////////////////////////////////
//
//	createGeneralPage - create the general page contents
//
////////////////////////////////////////////////////////////////////////////////
void	mxSetupModify::createGeneralPage(Widget parent,int page_no)
{
	Widget		form;
	Widget		rowcol;
	Widget		list_frame;

//	Add a form to attach contents to

	form =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					parent,
					XmNnotebookChildType,XmPAGE,
					XmNpageNumber,page_no,
					0);

//	Add rowcol containing directory prompts etc

	rowcol =
		XtVaCreateManagedWidget("RowCol",
					xmRowColumnWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNadjustLast,FALSE,
					0);
	_organisationField =
	  new akPromptString(rowcol,"Prompt","Organisation");
	_organisationField->manage();
	_tempDirField =
	  new akPromptFile(rowcol,"Prompt","Temp Directory");
	_tempDirField->manage();
	_helpDirField =
	  new akPromptFile(rowcol,"Prompt","Help Directory");
	_helpDirField->manage();
	_audioDirField =
	  new akPromptFile(rowcol,"Prompt","Audio Directory");
	_audioDirField->manage();

	char	*audio_options[] = {"Intro Sound",
				    "Sound on mailbox checking",
				    "Sound on NEW mail",
				    "Sound on File transfer completion"};
	_audioCheckBox =
	  new akCheckBox(rowcol,"AudioEffects","Audio Effects",
			 audio_options,XtNumber(audio_options),1);
	_audioCheckBox->manage();

//	Add the major tab and status area

	XmString	tempstr;
	tempstr = XmStringCreateLtoR("General",XmFONTLIST_DEFAULT_TAG);
	XtVaCreateManagedWidget("ViewTab",
				xmPushButtonWidgetClass,
				parent,
				XmNlabelString,tempstr,
				XmNnotebookChildType,XmMAJOR_TAB,
				XmNpageNumber,page_no,
				0);
	XmStringFree(tempstr);
	tempstr = XmStringCreateLtoR("General Setup parameters affecting all 'mx' applications",XmFONTLIST_DEFAULT_TAG);
	XtVaCreateManagedWidget("ViewTitle",
				xmLabelWidgetClass,
				parent,
				XmNlabelString,tempstr,
				XmNnotebookChildType,XmSTATUS_AREA,
				XmNpageNumber,page_no,
				XmNalignment,XmALIGNMENT_BEGINNING,
				0);
	XmStringFree(tempstr);

	_generalPageUsed = true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createFtpPage - create the ftp page contents
//
////////////////////////////////////////////////////////////////////////////////
void	mxSetupModify::createFtpPage(Widget parent,int page_no)
{
	Widget		form;
	Widget		rowcol;
	Widget		list_frame;
	char		*options[]=
			{
			"Show Permissions",
			"Show Number of Links",
			"Show Owner",
			"Show Group",
			"Show Size",
			"Show Date",
			};

//	Add a form to attach contents to

	form =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					parent,
					XmNnotebookChildType,XmPAGE,
					XmNpageNumber,page_no,
					0);

//	Add check box containing ls output options etc

	_ftpCheckBox =
	  new akCheckBox(form,"CheckBox","File Display Control",
			 options,XtNumber(options),2);
	XtVaSetValues(_ftpCheckBox->baseWidget(),
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNleftAttachment,XmATTACH_FORM,
		      0);
	rowcol =
		XtVaCreateManagedWidget("RowCol",
					xmRowColumnWidgetClass,
					form,
					XmNorientation,XmVERTICAL,
					XmNadjustLast,FALSE,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,_ftpCheckBox->baseWidget(),
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					0);
	_ftpCheckBox->manage();
	_ftpDefaultLocalDirField =
	  new akPromptString(rowcol,"LocalDir","Default Local Directory");
	XtVaSetValues(_ftpDefaultLocalDirField->baseWidget(),XmNcolumns,40,0);
	_ftpDefaultLocalDirField->manage();
	_ftpDefaultRemoteDirField =
	  new akPromptString(rowcol,"RemoteDir","Default Remote Directory");
	XtVaSetValues(_ftpDefaultRemoteDirField->baseWidget(),XmNcolumns,40,0);
	_ftpDefaultRemoteDirField->manage();
	_ftpProcessFilenameField =
	  new akPromptFile(rowcol,"Prompt","'ftp' Binary Filename");
	_ftpProcessFilenameField->manage();

//	Add the major tab and status area

	XmString	tempstr;
	tempstr = XmStringCreateLtoR("FTP",XmFONTLIST_DEFAULT_TAG);
	XtVaCreateManagedWidget("ViewTab",
				xmPushButtonWidgetClass,
				parent,
				XmNlabelString,tempstr,
				XmNnotebookChildType,XmMAJOR_TAB,
				XmNpageNumber,page_no,
				0);
	XmStringFree(tempstr);
	tempstr = XmStringCreateLtoR("FTP Setup parameters affecting 'mxFtp' application",XmFONTLIST_DEFAULT_TAG);
	XtVaCreateManagedWidget("ViewTitle",
				xmLabelWidgetClass,
				parent,
				XmNlabelString,tempstr,
				XmNnotebookChildType,XmSTATUS_AREA,
				XmNpageNumber,page_no,
				XmNalignment,XmALIGNMENT_BEGINNING,
				0);
	XmStringFree(tempstr);

	_ftpPageUsed = true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createMailPage - create the mail page contents
//
////////////////////////////////////////////////////////////////////////////////
void	mxSetupModify::createMailPage(Widget parent,int page_no)
{
	Widget		form;
	Widget		rowcol;
	Widget		rowcol_2;
	Widget		list_frame;
	Widget		form1;

//	Add a form to attach contents to

	form =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					parent,
					XmNnotebookChildType,XmPAGE,
					XmNpageNumber,page_no,
					0);

//	Add rowcol containing file prompts etc

	rowcol =
		XtVaCreateManagedWidget("RowCol",
					xmRowColumnWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNorientation,XmVERTICAL,
					0);
	_mailSenderField =
	  new akPromptString(rowcol,"Prompt","Sender Mail-Address");
	_mailSenderField->manage();

	_mailInboxField =
	  new akPromptFile(rowcol,"Prompt","Inbox Filename");
	_mailInboxField->manage();

	_mailOutboxField =
	  new akPromptFile(rowcol,"Prompt","Outbox Filename");
	_mailOutboxField->manage();

	_mailAddressbookField =
	  new akPromptFile(rowcol,"Prompt","Addressbook Filename");
	_mailAddressbookField->manage();

	_mailSpambookField =
	  new akPromptFile(rowcol,"Prompt","SPAM Book Filename");
	_mailSpambookField->manage();

	_mailSignatureField =
	  new akPromptFile(rowcol,"Prompt","Signature Filename");
	_mailSignatureField->manage();
	_mailFolderDirectoryField =
	  new akPromptFile(rowcol,"Prompt","Folder Directory",
			   &mxSetupModify::mailFolderDirectoryChangedCB,(XtPointer)this);
	_mailFolderDirectoryField->manage();
	_mailInboxReadFolderField =
	  new akPromptFile(rowcol,"Prompt","Read Inbox-Messages Folder");
	_mailInboxReadFolderField->manage();

	_mailProcessFilenameField =
	  new akPromptFile(rowcol,"Prompt","'sendmail' Binary Filename");
	_mailProcessFilenameField->manage();

//	Add startup folder list

	list_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,rowcol,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					NULL);
	XtVaCreateManagedWidget("Startup Folders",
				xmLabelWidgetClass,
				list_frame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				0);
	_mailStartupFolderList = new akList(list_frame,"StartupFolderList");
	_mailStartupFolderList->setPolicy(MULTIPLE);
	_mailStartupFolderList->manage();

//	Add options alongside list

	rowcol_2 =
		XtVaCreateManagedWidget("RowCol",
					xmRowColumnWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,rowcol,
					XmNleftAttachment,XmATTACH_WIDGET,
					XmNleftWidget,list_frame,
					XmNrightAttachment,XmATTACH_FORM,
					XmNorientation,XmVERTICAL,
					0);
	_mailIndentStringField =
	  new akPromptString(rowcol_2,"Prompt","Message Indent String");
	XtVaSetValues(_mailIndentStringField->fieldWidget(),XmNcolumns,6,0);
	_mailIndentStringField->manage();

	_mailUpdateIntervalField =
	  new akPromptIntRange(rowcol_2,"Prompt","Mailbox Check Interval (sec)");
	XtVaSetValues(_mailUpdateIntervalField->fieldWidget(),XmNcolumns,6,0);
	_mailUpdateIntervalField->setRange(5,3600);
	_mailUpdateIntervalField->manage();

	char	*mime_format_options[] = {"enabled","disabled"};
	_mailMimeFormatField =
	  new akRadioBox(rowcol_2,"MimeFormat","MIME Format",
			 mime_format_options,XtNumber(mime_format_options),2);
	_mailMimeFormatField->manage();

//	Add the major tab and status area

	XmString	tempstr;
	tempstr = XmStringCreateLtoR("Mail",XmFONTLIST_DEFAULT_TAG);
	XtVaCreateManagedWidget("ViewTab",
				xmPushButtonWidgetClass,
				parent,
				XmNlabelString,tempstr,
				XmNnotebookChildType,XmMAJOR_TAB,
				XmNpageNumber,page_no,
				0);
	XmStringFree(tempstr);
	tempstr = XmStringCreateLtoR("Mail Setup parameters affecting 'mxMail' application",XmFONTLIST_DEFAULT_TAG);
	XtVaCreateManagedWidget("ViewTitle",
				xmLabelWidgetClass,
				parent,
				XmNlabelString,tempstr,
				XmNnotebookChildType,XmSTATUS_AREA,
				XmNpageNumber,page_no,
				XmNalignment,XmALIGNMENT_BEGINNING,
				0);
	XmStringFree(tempstr);

	_mailPageUsed = true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createNewsPage - create the news page contents
//
////////////////////////////////////////////////////////////////////////////////
void	mxSetupModify::createNewsPage(Widget parent,int page_no)
{
	Widget		form;
	Widget		rowcol;

//	Add a form to attach contents to

	form =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					parent,
					XmNnotebookChildType,XmPAGE,
					XmNpageNumber,page_no,
					0);

//	Add rowcol containing file prompts etc

	rowcol =
		XtVaCreateManagedWidget("RowCol",
					xmRowColumnWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNorientation,XmVERTICAL,
					0);

//	Add field prompting for news base directory

	_newsBaseDirectoryField =
	  new akPromptFile(rowcol,"Prompt","News Spool Base-Directory");
	_newsBaseDirectoryField->manage();

//	Add the major tab and status area

	XmString	tempstr;
	tempstr = XmStringCreateLtoR("News",XmFONTLIST_DEFAULT_TAG);
	XtVaCreateManagedWidget("ViewTab",
				xmPushButtonWidgetClass,
				parent,
				XmNlabelString,tempstr,
				XmNnotebookChildType,XmMAJOR_TAB,
				XmNpageNumber,page_no,
				0);
	XmStringFree(tempstr);
	tempstr = XmStringCreateLtoR("Mail Setup parameters affecting 'mxNews' application",XmFONTLIST_DEFAULT_TAG);
	XtVaCreateManagedWidget("ViewTitle",
				xmLabelWidgetClass,
				parent,
				XmNlabelString,tempstr,
				XmNnotebookChildType,XmSTATUS_AREA,
				XmNpageNumber,page_no,
				XmNalignment,XmALIGNMENT_BEGINNING,
				0);
	XmStringFree(tempstr);

	_newsPageUsed = true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createNetPage - create the general page contents
//
////////////////////////////////////////////////////////////////////////////////
void	mxSetupModify::createNetPage(Widget parent,int page_no)
{
	Widget		form;
	Widget		rowcol,form1,form2;
	Widget		modem_frame;
	Widget		supplier_frame;
	Widget		appl_frame;

//	Add a form to attach contents to

	form =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					parent,
					XmNnotebookChildType,XmPAGE,
					XmNpageNumber,page_no,
					0);

//	Add frame containing Modem prompts etc

	modem_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					0);
	XtVaCreateManagedWidget("Modem",
				xmLabelWidgetClass,
				modem_frame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				0);
	form1 =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					modem_frame,
					0);
	_netModemPortField =
	  new akRadioBox(form1,"ModemPort","Port",
			 modem_port_options,XtNumber(modem_port_options),4);
	XtVaSetValues(_netModemPortField->baseWidget(),
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNleftOffset,3,
		      XmNrightAttachment,XmATTACH_FORM,
		      XmNrightOffset,3,
		      0);
	_netModemPortField->manage();
	rowcol =
		XtVaCreateManagedWidget("RowCol",
					xmRowColumnWidgetClass,
					form1,
					XmNorientation,XmVERTICAL,
					XmNadjustLast,FALSE,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,_netModemPortField->baseWidget(),
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					0);

	_netModemSpeedField =
	  new akOptionMenu(rowcol,"ModemSpeed","Speed");
	for (int i=0;i<XtNumber(modem_speed_options);i++)
	  _netModemSpeedField->add(modem_speed_options[i]);
	_netModemSpeedField->manage();
	_netModemInitField =
	  new akPromptString(rowcol,"ModemInit","Init String");
	_netModemInitField->manage();
	form2 =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					rowcol,
					0);
	_netModemIdleField =
	  new akPromptIntRange(form2,"ModemIdle","Idle Timeout (secs)");
	XtVaSetValues(_netModemIdleField->baseWidget(),
		      XmNleftAttachment,XmATTACH_FORM,
		      0);
	_netModemIdleField->setRange(0,10000);
	_netModemIdleField->manage();
	_netModemNoRetriesField =
	  new akPromptIntRange(form2,"ModemNoRetries","No of Retries");
	XtVaSetValues(_netModemNoRetriesField->baseWidget(),
		      XmNleftAttachment,XmATTACH_WIDGET,
		      XmNleftWidget,_netModemIdleField->baseWidget(),
		      XmNrightAttachment,XmATTACH_FORM,
		      0);
	_netModemNoRetriesField->setRange(0,20);
	_netModemNoRetriesField->manage();

//	Add frame containing Supplier prompts etc

	supplier_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,modem_frame,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					0);
	XtVaCreateManagedWidget("Supplier Details",
				xmLabelWidgetClass,
				supplier_frame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				0);
	rowcol =
		XtVaCreateManagedWidget("RowCol",
					xmRowColumnWidgetClass,
					supplier_frame,
					XmNorientation,XmVERTICAL,
					XmNadjustLast,FALSE,
					0);
	_netSupplierPhoneNoField =
	  new akPromptString(rowcol,"SupplierPhoneNo","Phone No");
	_netSupplierPhoneNoField->manage();
	_netSupplierLoginField =
	  new akPromptString(rowcol,"SupplierLogin","Login Name");
	_netSupplierLoginField->manage();
	_netSupplierPasswordField =
	  new akPromptPassword(rowcol,"SupplierPassword","Password");
	_netSupplierPasswordField->manage();

//	Add frame containing Applications prompts etc

	appl_frame =
		XtVaCreateManagedWidget("Frame",
					xmFrameWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,supplier_frame,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					0);
	XtVaCreateManagedWidget("Net Applications",
				xmLabelWidgetClass,
				appl_frame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				0);
	rowcol =
		XtVaCreateManagedWidget("RowCol",
					xmRowColumnWidgetClass,
					appl_frame,
					XmNorientation,XmVERTICAL,
					0);
	_netWWWCommandField =
	  new akPromptFile(rowcol,"WWWField","WWW Application");
	_netWWWCommandField->manage();
	_netNewsCommandField =
	  new akPromptFile(rowcol,"NewsField","News Browser");
	_netNewsCommandField->manage();

//	Add the major tab and status area

	XmString	tempstr;
	tempstr = XmStringCreateLtoR("Net",XmFONTLIST_DEFAULT_TAG);
	XtVaCreateManagedWidget("ViewTab",
				xmPushButtonWidgetClass,
				parent,
				XmNlabelString,tempstr,
				XmNnotebookChildType,XmMAJOR_TAB,
				XmNpageNumber,page_no,
				0);
	XmStringFree(tempstr);
	tempstr = XmStringCreateLtoR("Net Setup parameters affecting 'mxNet' application",XmFONTLIST_DEFAULT_TAG);
	XtVaCreateManagedWidget("ViewTitle",
				xmLabelWidgetClass,
				parent,
				XmNlabelString,tempstr,
				XmNnotebookChildType,XmSTATUS_AREA,
				XmNpageNumber,page_no,
				XmNalignment,XmALIGNMENT_BEGINNING,
				0);
	XmStringFree(tempstr);

	_netPageUsed = true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update function - set values in display
//
////////////////////////////////////////////////////////////////////////////////
void 	mxSetupModify::update()
{
//	Set General page values

	if (_generalPageUsed)
	   {
	    _organisationField->setValue(theMxSetup->organisation());
	    _tempDirField->setValue(theMxSetup->tempDirectory());
	    _helpDirField->setValue(theMxSetup->helpDirectory());
	    _audioDirField->setValue(theMxSetup->audioDirectory());
	    if (theMxSetup->introSound())
	      _audioCheckBox->set(0);
	    else
	      _audioCheckBox->unset(0);
	    if (theMxSetup->checkMailSound())
	      _audioCheckBox->set(1);
	    else
	      _audioCheckBox->unset(1);
	    if (theMxSetup->newMailSound())
	      _audioCheckBox->set(2);
	    else
	      _audioCheckBox->unset(2);
	    if (theMxSetup->ftpTransferSound())
	      _audioCheckBox->set(3);
	    else
	      _audioCheckBox->unset(3);
	   }

//	Set Ftp page values

	if (_ftpPageUsed)
	   {
	    if (theMxSetup->ftpShowPermissions())
	      _ftpCheckBox->set(0);
	    else
	      _ftpCheckBox->unset(0);
	    if (theMxSetup->ftpShowNumberLinks())
	      _ftpCheckBox->set(1);
	    else
	      _ftpCheckBox->unset(1);
	    if (theMxSetup->ftpShowOwner())
	      _ftpCheckBox->set(2);
	    else
	      _ftpCheckBox->unset(2);
	    if (theMxSetup->ftpShowGroup())
	      _ftpCheckBox->set(3);
	    else
	      _ftpCheckBox->unset(3);
	    if (theMxSetup->ftpShowSize())
	      _ftpCheckBox->set(4);
	    else
	      _ftpCheckBox->unset(4);
	    if (theMxSetup->ftpShowDate())
	      _ftpCheckBox->set(5);
	    else
	      _ftpCheckBox->unset(5);
	    _ftpDefaultLocalDirField->setValue(theMxSetup->ftpDefaultLocalDir());
	    _ftpDefaultRemoteDirField->setValue(theMxSetup->ftpDefaultRemoteDir());
	    _ftpProcessFilenameField->setValue(theMxSetup->ftpProcessFilename());
	   }

//	Set Mail page values

	if (_mailPageUsed)
	   {
	    _mailSenderField->setValue(theMxSetup->mailSenderName());
	    _mailInboxField->setValue(theMxSetup->mailInboxName());
	    _mailOutboxField->setValue(theMxSetup->mailOutboxName());
	    _mailAddressbookField->setValue(theMxSetup->mailAddressbookName());
	    _mailSpambookField->setValue(theMxSetup->mailSpambookName());
	    _mailSignatureField->setValue(theMxSetup->mailSignatureName());
	    _mailFolderDirectoryField->setValue(theMxSetup->mailFolderDirectory());
	    _mailInboxReadFolderField->setValue(theMxSetup->mailInboxReadFolder());
	    _mailIndentStringField->setValue(theMxSetup->mailIndentString());
	    _mailProcessFilenameField->setValue(theMxSetup->mailProcessFilename());
	    _mailUpdateIntervalField->setValue(theMxSetup->mailUpdateInterval());
	    _mailStartupFolderList->empty();
	    setMailFolders();
	    for (int i=0;i<theMxSetup->mailNoStartupFolders();i++)
	      _mailStartupFolderList->select(theMxSetup->mailStartupFolder(i));
	    if (theMxSetup->mailMimeFormat())
	      _mailMimeFormatField->set(0);
	    else
	      _mailMimeFormatField->set(1);
	   }

//	Set News page values

	if (_newsPageUsed)
	   {
	    _newsBaseDirectoryField->setValue(theMxSetup->newsBaseDirectory());
	   }

//	Set Net page values

	if (_netPageUsed)
	   {
	    for (int i=0;i<XtNumber(modem_speed_options);i++)
	      if (atoi(modem_speed_options[i]) == theMxSetup->modemSpeed())
	    _netModemSpeedField->select(modem_speed_options[i]);
	    _netModemPortField->set(theMxSetup->modemPort()-1);
	    _netModemInitField->setValue(theMxSetup->modemInit());
	    _netModemIdleField->setValue(theMxSetup->modemIdle());
	    _netModemNoRetriesField->setValue(theMxSetup->modemNoRetries());
	    _netSupplierPhoneNoField->setValue(theMxSetup->supplierPhoneNo());
	    _netSupplierLoginField->setValue(theMxSetup->supplierLogin());
	    _netSupplierPasswordField->setValue(theMxSetup->supplierPassword());
	    _netWWWCommandField->setValue(theMxSetup->wwwCommand());
	    _netNewsCommandField->setValue(theMxSetup->newsCommand());
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Mail Folders
//
////////////////////////////////////////////////////////////////////////////////
void 	mxSetupModify::setMailFolders()
{
	string		dir;
	string		filename;
	DIR		*dfd;
	struct dirent	*dp;
	struct stat	stbuf;

	_mailStartupFolderList->empty();
	dir = _mailFolderDirectoryField->value();

	if ((dfd = opendir((char *)dir.c_str())) == NULL)
	  return;

	while (dp = readdir(dfd))
	  {
	   if (strcmp(dp->d_name,".") != 0 &&
	       strcmp(dp->d_name,"..") != 0)
	     {
	      filename = dir + dp->d_name;
	      if (stat((char *)filename.c_str(),&stbuf) != -1)
	        if ((stbuf.st_mode & S_IFMT) != S_IFDIR)
		  _mailStartupFolderList->insert(dp->d_name);
	     }
	  }
	closedir(dfd);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Save Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxSetupModify::saveCB(Widget,XtPointer clientData,XtPointer)
{
	mxSetupModify	*obj = (mxSetupModify *)clientData;

	obj->busy();

//	Extract General values and save them

	if (obj->_generalPageUsed)
	   {
	    theMxSetup->setOrganisation(obj->_organisationField->value());
	    theMxSetup->setTempDirectory(obj->_tempDirField->value());
	    theMxSetup->setHelpDirectory(obj->_helpDirField->value());
	    theMxSetup->setAudioDirectory(obj->_audioDirField->value());
	    theMxSetup->setIntroSound(obj->_audioCheckBox->selected(0));
	    theMxSetup->setCheckMailSound(obj->_audioCheckBox->selected(1));
	    theMxSetup->setNewMailSound(obj->_audioCheckBox->selected(2));
	    theMxSetup->setFtpTransferSound(obj->_audioCheckBox->selected(3));
	   }

//	Extract Net values and save them

	if (obj->_netPageUsed)
	   {
	    theMxSetup->setModemSpeed(atoi((char *)obj->_netModemSpeedField->selectedOption().c_str()));
	    theMxSetup->setModemPort(obj->_netModemPortField->selected()+1);
	    theMxSetup->setModemInit(obj->_netModemInitField->value());
	    theMxSetup->setModemIdle(obj->_netModemIdleField->value());
	    theMxSetup->setModemNoRetries(obj->_netModemNoRetriesField->value());
	    theMxSetup->setSupplierPhoneNo(obj->_netSupplierPhoneNoField->value());
	    theMxSetup->setSupplierLogin(obj->_netSupplierLoginField->value());
	    theMxSetup->setSupplierPassword(obj->_netSupplierPasswordField->value());
	    theMxSetup->setWWWCommand(obj->_netWWWCommandField->value());
	    theMxSetup->setNewsCommand(obj->_netNewsCommandField->value());
	   }

//	Extract Ftp values and save them

	if (obj->_ftpPageUsed)
	   {
	    theMxSetup->setFtpShowPermissions(obj->_ftpCheckBox->selected(0));
	    theMxSetup->setFtpShowNumberLinks(obj->_ftpCheckBox->selected(1));
	    theMxSetup->setFtpShowOwner(obj->_ftpCheckBox->selected(2));
	    theMxSetup->setFtpShowGroup(obj->_ftpCheckBox->selected(3));
	    theMxSetup->setFtpShowSize(obj->_ftpCheckBox->selected(4));
	    theMxSetup->setFtpShowDate(obj->_ftpCheckBox->selected(5));
	    theMxSetup->setFtpDefaultLocalDir(obj->_ftpDefaultLocalDirField->value());
	    theMxSetup->setFtpDefaultRemoteDir(obj->_ftpDefaultRemoteDirField->value());
	    theMxSetup->setFtpProcessFilename(obj->_ftpProcessFilenameField->value());
	   }

//	Extract Mail values and save them

	if (obj->_mailPageUsed)
	   {
	    theMxSetup->setMailSenderName(obj->_mailSenderField->value());
	    theMxSetup->setMailInboxName(obj->_mailInboxField->value());
	    theMxSetup->setMailOutboxName(obj->_mailOutboxField->value());
	    theMxSetup->setMailAddressbookName(obj->_mailAddressbookField->value());
	    theMxSetup->setMailSpambookName(obj->_mailSpambookField->value());
	    theMxSetup->setMailSignatureName(obj->_mailSignatureField->value());
	    theMxSetup->setMailFolderDirectory(obj->_mailFolderDirectoryField->value());
	    theMxSetup->setMailInboxReadFolder(obj->_mailInboxReadFolderField->value());
	    theMxSetup->setMailIndentString(obj->_mailIndentStringField->value());
	    theMxSetup->setMailProcessFilename(obj->_mailProcessFilenameField->value());
	    theMxSetup->setMailUpdateInterval(obj->_mailUpdateIntervalField->value());
	    string	*folders;
	    int	nfolders;
	    nfolders = obj->_mailStartupFolderList->noSelectedItems();
	    folders  = obj->_mailStartupFolderList->selectedItems();
	    theMxSetup->setMailStartupFolders(nfolders,folders);
	    if (nfolders > 0)
	      delete []folders;
	    if (obj->_mailMimeFormatField->selected() == 0)
	      theMxSetup->setMailMimeFormat(true);
	    else
	      theMxSetup->setMailMimeFormat(false);
	   }

//	Extract News values and save them

	if (obj->_newsPageUsed)
	   {
	    theMxSetup->setNewsBaseDirectory(obj->_newsBaseDirectoryField->value());
	   }

//	Save the global setup object

	theMxSetup->write();

//	Unmanage the panel

	obj->unmanage();
	obj->ready();

//	If required, call the users callback

	if (obj->_userCB != (XtCallbackProc)0)
	  obj->_userCB(obj->_w,obj->_userData,0);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Cancel Callback - just unmanage the panel
//
////////////////////////////////////////////////////////////////////////////////
void 	mxSetupModify::cancelCB(Widget,XtPointer clientData,XtPointer)
{
	mxSetupModify	*obj = (mxSetupModify *)clientData;

	obj->busy();
	obj->unmanage();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Mail Folder Directory changed - update mail startup folder list
//
////////////////////////////////////////////////////////////////////////////////
void 	mxSetupModify::mailFolderDirectoryChangedCB(XtPointer clientData,string dir)
{
	mxSetupModify	*obj = (mxSetupModify *)clientData;

	obj->busy();
	obj->setMailFolders();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Page Changed Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxSetupModify::pageChangedCB(Widget,XtPointer clientData,XtPointer)
{
	mxSetupModify	*obj = (mxSetupModify *)clientData;

	obj->busy();
	obj->ready();
}
