#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <pwd.h>
#include <Xm/Frame.h>
#include <Xm/ScrolledW.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/PanedW.h>
#include <Xm/IconG.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/Container.h>

#include "akApp.h"
#include "akFileDialogMgr.h"
#include "mxMailMsgDisplay.h"
#include "mxSetup.h"
#include "mxFileViewer.h"
#include "mxButtons.xpm"
#include "mxMailAttachmentTypes.xpm"

akPixmap	*mxMailMsgDisplay::_fileAttachmentIcon=0;
akPixmap	*mxMailMsgDisplay::_imageAttachmentIcon=0;
akPixmap	*mxMailMsgDisplay::_audioAttachmentIcon=0;
akPixmap	*mxMailMsgDisplay::_videoAttachmentIcon=0;
akPixmap	*mxMailMsgDisplay::_messageAttachmentIcon=0;
akPixmap	*mxMailMsgDisplay::_applicationAttachmentIcon=0;
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailMsgDisplay::mxMailMsgDisplay(Widget parent,
				char *name,
				mxMailMsgDisplayMode mode,
				mxMailMsg msg,
				mxMailAddressBook *book)
	:akComponent(name),
	 _mode(mode),
	 _msg(msg),
	 _addressbook(book),
	 _addressSelector(0),
	 _fromField((akPromptString *)0),
	 _organisationField((akPromptString *)0),
	 _toField((akPromptString *)0),
	 _ccField((akPromptString *)0),
	 _bccField((akPromptString *)0),
	 _subjectField((akPromptString *)0),
	 _dateField((akPromptString *)0),
	 _messageIdField((akPromptString *)0),
	 _messageField((Widget)0),
	 _attachmentFrame((Widget)0),
	 _attachmentContainer((Widget)0),
	 _fileButton((akButton *)0),
	 _printButton((akButton *)0),
	 _addressButton((akButton *)0),
	 _fileAttachmentButton((akButton *)0)
{

//	Set up attachment icons

	if (!_fileAttachmentIcon)
	  _fileAttachmentIcon = new akPixmap(mxMailAttachFile_xpm);
	if (!_imageAttachmentIcon)
	  _imageAttachmentIcon = new akPixmap(mxMailAttachImage_xpm);
	if (!_audioAttachmentIcon)
	  _audioAttachmentIcon = new akPixmap(mxMailAttachAudio_xpm);
	if (!_videoAttachmentIcon)
	  _videoAttachmentIcon = new akPixmap(mxMailAttachVideo_xpm);
	if (!_messageAttachmentIcon)
	  _messageAttachmentIcon = new akPixmap(mxMailAttachMessage_xpm);
	if (!_applicationAttachmentIcon)
	  _applicationAttachmentIcon = new akPixmap(mxMailAttachApplication_xpm);

	Arg		args[10];
	Widget		header_form;
	Widget		form,rowcol,button_rowcol;
	Widget		header_frame,body_frame;
	Widget		temp_form,attachment_form,attachment_scroll;
	Widget		message_pane;

//	Create a frame and form to attach contents to

	XtSetArg(args[0],XmNshadowType,XmSHADOW_ETCHED_OUT);
	XtSetArg(args[1],XmNshadowThickness,5);
	_w = XmCreateFrame(parent,_name,args,2);
	form =
		XtVaCreateManagedWidget("Form",xmFormWidgetClass,_w,0);

	header_form =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					0);

//	Add message function buttons

	button_rowcol =
		XtVaCreateManagedWidget("MessageButtons",
					xmRowColumnWidgetClass,
					header_form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNrightOffset,2,
					XmNorientation,XmVERTICAL,
					XmNnumColumns,1,
					0);
	if (_mode == MX_MSG_DISPLAY)
	   {
	    _printButton =
	      new akButton(button_rowcol,"Print",mxPrint_xpm,
			  &mxMailMsgDisplay::printCB,(XtPointer)this);
	    _printButton->installHelp("Print this message\nto the printer");
	    _printButton->manage();
	    _fileButton =
	      new akButton(button_rowcol,"File",mxFile_xpm,
			  &mxMailMsgDisplay::fileCB,(XtPointer)this);
	    _fileButton->installHelp("Save this message\nto file");
	    _fileButton->manage();
	   }
	else if (_mode == MX_MSG_COMPOSE)
	   {
	    _addressButton =
	      new akButton(button_rowcol,"Addressbook",mxAddressbook_xpm,
	 		  &mxMailMsgDisplay::addressCB,(XtPointer)this);
	    _addressButton->installHelp("Select addressees\nfrom AddressBook");
	    _addressButton->manage();
	   }

//	Create message header area

	header_frame =
		XtVaCreateManagedWidget("MessageHeaderFrame",
					xmFrameWidgetClass,
					header_form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNleftOffset,2,
					XmNrightAttachment,XmATTACH_WIDGET,
					XmNrightWidget,button_rowcol,
					0);
	XtVaCreateManagedWidget("Message Header",
				xmLabelWidgetClass,
				header_frame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				0);
	rowcol =
		XtVaCreateManagedWidget("MessageHeader",
					xmRowColumnWidgetClass,
					header_frame,
					XmNorientation,XmVERTICAL,
					XmNnumColumns,1,
					0);

//	From/Organisation/MessageId/Date fields - only for DISPLAY mode

	if (_mode == MX_MSG_DISPLAY)
	  {
	   // From and Organisation

	   temp_form = XtVaCreateManagedWidget("Form",xmFormWidgetClass,rowcol,0);
	   _fromField =
	     new akPromptString(temp_form,"MessageFrom","From");
	   XtVaSetValues(_fromField->fieldWidget(),
			 XmNmarginHeight,1,
			 XmNmarginWidth,2,
			 XmNeditable,FALSE,
			 XmNhighlightThickness,0,
			 XmNblinkRate,0,
			 XmNcursorPositionVisible,FALSE,
			 0);
	   _organisationField =
	     new akPromptString(temp_form,"MessageOrganisation","Organisation");
	   XtVaSetValues(_organisationField->fieldWidget(),
			 XmNmarginHeight,1,
			 XmNmarginWidth,2,
			 XmNeditable,FALSE,
			 XmNhighlightThickness,0,
			 XmNblinkRate,0,
			 XmNcolumns,15,
			 XmNcursorPositionVisible,FALSE,
			 0);
	   XtVaSetValues(_organisationField->baseWidget(),
			 XmNrightAttachment,XmATTACH_FORM,
			 0);
	   XtVaSetValues(_fromField->baseWidget(),
			 XmNleftAttachment,XmATTACH_FORM,
			 XmNrightAttachment,XmATTACH_WIDGET,
			 XmNrightWidget,_organisationField->baseWidget(),
			 0);
	   _fromField->manage();
	   _organisationField->manage();

	   // MessageId and Date

	   temp_form = XtVaCreateManagedWidget("Form",xmFormWidgetClass,rowcol,0);
	   _messageIdField =
	     new akPromptString(temp_form,"MessageId","MsgId");
	   XtVaSetValues(_messageIdField->fieldWidget(),
			 XmNmarginHeight,1,
			 XmNmarginWidth,2,
			 XmNeditable,FALSE,
			 XmNhighlightThickness,0,
			 XmNblinkRate,0,
			 XmNcolumns,20,
			 XmNcursorPositionVisible,FALSE,
			 0);
	   _dateField =
	     new akPromptString(temp_form,"MessageDate","Date");
	   XtVaSetValues(_dateField->fieldWidget(),
			 XmNmarginHeight,1,
			 XmNmarginWidth,2,
			 XmNeditable,FALSE,
			 XmNhighlightThickness,0,
			 XmNblinkRate,0,
			 XmNcolumns,30,
			 XmNcursorPositionVisible,FALSE,
			 0);
	   XtVaSetValues(_dateField->baseWidget(),
			 XmNrightAttachment,XmATTACH_FORM,
			 0);
	   XtVaSetValues(_messageIdField->baseWidget(),
			 XmNleftAttachment,XmATTACH_FORM,
			 XmNrightAttachment,XmATTACH_WIDGET,
			 XmNrightWidget,_dateField->baseWidget(),
			 0);
	   _messageIdField->manage();
	   _dateField->manage();
	  }

//	To field - for both modes

	_toField =
	  new akPromptString(rowcol,"MessageTo","To");
	XtVaSetValues(_toField->fieldWidget(),
		      XmNmarginHeight,1,
		      XmNmarginWidth,2,
		      XmNeditable,FALSE,
		      XmNhighlightThickness,0,
		      XmNblinkRate,0,
		      XmNcursorPositionVisible,FALSE,
		      0);
	_toField->manage();
	if (_mode == MX_MSG_COMPOSE)
	  XtVaSetValues(_toField->fieldWidget(),
			XmNeditable,TRUE,
			XmNcursorPositionVisible,TRUE,
		        XmNblinkRate,500,
			0);

//	Cc field

	_ccField =
	     new akPromptString(rowcol,"MessageCc","Cc");
	XtVaSetValues(_ccField->fieldWidget(),
		      XmNmarginHeight,1,
		      XmNmarginWidth,2,
		      XmNeditable,FALSE,
		      XmNhighlightThickness,0,
		      XmNblinkRate,0,
		      XmNcursorPositionVisible,FALSE,
		      0);
	_ccField->manage();
	if (_mode == MX_MSG_COMPOSE)
	  XtVaSetValues(_ccField->fieldWidget(),
			XmNeditable,TRUE,
			XmNcursorPositionVisible,TRUE,
		        XmNblinkRate,500,
			0);

//	Bcc field

	_bccField =
	     new akPromptString(rowcol,"MessageBcc","Bcc");
	XtVaSetValues(_bccField->fieldWidget(),
			 XmNmarginHeight,1,
			 XmNmarginWidth,2,
			 XmNhighlightThickness,0,
			 XmNblinkRate,500,
			 XmNeditable,TRUE,
			 XmNcursorPositionVisible,TRUE,
			 0);
	_bccField->manage();

//	Subject field - for both modes

	_subjectField =
	  new akPromptString(rowcol,"MessageSubject","Subject");
	XtVaSetValues(_subjectField->fieldWidget(),
		      XmNmarginHeight,1,
		      XmNmarginWidth,2,
		      XmNeditable,FALSE,
		      XmNhighlightThickness,0,
		      XmNblinkRate,0,
		      XmNcursorPositionVisible,FALSE,
		      0);
	_subjectField->manage();
	if (_mode == MX_MSG_COMPOSE)
	  XtVaSetValues(_subjectField->fieldWidget(),
			XmNeditable,TRUE,
			XmNcursorPositionVisible,TRUE,
			XmNblinkRate,500,
			0);

//	Add message pane

	message_pane =
		XtVaCreateManagedWidget("Pane",
					xmPanedWindowWidgetClass,
					form,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,header_frame,
					0);

//	Create message attachments area

	_attachmentFrame =
		XtVaCreateManagedWidget("MessageAttachmentFrame",
					xmFrameWidgetClass,
					message_pane,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNleftOffset,2,
					XmNrightAttachment,XmATTACH_FORM,
					XmNrightOffset,2,
					XmNpaneMinimum,120,
					XmNpositionIndex,1,
					0);
	XtVaCreateManagedWidget("Message Attachments",
				xmLabelWidgetClass,
				_attachmentFrame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				0);
	attachment_form =
		XtVaCreateManagedWidget("Form",
					xmFormWidgetClass,
					_attachmentFrame,
					0);
	if (_mode == MX_MSG_DISPLAY)
	  {
	   _fileAttachmentButton =
	     new akButton(attachment_form,"File",mxFile_xpm,
			  &mxMailMsgDisplay::fileAttachmentCB,(XtPointer)this);
	   _fileAttachmentButton->installHelp("Save the selected\nattachment to file");
	   XtVaSetValues(_fileAttachmentButton->baseWidget(),
			 XmNtopAttachment,XmATTACH_FORM,
			 XmNrightAttachment,XmATTACH_FORM,
			 0);
	   _fileAttachmentButton->manage();
	  }
	attachment_scroll =
		XtVaCreateManagedWidget("Scroll",
					xmScrolledWindowWidgetClass,
					attachment_form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNscrollingPolicy,XmAUTOMATIC,
					XmNscrollBarDisplayPolicy,XmSTATIC,
					XmNresizable,TRUE,
					0);
	if (_mode == MX_MSG_DISPLAY)
	  XtVaSetValues(attachment_scroll,
			XmNrightAttachment,XmATTACH_WIDGET,
			XmNrightWidget,_fileAttachmentButton->baseWidget(),
			0);
	else
	  XtVaSetValues(attachment_scroll,XmNrightAttachment,XmATTACH_FORM,0);

	XmString	details[5];
	details[0] = XmStringCreateLocalized(" ");
	details[1] = XmStringCreateLocalized("Type");
	details[2] = XmStringCreateLocalized("Subtype");
	details[3] = XmStringCreateLocalized("Size");
	details[4] = XmStringCreateLocalized("Name");
	_attachmentContainer =
		XtVaCreateManagedWidget("MessageAttachmentContainer",
					xmContainerWidgetClass,
					attachment_scroll,
					XmNlayoutType,XmDETAIL,
					XmNoutlineLineStyle,XmNO_LINE,
					XmNoutlineIndentation,0,
					XmNentryViewType,XmSMALL_ICON,
					XmNdetailColumnHeading,details,
					XmNdetailColumnHeadingCount,5,
					0);
	for (int i=0;i<5;i++)
	  XmStringFree(details[i]);
	XtAddCallback(_attachmentContainer,XmNdefaultActionCallback,
		      &mxMailMsgDisplay::containerActionCB,(XtPointer)this);
	Dimension	container_width,container_height;
	XtVaGetValues(_attachmentContainer,
		      XtNwidth,&container_width,
		      XtNheight,&container_height,
		      0);

//	Create message body area

	body_frame =
		XtVaCreateManagedWidget("MessageBodyFrame",
					xmFrameWidgetClass,
					message_pane,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,header_frame,
					XmNbottomAttachment,XmATTACH_WIDGET,
					XmNbottomWidget,_attachmentFrame,
					XmNleftAttachment,XmATTACH_FORM,
					XmNleftOffset,2,
					XmNrightAttachment,XmATTACH_FORM,
					XmNrightOffset,2,
					XmNpositionIndex,0,
					0);
	XtVaCreateManagedWidget("Message Body",
				xmLabelWidgetClass,
				body_frame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				0);
	if (_mode == MX_MSG_DISPLAY)
	  {
	   XtSetArg(args[0],XmNeditMode,XmMULTI_LINE_EDIT);
	   XtSetArg(args[1],XmNresizeHeight,False);
	   XtSetArg(args[2],XmNcursorPositionVisible,FALSE);
	   XtSetArg(args[3],XmNeditable,FALSE);
	   XtSetArg(args[4],XmNwordWrap,TRUE);
	   XtSetArg(args[5],XmNscrollBarDisplayPolicy,XmAS_NEEDED);
	   XtSetArg(args[6],XmNscrollingPolicy,XmAUTOMATIC);
	   XtSetArg(args[7],XmNscrollHorizontal,FALSE);
	   XtSetArg(args[8],XmNcolumns,80);
	   _messageField =
		XmCreateScrolledText(body_frame,"MessageBody",args,9);
	  }
	else
	  {
	   XtSetArg(args[0],XmNeditMode,XmMULTI_LINE_EDIT);
	   XtSetArg(args[1],XmNresizeHeight,False);
	   XtSetArg(args[2],XmNcursorPositionVisible,TRUE);
	   XtSetArg(args[3],XmNeditable,TRUE);
	   XtSetArg(args[4],XmNwordWrap,TRUE);
	   XtSetArg(args[5],XmNscrollBarDisplayPolicy,XmAS_NEEDED);
	   XtSetArg(args[6],XmNscrollingPolicy,XmAUTOMATIC);
	   XtSetArg(args[7],XmNscrollHorizontal,FALSE);
	   XtSetArg(args[8],XmNcolumns,80);
	   _messageField =
		XmCreateScrolledText(body_frame,"MessageBody",args,9);
	  }
	XtManageChild(_messageField);

	installDestroyHandler();

//	Fill in field values

	update();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailMsgDisplay::~mxMailMsgDisplay()
{
	if (_fromField)
	  delete _fromField;
	if (_organisationField)
	  delete _organisationField;
	if (_toField)
	  delete _toField;
	if (_ccField)
	  delete _ccField;
	if (_bccField)
	  delete _bccField;
	if (_subjectField)
	  delete _subjectField;
	if (_messageIdField)
	  delete _messageIdField;
	if (_dateField)
	  delete _dateField;
	if (_fileButton)
	  delete _fileButton;
	if (_printButton)
	  delete _printButton;
	if (_addressButton)
	  delete _addressButton;
	if (_fileAttachmentButton)
	  delete _fileAttachmentButton;
	if (_addressSelector)
	  delete _addressSelector;

	for (int i=0;i<_attachmentIcons.size();i++)
	  {
	   Widget	widget = _attachmentIcons[i].w;
	   XtDestroyWidget(widget);
	  }

	for (int i=_fileViewers.size()-1;i>=0;i--)
	  delete _fileViewers[i];
	for (int i=_messageViewers.size()-1;i>=0;i--)
	  delete _messageViewers[i];
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update function	- (re)sets content of message view.
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailMsgDisplay::update()
{
	if (_fromField)
	   {
	    string	temp_author;
	    if (_msg.author().size() > 0)
	       {
		temp_author = _msg.author();
		temp_author += " <";
		temp_author += _msg.mailid();
		temp_author += ">";
	       }
	    else
	       {
		temp_author = _msg.mailid();
	       }
	    _fromField->setValue(temp_author);
	   }
	if (_organisationField)
	  _organisationField->setValue(_msg.organisation());
	if (_toField)
	  _toField->setValue(_msg.toAddressee());
	if (_ccField)
	   {
	    _ccField->setValue(_msg.ccAddressee());
	    if (_msg.ccAddressee().empty() && _mode == MX_MSG_DISPLAY)
	      _ccField->unmanage();
	    else
	      _ccField->manage();
	   }
	if (_bccField)
	   {
	    _bccField->setValue(_msg.bccAddressee());
	    if (_msg.bccAddressee().empty() && _mode == MX_MSG_DISPLAY)
	      _bccField->unmanage();
	    else
	      _bccField->manage();
	   }
	if (_subjectField)
	  _subjectField->setValue(_msg.subject());
	if (_messageIdField)
	  _messageIdField->setValue(_msg.messageId());
	if (_dateField)
	  _dateField->setValue(_msg.date());

	for (int i=_attachmentIcons.size()-1;i>=0;i--)
	  {
	   Widget	widget = _attachmentIcons[i].w;
	   XtDestroyWidget(widget);
	   _attachmentIcons.pop_back();
	  }

//	Extract text of message for display in text area

	XmTextSetString(_messageField,(char *)(_msg.bodyText().c_str()));

//	Attachments

	// No attachments so unmanage attachments container
	if (_msg.noOfAttachments() == 0)
	  XtUnmanageChild(_attachmentFrame);

	// Attachments, so manage container and add attachments
	else
	  {
	   XtManageChild(_attachmentFrame);
	   for (int i=0;i<_msg.noOfAttachments();i++)
	     addAttachment(_msg.attachment(i));
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Add Attachment
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailMsgDisplay::addAttachment(const mxMailAttachment& att)
{
	mxMailAttachmentIcon	icon;
	XmString		details[4];
	char			size_str[20];
	Pixmap			icon_pixmap;

	icon.att = att;
	if (icon.att.type() == MX_FILE)
	  {
	   details[0] = XmStringCreateLocalized("Text File");
	   icon_pixmap = _fileAttachmentIcon->pixmap();
	  }
	else if (icon.att.type() == MX_IMAGE)
	  {
	   details[0] = XmStringCreateLocalized("Image File");
	   icon_pixmap = _imageAttachmentIcon->pixmap();
	  }
	else if (icon.att.type() == MX_AUDIO)
	  {
	   details[0] = XmStringCreateLocalized("Audio File");
	   icon_pixmap = _audioAttachmentIcon->pixmap();
	  }
	else if (icon.att.type() == MX_VIDEO)
	  {
	   details[0] = XmStringCreateLocalized("Video File");
	   icon_pixmap = _videoAttachmentIcon->pixmap();
	  }
	else if (icon.att.type() == MX_MESSAGE)
	  {
	   details[0] = XmStringCreateLocalized("Message");
	   icon_pixmap = _messageAttachmentIcon->pixmap();
	  }
	else if (icon.att.type() == MX_APPLICATION)
	  {
	   details[0] = XmStringCreateLocalized("Application");
	   icon_pixmap = _applicationAttachmentIcon->pixmap();
	  }
	else
	  {
	   details[0] = XmStringCreateLocalized("Unknown");
	   icon_pixmap = _fileAttachmentIcon->pixmap();
	  }
	details[1] = XmStringCreateLocalized((char *)(icon.att.subtype().c_str()));
	if (icon.att.type() == MX_MESSAGE)
	  {
	   sprintf(size_str,"%d",icon.att.message().length());
	   details[2] = XmStringCreateLocalized(size_str);
	   details[3] = XmStringCreateLocalized((char *)(icon.att.message().subject().c_str()));
	  }
	else
	  {
           sprintf(size_str,"%d",icon.att.file().contents.size());
	   details[2] = XmStringCreateLocalized(size_str);
	   details[3] = XmStringCreateLocalized((char *)(icon.att.file().filename.c_str()));
	  }
	icon.w =
		XtVaCreateManagedWidget("",
					xmIconGadgetClass,
					_attachmentContainer,
					XmNsmallIconPixmap,icon_pixmap,
					XmNdetailCount,4,
					XmNdetail,details,
					0);
	for (int i=0;i<4;i++)
	  XmStringFree(details[i]);

	_attachmentIcons.push_back(icon);

	if (_attachmentIcons.size() == 1)
	  XtManageChild(_attachmentFrame);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Delete Current Attachment
//
////////////////////////////////////////////////////////////////////////////////
bool	mxMailMsgDisplay::deleteSelectedAttachment()
{
	Widget	*selections;
	int	nselections;

//	Find selected attachment

	XtVaGetValues(_attachmentContainer,
		      XmNselectedObjects,&selections,
		      XmNselectedObjectCount,&nselections,
		      0);
	if (nselections == 0)
	  return false;

	for (int i=0;i<nselections;i++)
	  {
	   for (int j=0;j<_attachmentIcons.size();j++)
	     {
	      if (selections[i] == _attachmentIcons[j].w)
		{
		 Widget	widget = _attachmentIcons[j].w;
		 XtDestroyWidget(widget);
		 _attachmentIcons.erase(_attachmentIcons.begin()+j);
		}
	     }
	  }

	if (_attachmentIcons.size() == 0)
	  XtUnmanageChild(_attachmentFrame);

	return true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Selected Attachment
//
////////////////////////////////////////////////////////////////////////////////
const mxMailAttachment	*mxMailMsgDisplay::selectedAttachment() const
{
	Widget			*selections;
	int			nselections;

//	Find selected attachment

	XtVaGetValues(_attachmentContainer,
		      XmNselectedObjects,&selections,
		      XmNselectedObjectCount,&nselections,
		      0);
	if (nselections == 0)
	  return (mxMailAttachment *)0;

	for (int i=0;i<nselections;i++)
	  {
	   for (int j=0;j<_attachmentIcons.size();j++)
	     {
	      if (selections[i] == _attachmentIcons[j].w)
		return &_attachmentIcons[j].att;
	     }
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Clear message
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailMsgDisplay::clearMessage()
{
//	Clear header fields

	if (_fromField)
	  _fromField->clear();
	if (_organisationField)
	  _organisationField->clear();
	if (_toField)
	  _toField->clear();
	if (_ccField)
	  _ccField->clear();
	if (_bccField)
	  _bccField->clear();
	if (_subjectField)
	  _subjectField->clear();
	if (_messageIdField)
	  _messageIdField->clear();
	if (_dateField)
	  _dateField->clear();

//	Clear message text

	XmTextSetString(_messageField,"");

//	Remove all attachments

	for (int i=_attachmentIcons.size()-1;i>=0;i--)
	  {
	   Widget	widget = _attachmentIcons[i].w;
	   XtDestroyWidget(widget);
	   _attachmentIcons.pop_back();
	  }
	if (_attachmentIcons.size() == 0)
	  XtUnmanageChild(_attachmentFrame);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set subject
//
////////////////////////////////////////////////////////////////////////////////
bool	mxMailMsgDisplay::setSubject(string subject)
{
	if (_mode == MX_MSG_DISPLAY)
	  return false;

	_subjectField->setValue(subject);
	return true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set To
//
////////////////////////////////////////////////////////////////////////////////
bool	mxMailMsgDisplay::setTo(string to)
{
	if (_mode == MX_MSG_DISPLAY)
	  return false;

	_toField->setValue(to);
	return true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Cc
//
////////////////////////////////////////////////////////////////////////////////
bool	mxMailMsgDisplay::setCc(string cc)
{
	if (_mode == MX_MSG_DISPLAY)
	  return false;

	_ccField->setValue(cc);
	return true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Bcc
//
////////////////////////////////////////////////////////////////////////////////
bool	mxMailMsgDisplay::setBcc(string bcc)
{
	if (_mode == MX_MSG_DISPLAY)
	  return false;

	_bccField->setValue(bcc);
	return true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Text
//
////////////////////////////////////////////////////////////////////////////////
bool	mxMailMsgDisplay::setText(string text)
{
	if (_mode == MX_MSG_DISPLAY)
	  return false;

	XmTextSetString(_messageField,(char *)text.c_str());
	return true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Insert Text
//
////////////////////////////////////////////////////////////////////////////////
bool	mxMailMsgDisplay::insertText(string text)
{
	if (_mode == MX_MSG_DISPLAY)
	  return false;

	XmTextInsert(_messageField,
		     XmTextGetInsertionPosition(_messageField),
		     (char *)text.c_str());
	return true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Message update function - changes the message content
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailMsgDisplay::setMessage(mxMailMsg msg)
{
	_msg = msg;

	update();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Container Action Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailMsgDisplay::containerActionCB(Widget w,XtPointer clientData,XtPointer callData)
{
	mxMailMsgDisplay	*obj = (mxMailMsgDisplay *)clientData;
	XmContainerSelectCallbackStruct *cbs =
		(XmContainerSelectCallbackStruct *)callData;

	Widget	item=cbs->selected_items[0];
	for (int i=0;i<obj->_attachmentIcons.size();i++)
	  {
	   if (item == obj->_attachmentIcons[i].w)
	     {
	      if (obj->_attachmentIcons[i].att.type() == MX_FILE)
		{
		 mxFileViewer	*viewer;
		 viewer = new mxFileViewer("mxFileViewer",
			obj->_attachmentIcons[i].att.file().filename,
			obj->_attachmentIcons[i].att.file().contents,
			mxMailMsgDisplay::fileViewerClosedCB,(XtPointer)obj);
		 obj->_fileViewers.push_back(viewer);
		 viewer->manage();
		}
	      else if (obj->_attachmentIcons[i].att.type() == MX_MESSAGE)
		{
		 mxMailMsgViewer	*viewer;
		 viewer = new mxMailMsgViewer("mxMailMsgViewer",
			obj->_attachmentIcons[i].att.message(),
			mxMailMsgDisplay::messageViewerClosedCB,(XtPointer)obj);
		 obj->_messageViewers.push_back(viewer);
		 viewer->manage();
		}
	      else if (obj->_attachmentIcons[i].att.type() == MX_IMAGE)
		{
		}
	      else if (obj->_attachmentIcons[i].att.type() == MX_AUDIO)
		{
		}
	      else if (obj->_attachmentIcons[i].att.type() == MX_VIDEO)
		{
		}
	      else if (obj->_attachmentIcons[i].att.type() == MX_APPLICATION)
		{
		}
	     }
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	File Viewer Closed Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailMsgDisplay::fileViewerClosedCB(Widget,XtPointer clientData,XtPointer callData)
{
	mxMailMsgDisplay	*obj = (mxMailMsgDisplay *)clientData;
	mxFileViewer		*viewer = (mxFileViewer *)callData;

	for (int i=0;i<obj->_fileViewers.size();i++)
	  {
	   if (obj->_fileViewers[i] == viewer)
	     obj->_fileViewers.erase(obj->_fileViewers.begin()+i);
	  }
	delete viewer;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Message Viewer Closed Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailMsgDisplay::messageViewerClosedCB(Widget,XtPointer clientData,XtPointer callData)
{
	mxMailMsgDisplay	*obj = (mxMailMsgDisplay *)clientData;
	mxMailMsgViewer		*viewer = (mxMailMsgViewer *)callData;

	for (int i=0;i<obj->_messageViewers.size();i++)
	  {
	   if (obj->_messageViewers[i] == viewer)
	     obj->_messageViewers.erase(obj->_messageViewers.begin()+i);
	  }
	delete viewer;
}
////////////////////////////////////////////////////////////////////////////////
//
//	File Attachment Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailMsgDisplay::fileAttachmentCB(Widget w,XtPointer clientData,XtPointer)
{
	mxMailMsgDisplay	*obj = (mxMailMsgDisplay *)clientData;
	Widget	*selections;
	int	nselections;

//	Find selected attachment

	obj->_fileAttachmentNo = -1;
	XtVaGetValues(obj->_attachmentContainer,
		      XmNselectedObjects,&selections,
		      XmNselectedObjectCount,&nselections,
		      0);
	if (nselections == 0)
	   {
	    XBell(XtDisplay(w),50);
	    return;
	   }

	for (int i=0;i<nselections;i++)
	  {
	   for (int j=0;j<obj->_attachmentIcons.size();j++)
	     {
	      if (selections[i] == obj->_attachmentIcons[j].w)
		{
		 obj->_fileAttachmentNo = j;
		 theAkFileDialogMgr->post("Save To File",
					  "*",
					  (XtPointer)obj,
					  mxMailMsgDisplay::fileAttachmentOK,
					  mxMailMsgDisplay::fileCANCEL);
		}
	     }
	  }
	if (obj->_fileAttachmentNo < 0)
	  XBell(XtDisplay(w),50);
}
////////////////////////////////////////////////////////////////////////////////
//
//	File Attachment OK - copy attachment to a file
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailMsgDisplay::fileAttachmentOK(XtPointer clientData,XtPointer callData)
{
	mxMailMsgDisplay	*obj = (mxMailMsgDisplay *)clientData;
	XmFileSelectionBoxCallbackStruct	*cbs =
	  (XmFileSelectionBoxCallbackStruct *)callData;
	string			selected_message;
	char			*selection;
	string			selected_file;

//	Filed attachment no outside range - return

	if (obj->_fileAttachmentNo < 0 ||
	    obj->_fileAttachmentNo >= obj->_msg.noOfAttachments())
	  return;

//	Retrieve selected filename

	obj->busy();
	XmStringGetLtoR(cbs->value,XmFONTLIST_DEFAULT_TAG,&selection);
	selected_file = selection;
	free(selection);

//	Write attachment to selected file (overwriting it)

	mxMailAttachment	attachment;
	attachment = obj->_msg.attachment(obj->_fileAttachmentNo);

	// Message attachment
	if (attachment.type() == MX_MESSAGE)
	  attachment.message().writeToFile(selected_file,FALSE,FALSE);

	// File attachment
	else
	  {
	   ofstream	outfile((char *)selected_file.c_str());
	   if (outfile)
	     outfile << attachment.file().contents;
	   outfile.close();
	  }
	obj->_fileAttachmentNo = -1;

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	File Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailMsgDisplay::fileCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailMsgDisplay	*obj = (mxMailMsgDisplay *)clientData;

	theAkFileDialogMgr->post("Save To File",
				 "*",
				 (XtPointer)obj,
				 mxMailMsgDisplay::fileOK,
				 mxMailMsgDisplay::fileCANCEL);
}
////////////////////////////////////////////////////////////////////////////////
//
//	File OK - copy message to a file
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailMsgDisplay::fileOK(XtPointer clientData,XtPointer callData)
{
	mxMailMsgDisplay	*obj = (mxMailMsgDisplay *)clientData;
	XmFileSelectionBoxCallbackStruct	*cbs =
	  (XmFileSelectionBoxCallbackStruct *)callData;
	string			selected_message;
	char			*selection;
	string			selected_file;

	obj->busy();
	XmStringGetLtoR(cbs->value,XmFONTLIST_DEFAULT_TAG,&selection);
	selected_file = selection;

//	Write message to selected file (overwriting it)

	obj->_msg.writeToFile(selected_file,FALSE,FALSE);

	free(selection);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	File CANCEL
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailMsgDisplay::fileCANCEL(XtPointer,XtPointer)
{
//	Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	Print Callback - print the selected message
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailMsgDisplay::printCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailMsgDisplay	*obj = (mxMailMsgDisplay *)clientData;
	char			tempfile[100];
	string			printfile;

	obj->busy();

//	Put the message into a temporary file

	time_t	the_time;
	tm	*t;
	time(&the_time);
	t = localtime(&the_time);
	strftime(tempfile,100,"mxPrint_%d%m%y.%H%M%S",t);

	printfile = theMxSetup->tempDirectory() + tempfile;
	obj->_msg.writeToFile(printfile,FALSE,FALSE);

//	Print with the system command

	string	system_command;
	system_command  = "cat " + printfile + " | lpr -r";
	system((char *)system_command.c_str());
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Address Callback - Address selection button pressed
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailMsgDisplay::addressCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailMsgDisplay	*obj = (mxMailMsgDisplay *)clientData;

	if (!obj->_addressSelector)
	  obj->_addressSelector =
	     new mxMailAddressSelect(obj->_w,"mxMailAddressSelect",
				obj->_addressbook,
				&mxMailMsgDisplay::addressSelectedCB,
				(XtPointer)obj);
	obj->_addressSelector->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Address Selected Callback - Address has been selected
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailMsgDisplay::addressSelectedCB(XtPointer clientData,mxMailAddressSelection selection)
{
	mxMailMsgDisplay	*obj = (mxMailMsgDisplay *)clientData;
	string			existing_field;

	if (selection.destination == MX_MAIL_ADDRESS_TO)
	   {
	    existing_field = obj->_toField->value();
	    if (existing_field.size() > 0)
	       {
		existing_field += ",";
	       }
	    existing_field += selection.address.alias();
	    obj->setTo(existing_field);
	   }
	else if (selection.destination == MX_MAIL_ADDRESS_CC)
	   {
	    existing_field = obj->_ccField->value();
	    if (existing_field.size() > 0)
	       {
		existing_field += ",";
	       }
	    existing_field += selection.address.alias();
	    obj->setCc(existing_field);
	   }
	else if (selection.destination == MX_MAIL_ADDRESS_BCC)
	   {
	    existing_field = obj->_bccField->value();
	    if (existing_field.size() > 0)
	       {
		existing_field += ",";
	       }
	    existing_field += selection.address.alias();
	    obj->setBcc(existing_field);
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Message retrieval function
//
////////////////////////////////////////////////////////////////////////////////
const mxMailMsg& 	mxMailMsgDisplay::msg()
{
	if (_mode == MX_MSG_DISPLAY)
	  return _msg;

//	For COMPOSE mode, set up the mail message from the fields

	// Set up header

	passwd	*password = getpwuid(getuid());
	_msg.setAuthor(password->pw_gecos);
	_msg.setSubject(_subjectField->value());

	string	mailid=theMxSetup->mailSenderName();;
	_msg.setMailid(mailid);

	time_t	the_time;
	tm	*t;
	time(&the_time);
	t = localtime(&the_time);
	char	message_id[100];
	if (getenv("HOSTNAME"))
	  sprintf(message_id,"mxMail.%d%d%d%d%d%d@%s",
		t->tm_year,t->tm_mon+1,t->tm_mday,
		t->tm_hour,t->tm_min,t->tm_sec,getenv("HOSTNAME"));
	else
	   {
	    char	hostname[100];
	    gethostname(hostname,100);
	    sprintf(message_id,"mxMail.%d%d%d%d%d%d@%s",
		t->tm_year,t->tm_mon+1,t->tm_mday,
		t->tm_hour,t->tm_min,t->tm_sec,hostname);
	   }
	_msg.setMessageId(message_id);

	char	the_date[100];
	memset(the_date,'\0',100);
	strftime(the_date,100,"%a %d %b %X %Y (%Z)",t);
	_msg.setDate(the_date);

	// These may include aliases as set here - remove externally
	_msg.setToAddressee(_toField->value());
	_msg.setCcAddressee(_ccField->value());
	_msg.setBccAddressee(_bccField->value());

	// Set up body

	_msg.setBodyText(enteredMessageText());

	// Set up attachments

	_msg.removeAttachments();
	for (int i=0;i<_attachmentIcons.size();i++)
	  _msg.addAttachment(_attachmentIcons[i].att);

	return _msg;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Take entered message text, and change to be 80 chars/line max.
//	This allows for the wordWrap effect of the XmText widget.
//
////////////////////////////////////////////////////////////////////////////////
string	mxMailMsgDisplay::enteredMessageText() const
{
	string		text;
	bool		end_reached=FALSE;
	int		current_pos=0;
	char		*raw_text=XmTextGetString(_messageField);

	text = raw_text;
	XtFree(raw_text);

//	Split text string into 80 chars limited string

	while (!end_reached)
	  {
	   if (current_pos+80 <= text.size())
	     {
	      int	pos_space;
	      int	pos_newline;
	      int	pos_tab;

	      pos_space   = text.rfind(" ",current_pos+80);
	      pos_newline = text.rfind("\n",current_pos+80);
	      pos_tab     = text.rfind("\t",current_pos+80);

	      // No 'space' in next 80 chars - break at 80 char point
	      if (pos_space < current_pos &&
		  pos_newline < current_pos &&
		  pos_tab < current_pos)
		{
		 text.insert(current_pos+80,"\n");
		 current_pos += 81;
		}
	      // 'newline' found in next 80 chars, so just move to there
	      else if (pos_newline >= current_pos)
		current_pos = pos_newline+1;
	      // 'space' found in next 80 chars, so split at last one
	      else
		{
		 if (pos_space >= current_pos && pos_space > pos_tab)
		   {
		    text[pos_space] = '\n';
		    current_pos = pos_space+1;
		   }
		 else if (pos_tab >= current_pos && pos_tab > pos_space)
		   {
		    text[pos_tab] = '\n';
		    current_pos = pos_tab+1;
		   }
		}
	     }
	   else
	     end_reached = true;
	  }

	return text;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Highlight and show the specified body text
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailMsgDisplay::highlightAndShowBodyText(int start_pos,int end_pos)
{
//	Remove highlight from any body text, and apply new highlight

	removeBodyTextHighlights();
	XmTextSetHighlight(_messageField,start_pos,end_pos,
			XmHIGHLIGHT_SELECTED);
	XmTextSetTopCharacter(_messageField,start_pos);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Remove all highlights from the body text
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailMsgDisplay::removeBodyTextHighlights()
{
	XmTextSetHighlight(_messageField,0,XmTextGetLastPosition(_messageField),
			XmHIGHLIGHT_NORMAL);
}
