////////////////////////////////////////////////////////////////////////////////
//
//	Class :	mxMailBoxSelector
//
//	Author : Andy Jefferson
//
//	Description :
//		mxMailBoxSelector provides a selection box prompting for a
//		mailbox/folder - using the files in the folder directory
//
//	Methods :
//
//	Limitations :
//		Uses mxSetup GLOBAL object folderDirectory for the directory
//		to select from.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxMailBoxSelector_h
#define mxMailBoxSelector_h
#ifdef __cplusplus

#include "akComponent.h"

typedef	void (*mxMailBoxSelectorCB) (XtPointer,string);

class mxMailBoxSelector : public akComponent
{
	public:

		// Constructor

		mxMailBoxSelector(Widget parent,
				  char *name,
				  bool match,
				  mxMailBoxSelectorCB callback,
				  XtPointer clientData);

		// Update facility

		void		update();
		void		manage();

	private:

		// Button callbacks

		static void	okCB(Widget,XtPointer,XtPointer);
		static void	cancelCB(Widget,XtPointer,XtPointer);

		// Users Callback

		mxMailBoxSelectorCB	_userCB;
		XtPointer		_userData;
};

#endif
#endif
