#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <dirent.h>
#include <iostream.h>
#include <Xm/SelectioB.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>

#include "akApp.h"
#include "mxMailBoxSelector.h"
#include "mxSetup.h"
#include "mxMailBoxTypes.xpm"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailBoxSelector::mxMailBoxSelector(Widget parent,
				     char *name,
				     bool match,
				     mxMailBoxSelectorCB callback,
				     XtPointer clientData)
	:akComponent(name),
	 _userCB(callback),
	 _userData(clientData)
{
	Arg		args[10];
	XmString	title;
	XmString	label;

	title = XmStringCreateLtoR("Mailbox Selection",XmSTRING_DEFAULT_CHARSET);
	label = XmStringCreateLtoR("Folders",XmSTRING_DEFAULT_CHARSET);
	XtSetArg(args[0],XmNmustMatch,match);
	XtSetArg(args[1],XmNdialogTitle,title);
	XtSetArg(args[2],XmNlistLabelString,label);
	XtSetArg(args[3],XmNautoUnmanage,FALSE);
	_w = XmCreateSelectionDialog(parent,name,args,4);
	XmStringFree(title);
	XmStringFree(label);
	installDestroyHandler();
	XtUnmanageChild(XmSelectionBoxGetChild(_w,XmDIALOG_HELP_BUTTON));
	XtUnmanageChild(XmSelectionBoxGetChild(_w,XmDIALOG_APPLY_BUTTON));

	XtAddCallback(_w,XmNokCallback,
		      &mxMailBoxSelector::okCB,(XtPointer)this);
	XtAddCallback(_w,XmNcancelCallback,
		      &mxMailBoxSelector::cancelCB,(XtPointer)this);

	update();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Manage function - manage the component after updating the list
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxSelector::manage()
{
//	Update the list in case other folders created

	update();

//	Manage it

	akComponent::manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update function - empty the list and add the valid files
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxSelector::update()
{
	XmString	*items;
	int		nitems=0;
	int		i=0;
	DIR		*dfd;
	struct dirent	*dp;
	struct stat	stbuf;
	string		dir=theMxSetup->mailFolderDirectory();
	string		filename;

	if ((dfd = opendir((char *)dir.c_str())) == NULL)
	  return;

//	Count number of valid folder names

	while (dp = readdir(dfd))
	  {
	   if (strcmp(dp->d_name,".") != 0 &&
	       strcmp(dp->d_name,"..") != 0)
	     {
	      filename = dir + dp->d_name;
	      if (stat((char *)filename.c_str(),&stbuf) != -1)
	        if ((stbuf.st_mode & S_IFMT) != S_IFDIR)
	          nitems++;
	     }
	  }
	seekdir(dfd,0);

//	Add folders to list

	items = new XmString[nitems];
	while (dp = readdir(dfd))
	  {
	   if (strcmp(dp->d_name,".") != 0 &&
	       strcmp(dp->d_name,"..") != 0)
	     {
	      filename = dir + dp->d_name;
	      if (stat((char *)filename.c_str(),&stbuf) != -1)
	        if ((stbuf.st_mode & S_IFMT) != S_IFDIR)
		  {
		   items[i] = XmStringCreateLocalized(dp->d_name);
		   i++;
		  }
	     }
	  }

	XtVaSetValues(_w,
		      XmNlistItems,items,
		      XmNlistItemCount,nitems,
		      0);
	closedir(dfd);

	for (i=0;i<nitems;i++)
	  XmStringFree(items[i]);
	delete []items;
}
////////////////////////////////////////////////////////////////////////////////
//
//	OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxSelector::okCB(Widget,XtPointer clientData,XtPointer callData)
{
	mxMailBoxSelector	*obj = (mxMailBoxSelector *)clientData;
	XmSelectionBoxCallbackStruct	*cbs =
		(XmSelectionBoxCallbackStruct *)callData;
	char		*tempstr;
	string		selection;

	XmStringGetLtoR(cbs->value,XmFONTLIST_DEFAULT_TAG,&tempstr);
	if (tempstr)
	  {
	   selection = tempstr;
	   selection.insert(0,theMxSetup->mailFolderDirectory());
	   XtFree(tempstr);
	  }

	if (obj->_userCB)
	  obj->_userCB(obj->_userData,selection);

	obj->unmanage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Cancel callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailBoxSelector::cancelCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailBoxSelector	*obj = (mxMailBoxSelector *)clientData;

	obj->unmanage();
}
