#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <time.h>
#include <Xm/ScrolledW.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <X11/Xmu/Editres.h>

#include "akFileDialogMgr.h"
#include "mxFileViewer.h"
#include "mxSetup.h"
#include "mxFileViewerIcon.xpm"
#include "mxButtons.xpm"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxFileViewer::mxFileViewer(char *name,
			   string filename,
			   string filetext,
			   XtCallbackProc callback,
			   XtPointer clientData)
	:akWindow(name),
	 _filename(filename),
	 _filetext(filetext),
	 _textArea((Widget)0),
	 _closeButton((akButton *)0),
	 _fileButton((akButton *)0),
	 _printButton((akButton *)0),
	 _userCB(callback),
	 _userData(clientData)
{
//	Create the panel

	initialize();

	installWMClose();

	setIcon("mxFileViewer",mxFileViewerIcon_xpm);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxFileViewer::~mxFileViewer()
{
	if (_closeButton)
	  delete _closeButton;
	if (_fileButton)
	  delete _fileButton;
	if (_printButton)
	  delete _printButton;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Manage function
//
////////////////////////////////////////////////////////////////////////////////
void	mxFileViewer::manage()
{
	akWindow::manage();

	update();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update function	- (re)reads the file and updates the display
//
////////////////////////////////////////////////////////////////////////////////
void	mxFileViewer::update()
{
	string	title;

//	Set display title

	title = "File : '";
	title += _filename + "'";
	setTitle(title);

//	If text of file passed in then just display it

	if (_filetext.size() > 0)
	  XmTextSetString(_textArea,(char *)_filetext.c_str());

//	Else read file and display contents

	else
	  {
	   char		line[BUFSIZ];
	   ifstream	infile((char *)_filetext.c_str());

	   XmTextSetString(_textArea,"");
	   if (infile)
	     {
	      while(infile.getline(line,BUFSIZ,'\n') != NULL)
		{
		 XmTextInsert(_textArea,
			      XmTextGetLastPosition(_textArea),
			      line);
		 XmTextInsert(_textArea,
			      XmTextGetLastPosition(_textArea),
			      "\n");
		}
	     }
	   infile.close();
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Panel creation function
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxFileViewer::createWorkArea(Widget parent)
{
	Arg		args[10];
	Widget		form,messagebox;

//	Add editres support

	XtAddEventHandler(parent,(EventMask)0,TRUE,
			  (XtEventHandler)_XEditResCheckMessages,0);

//	Add a form to attach everything to

	form =
		XtVaCreateManagedWidget("ViewForm",
					xmFormWidgetClass,
					parent,
					NULL);
	
//	Add messagebox to hold buttons

	messagebox =
		XtVaCreateWidget("ButtonBar",
				xmMessageBoxWidgetClass,
				form,
			 	XmNleftAttachment,XmATTACH_FORM,
			 	XmNrightAttachment,XmATTACH_FORM,
			 	XmNbottomAttachment,XmATTACH_FORM,
			 	XmNtopAttachment,XmATTACH_FORM,
				NULL);

//	Set up option buttons

	_closeButton =
	  new akButton(messagebox,"Close",mxClose_xpm,
		       &mxFileViewer::closeCB,(XtPointer)this);
	_closeButton->installHelp("Close the viewer panel");
	_closeButton->manage();
	_fileButton =
	  new akButton(messagebox,"File",mxFile_xpm,
		       &mxFileViewer::fileCB,(XtPointer)this);
	_fileButton->installHelp("Save the file\nto disk");
	_fileButton->manage();
	_printButton =
	  new akButton(messagebox,"Print",mxPrint_xpm,
		       &mxFileViewer::printCB,(XtPointer)this);
	_printButton->installHelp("Print the file");
	_printButton->manage();
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_OK_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_HELP_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_MESSAGE_LABEL));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_SYMBOL_LABEL));
	XtManageChild(messagebox);
	XtVaSetValues(messagebox,XmNdefaultButton,_closeButton->baseWidget(),0);

//	Add text area to display file in

	XtSetArg(args[0],XmNeditable,FALSE);
	XtSetArg(args[1],XmNeditMode,XmMULTI_LINE_EDIT);
	XtSetArg(args[2],XmNblinkRate,0);
	XtSetArg(args[3],XmNscrollBarDisplayPolicy,XmAS_NEEDED);

	_textArea =
	  XmCreateScrolledText(messagebox,"TextArea",args,4);
	XtManageChild(_textArea);

	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Close Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxFileViewer::closeCB(Widget,XtPointer clientData,XtPointer)
{
	mxFileViewer	*obj = (mxFileViewer *)clientData;

	obj->busy();
	obj->unmanage();
	obj->ready();

	if (obj->_userCB)
	  obj->_userCB(obj->_w,obj->_userData,(XtPointer)obj);
}
////////////////////////////////////////////////////////////////////////////////
//
//	File Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxFileViewer::fileCB(Widget,XtPointer clientData,XtPointer)
{
	mxFileViewer	*obj = (mxFileViewer *)clientData;

	obj->busy();
	theAkFileDialogMgr->post("Save To File",
				 "*",
				 (XtPointer)obj,
				 mxFileViewer::fileOK,
				 mxFileViewer::fileCANCEL);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	File OK - save the contents to the specified filename
//
////////////////////////////////////////////////////////////////////////////////
void 	mxFileViewer::fileOK(XtPointer clientData,XtPointer callData)
{
	mxFileViewer	*obj = (mxFileViewer *)clientData;
	XmFileSelectionBoxCallbackStruct	*cbs =
		(XmFileSelectionBoxCallbackStruct *)callData;
	char	*selection;
	string	selected_file;
	char	*file_contents;

	obj->busy();
	XmStringGetLtoR(cbs->value,XmFONTLIST_DEFAULT_TAG,&selection);
	selected_file = selection;
	free(selection);
	file_contents = XmTextGetString(obj->_textArea);

//	Write contents to file

	ofstream	outfile((char *)selected_file.c_str());
	if (outfile)
	  outfile << file_contents;
	outfile.close();
	XtFree(file_contents);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	File CANCEL
//
////////////////////////////////////////////////////////////////////////////////
void 	mxFileViewer::fileCANCEL(XtPointer clientData,XtPointer callData)
{
//	Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	Print Callback
//
////////////////////////////////////////////////////////////////////////////////
void 	mxFileViewer::printCB(Widget,XtPointer clientData,XtPointer)
{
	mxFileViewer	*obj = (mxFileViewer *)clientData;
	char		tempfile[100];
	string		printfile;
	char		*file_contents;

	obj->busy();

//	Put file contents into a temporary file

	time_t	the_time;
	tm	*t;
	time(&the_time);
	t = localtime(&the_time);
	strftime(tempfile,100,"mxPrint_%d%m%y.%H%M%S",t);

	printfile = theMxSetup->tempDirectory() + tempfile;
	file_contents = XmTextGetString(obj->_textArea);
	ofstream	outfile((char *)printfile.c_str());
	if (outfile)
	  outfile << file_contents;
	outfile.close();
	XtFree(file_contents);

//	Print with the system command

	string	system_command;
	system_command = "cat " + printfile + " | lpr -r";
	system((char *)system_command.c_str());

	obj->ready();
}
