#include <Xm/Xm.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <iostream.h>

#include "akRadioBox.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akRadioBox object.
//
////////////////////////////////////////////////////////////////////////////////
akRadioBox::akRadioBox(Widget parent,
			char *name,
			char *prompt,
			char **options,
			int num_options,
			int num_columns,
			XtCallbackProc callback,
			XtPointer clientData)
	: akComponent(name),
	  _userCB(callback),
	  _userData(clientData)
{
	XmString	*option_labels;
	Arg		args[10];
	int		ncols;
	int		i;

	_numOptions = num_options;

//	Allocate option labels

	option_labels = new XmString[_numOptions];
	for (i=0;i<_numOptions;i++)
	  option_labels[i] = XmStringCreateLocalized(options[i]);

//	Add frame and optional prompt as frame label

	XtSetArg(args[0],XmNshadowType,XmSHADOW_ETCHED_OUT);
	_w = XmCreateFrame(parent,_name,args,1);

	if (prompt != (char *)0)
	  XtVaCreateManagedWidget(prompt,
				  xmLabelWidgetClass,
				  _w,
				  XmNchildType,XmFRAME_TITLE_CHILD,
				  NULL);

//	Create check box widget

	ncols = num_columns;
	if (num_columns < 1 || num_columns > _numOptions)
	  ncols = 1;

	XtSetArg(args[0],XmNbuttons,option_labels);
	XtSetArg(args[1],XmNbuttonCount,_numOptions);
	XtSetArg(args[2],XmNnumColumns,ncols);
	XtSetArg(args[3],XmNorientation,XmVERTICAL);
	XtSetArg(args[4],XmNpacking,XmPACK_COLUMN);
	XtSetArg(args[5],XmNadjustLast,FALSE);
	_radioBox = XmCreateSimpleRadioBox(_w,_name,args,6);
	XtManageChild(_radioBox);

	installDestroyHandler();

//	If user wants dynamic hook, call change CB whenever anything changes.

	if (_userCB != (XtCallbackProc)0)
	  for (i=0;i<_numOptions;i++)
	    {
	     XtAddCallback(optionWidget(i),
			   XmNvalueChangedCallback,
			   akRadioBox::changeCB,
			   (XtPointer)this);
	    }

//	Set the first option to be ON

	XmToggleButtonSetState(optionWidget(0),TRUE,TRUE);

//	Free off option labels

	for (i=0;i<_numOptions;i++)
	  XmStringFree(option_labels[i]);
	delete option_labels;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Option changed Callback
//
////////////////////////////////////////////////////////////////////////////////
void	akRadioBox::changeCB(Widget w,XtPointer clientData,XtPointer callData)
{
	XmToggleButtonCallbackStruct *cbs =
		(XmToggleButtonCallbackStruct *)callData;
	akRadioBox	*obj = (akRadioBox *)clientData;
	char		*button_name;
	char		*option;
	int		selected_option;

//	Ignore if option turned OFF

	if (cbs->set == 0) return;

//	Check which button was changed

	button_name = XtName(w);
	option = &(button_name[7]);
	selected_option = atoi(option);

//	Call user's own routine with their clientData

	obj->_userCB(obj->_radioBox,obj->_userData,(XtPointer)selected_option);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Option widget access function
//
////////////////////////////////////////////////////////////////////////////////
Widget	akRadioBox::optionWidget(int option_no)
{
	Widget	*children;
	char	button_name[20];
	int	num_children;
	int	i;

	if (option_no < 0 || option_no > _numOptions-1)
	  return (Widget)0;
	else
	  {
	   XtVaGetValues(_radioBox,
			 XmNchildren,&children,
			 XmNnumChildren,&num_children,
			 NULL);
	   sprintf(button_name,"button_%d",option_no);
	   for (i=0;i<num_children;i++)
	     if (strcmp(XtName(children[i]),button_name) == 0)
	       return children[i];

	   return (Widget)0;
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Option setting access function
//
////////////////////////////////////////////////////////////////////////////////
void	akRadioBox::set(int option_no)
{
	if (option_no < 0 || option_no > _numOptions-1)
	  return;
	else
	  if (optionWidget(option_no) != (Widget)0)
	    XmToggleButtonSetState(optionWidget(option_no),TRUE,TRUE);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Which option is selected ?
//
////////////////////////////////////////////////////////////////////////////////
int	akRadioBox::selected()
{
	bool	value;
	int	i;

	for (i=0;i<_numOptions;i++)
	  {
	   XtVaGetValues(optionWidget(i),XmNset,&value,NULL);
	   if (value)
	     return i;
	  }
}
