////////////////////////////////////////////////////////////////////////////////
//
//	Class : akPromptInts
//
//	Author : Andy Jefferson
//
//	Description :
//		The akPromptInts class provides a data entry prompt
//		for integer values. It creates a widget consisting of an optional
//		variable name label, together with the actual data entry field.
//		The user can retrieve the values from the class via
//		the function "value", or use a callback hook to receive
//		updates when changes are made.
//		The user is responsible for deleting the array of int's returned
//		by 'value' and the user callback.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			prompt		label prompt
//			callback	Callback called when enter pressed
//			clientData	Data passed to callback
//		value()			Returns the int values in the field
//		setValue()		Sets the values in the text field
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akPromptInts_h
#define _akPromptInts_h
#ifdef __cplusplus

#include <std/string.h>
#include <Xm/Xm.h>
#include "akPrompt.h"

typedef void (*akPromptIntsCB) (XtPointer clientData,int *values,int num);

class akPromptInts : public akPrompt
{
	public:

		// Constructor

		akPromptInts(Widget parent,
			      char *name,
			      string variable_name,
			      akPromptIntsCB callback=0,
			      XtPointer clientData=0);

		// Class name

		virtual const char *const className(void)
			{return ("akPromptInts");}

		// Access functions

		virtual int	*value(int *num);
		virtual void	setValue(int *new_values,int num);
		virtual void	setValue(int new_value);

	protected:

		akPromptIntsCB	userCB;
		XtPointer	userClientData;

		virtual void	changeCB(string field_string);

	private:

		int		*parseValues(const char *string,int *num_values);
};

#endif
#endif
