////////////////////////////////////////////////////////////////////////////////
//
//	Class : akPromptIntRange
//
//	Author : Andy Jefferson
//
//	Description :
//		The akPromptIntRange class provides a data
//		entry prompt for an integer value within a
//		range. It creates a widget consisting of an
//		optional variable name label, together with the
//		actual data entry field.
//		Additionally, the entry field has up/down arrow
//		buttons alongside, to provide incremental
//		increase/decrease of the integer.
//		The user can retrieve the value from the class
//		via the function "value", or use a callback
//		hook to receive updates when changes are made.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			prompt		Prompt label
//			callback	Callback called when enter pressed
//			clientData	Data passed to callback
//			lower_limit	Lower limit of range
//			upper_limit	Upper limit of range
//		setValue()		Set value in text field
//		setRange()		Sets the lower and upper limits
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akPromptIntRange_h
#define _akPromptIntRange_h
#ifdef __cplusplus

#include <std/string.h>
#include <Xm/Xm.h>
#include "akPromptInt.h"

class akPromptIntRange : public akPromptInt
{
	public:

		// Constructor

		akPromptIntRange(Widget parent,
				  char *name,
				  string variable_name,
				  akPromptIntCB callback=0,
				  XtPointer clientData=0,
				  int lower=-999999,
				  int upper=999999);

		// Class name

		virtual const char *const className(void)
			{return ("akPromptIntRange");}

		// Access functions

		virtual void	setValue(int new_value);
		virtual void	setRange(int lower,int upper);

	protected:

		virtual void	changeCB(string field_string);

	private:

		int		lower_range;
		int		upper_range;

		virtual void	increaseValue(void);
		virtual void	decreaseValue(void);
};

#endif
#endif
