#include <Xm/Xm.h>
#include <Xm/ArrowB.h>
#include <Xm/TextF.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <iostream.h>

#include "akPromptIntRange.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akPromptIntRange object.
//
////////////////////////////////////////////////////////////////////////////////
akPromptIntRange::akPromptIntRange(Widget parent,
				     char *name,
				     string variable_name,
				     akPromptIntCB callback,
				     XtPointer clientData,
				     int lower,
				     int upper)
	: akPromptInt(parent,name,variable_name,callback,clientData)
{
	lower_range = lower;
	upper_range = upper;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Range update function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptIntRange::setRange(int lower,int upper)
{
	int	int_value;

	lower_range = lower;
	upper_range = upper;

//	Reset value if now outside range

	int_value = value();
	if (int_value > upper_range)
	  setValue(upper_range);
	if (int_value < lower_range)
	  setValue(lower_range);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Increase value function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptIntRange::increaseValue(void)
{
	int	int_value;

	int_value = value();
	if (int_value+1 <= upper_range)
	  {
	   int_value++;
	   setValue(int_value);
	  }

//	Invoke users change callback

	if (userCB != (akPromptIntCB)0)
	  (*userCB)(userClientData,int_value);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Decrease value function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptIntRange::decreaseValue(void)
{
	int	int_value;

	int_value = value();
	if (int_value-1 >= lower_range)
	  {
	   int_value--;
	   setValue(int_value);
	  }

//	Invoke users change callback

	if (userCB != (akPromptIntCB)0)
	  (*userCB)(userClientData,int_value);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value-changed callback (called when value is changed)
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptIntRange::changeCB(string value)
{
	int	int_value;

	int_value = atoi(value.c_str());
	if (int_value > upper_range)
	  {
	   setValue(upper_range);
	   int_value = upper_range;
	  }
	if (int_value < lower_range)
	  {
	   setValue(lower_range);
	   int_value = lower_range;
	  }

	if (userCB != (akPromptIntCB)0)
	  (*userCB)(userClientData,int_value);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Value utility function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptIntRange::setValue(int new_value)
{
	char	new_string[100];

//	LIMITATION NOTE - new_string is size 100.

	if (new_value <= upper_range && new_value >= lower_range)
	  {
	   sprintf(new_string,"%d",new_value);
	   XmTextFieldSetString(_field,new_string);
	  }
}
