////////////////////////////////////////////////////////////////////////////////
//
//	Class : akDialogCallbackData
//
//	Author : Andy Jefferson
//
//	Description :
//		This contains the definition of the callback data used by the
//		dialog management facilities in akClass.
//
////////////////////////////////////////////////////////////////////////////////
// This example code is from the book:
//
// Object-Oriented Programming with C++ and OSF/Motif
//   by
// Douglas Young
// Prentice Hall, 1992
// ISBN 0-13-630252-1	
//
// Copyright 1991 by Prentice Hall
// All Rights Reserved
//
// Permission to use, copy, modify, and distribute this software for 
// any purpose except publication and without fee is hereby granted, provided 
// that the above copyright notice appear in all copies of the software.
////////////////////////////////////////////////////////////////////////////////
#ifndef _akDialogCallbackData
#define _akDialogCallbackData
#ifdef __cplusplus

typedef enum
{
	ERROR,
	WARNING,
	INFORMATION,
	MESSAGE,
	WORKING,
	QUESTION
} akMessageDialogType;

typedef void (*akDialogCallback)(void *client_data,void *call_data);

class akDialogCallbackData
{
	public:

		akDialogCallbackData(void *clientData,
				      akDialogCallback ok,
			 	      akDialogCallback cancel,
			 	      akDialogCallback help)
		  {
		   _ok         = ok;
		   _help       = help;
		   _cancel     = cancel;
		   _clientData = clientData;
		  }
		akDialogCallback  ok() {return (_ok);}
		akDialogCallback  help() {return (_help);}
		akDialogCallback  cancel() {return (_cancel);}
		void           	*clientData() {return (_clientData);}

	private:

		akDialogCallback  _ok;
		akDialogCallback  _help;
		akDialogCallback  _cancel;
		void		*_clientData;
};
#endif
#endif
