////////////////////////////////////////////////////////////////////////////////
//
//	Class : akClock
//
//	Author : Andy Jefferson
//
//	Description :
//		The akClock class provides a Motif label widget in
//		which the time and date are displayed. The label's
//		contents are updated every 30 secs. The date contains
//		the Day, Month, Day of the Month, and year. The time
//		contains the hour (in 24 hour format) and minute.
//
//	Public Methods :
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akClock_h
#define _akClock_h
#ifdef __cplusplus

#include <Xm/Xm.h>
#include "akComponent.h"

typedef enum
{
	DATE,
	TIME,
	DATE_AND_TIME
} akClockType;

class akClock : public akComponent
{
	public:

		// Constructor/Destructor

		akClock(Widget parent,char *name,akClockType type=DATE_AND_TIME);
		~akClock(void);

		// Class name

		virtual const char *const className(void)
			{return ("akClock");}

	private:

		akClockType	_type;
		XtIntervalId	_updateId;

		static void	updateTime(XtPointer clientData,
					   XtIntervalId id);
};

#endif
#endif
