/*
 rnd.c

 FR -- File Rotator -- `stateless' time-based randomiser

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: rnd.c,v 0.2 2000/04/13 23:50:36 root Exp root $

 $Log: rnd.c,v $
 Revision 0.2  2000/04/13 23:50:36  root
 Added unlimited dirs on command line

 Revision 0.1  2000/04/10 16:37:03  root
 Additional fallback features

 Revision 0.0  2000/04/07 14:54:19  root
 Initial check-in

*/

#ifndef _RND_
#define _RND_

#include <fr.h>

int fr_rnd_id( long * id )
{
	int r = FALSE;

FR_PARAM_CHECK( id != NULL && (* id) > FR_EMPTY )

	struct timeval tv;

	if ( gettimeofday( &tv, NULL ) != FR_ERROR ) {
		(* id) = tv.tv_usec % (* id);
		r = TRUE;
	}

FR_R_PERROR( r )
FR_PARAM_ERROR

	return r;
}/* fr_rnd_id */

#endif /*_RND_*/

/* End of rnd.c */
