/*
 mem.c

 FR -- File Rotator -- memory operations

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: mem.c,v 0.2 2000/04/13 23:50:36 root Exp root $

 $Log: mem.c,v $
 Revision 0.2  2000/04/13 23:50:36  root
 Added unlimited dirs on command line

 Revision 0.1  2000/04/10 16:37:03  root
 Additional fallback features

 Revision 0.0  2000/04/07 14:54:19  root
 Initial check-in

*/

#ifndef _MEM_
#define _MEM_

#include <fr.h>

int fr_mem_new( void * * mem, const size_t size )
{
	int r = FALSE;

FR_PARAM_CHECK( mem != NULL && (* mem) == NULL )

	r = ((* mem) = calloc( size, sizeof( char ))) != NULL;

FR_R_PERROR( r )
FR_PARAM_ERROR

	return r;

}/* fr_mem_new */

int fr_mem_resize( void * * mem, const size_t new_size )
{
	int r = FALSE;

FR_PARAM_CHECK( mem != NULL && new_size >= FR_EMPTY )

	void * m = NULL;

	if (( m = realloc((* mem), new_size )) != NULL ) {
		(* mem) = m;
		r = TRUE;
	}

FR_R_PERROR( r )
FR_PARAM_ERROR

	return r;

}/* fr_mem_resize */

int fr_mem_free( void * * mem )
{
	int r = FALSE;

FR_PARAM_CHECK( mem != NULL && (* mem) != NULL )

	free((* mem));
	(* mem) = NULL;
	r = TRUE;

FR_PARAM_ERROR

	return r;

}/* fr_mem_free */

#endif /*_MEM_*/

/* End of mem.c */
