/*
 ipc.c

 FR -- File Rotator -- IPC wrappers

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: ipc.c,v 0.2 2000/04/13 23:50:36 root Exp root $

 $Log: ipc.c,v $
 Revision 0.2  2000/04/13 23:50:36  root
 Added unlimited dirs on command line

 Revision 0.1  2000/04/10 16:37:03  root
 Additional fallback features

 Revision 0.0  2000/04/07 14:54:19  root
 Initial check-in

*/

#ifndef _IPC_
#define _IPC_

#include <fr.h>

#define FR_IPC_SHM_ATTACH S_IRUSR | S_IRGRP

int fr_ipc_ftok( key_t * key, char * path )
{
	int r = FALSE;

FR_PARAM_CHECK( key != NULL && (* key) == FR_ERROR && len_c(path) > FR_EMPTY )

	r = ((* key) = ftok( path, FR_FTOK_SYM )) != FR_ERROR;

FR_R_PERROR( r )
FR_PARAM_ERROR

	return r;

}/* fr_ipc_ftok */

int fr_ipc_shm_attach( char * * addr, const key_t key, const int size )
{
	int r = FALSE;

FR_PARAM_CHECK( addr != NULL && (* addr) == NULL && key != FR_ERROR &&
			size > FR_EMPTY )

	int m = FR_ERROR;

	if (( m = shmget( key, size, FR_IPC_SHM_ATTACH )) != FR_ERROR ) {
		(* addr) = shmat( m, NULL, SHM_RDONLY );
		r = (* addr) != NULL;
	}

FR_R_PERROR( r )
FR_PARAM_ERROR

	return r;

}/* fr_ipc_shm_attach */

int fr_ipc_shm_detach( char * * addr )
{
	int r = FALSE;

FR_PARAM_CHECK( addr != NULL && (* addr) != NULL )

	r = shmdt((* addr)) != FR_ERROR;
	if ( r )
		(* addr) = NULL;
	else
		fr_perror;

FR_PARAM_ERROR

	return r;

}/* fr_ipc_shm_detach */

#endif /*_IPC_*/

/* End of ipc.c */
