/*
 fr.h

 FR -- File Rotator -- global header

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: fr.h,v 0.2 2000/04/13 23:50:36 root Exp root $

 $Log: fr.h,v $
 Revision 0.2  2000/04/13 23:50:36  root
 Added unlimited dirs on command line

 Revision 0.1  2000/04/10 16:37:03  root
 Additional fallback features

 Revision 0.0  2000/04/07 14:54:19  root
 Initial check-in

*/

#ifndef _FR_H_
#define _FR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if STDC_HEADERS
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#endif /*STDC_HEADERS*/
#if HAVE_ERRNO_H
#include <errno.h>
#endif /*HAVE_ERRNO_H*/
#if HAVE_FCNTL_H
#include <fcntl.h>
#endif /*HAVE_FCNTL_H*/
#if HAVE_SIGNAL_H
#include <signal.h>
#endif /*HAVE_STDIO_H*/
#if HAVE_STDIO_H
#include <stdio.h>
#endif /*HAVE_STDIO_H*/
#if HAVE_UNISTD_H
#include <unistd.h>
#endif /*HAVE_UNISTD_H*/
#if HAVE_SYS_IPC_H
#include <sys/ipc.h>
#endif /*HAVE_SYS_IPC_H*/
#if HAVE_SYS_SHM_H
#include <sys/shm.h>
#endif /*HAVE_SYS_SHM_H*/
#if HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif /*HAVE_SYS_STAT_H*/
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#endif /*HAVE_SYS_TIME_H*/
#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif /*HAVE_SYS_TYPES_H*/

#ifndef FALSE
#define FALSE 0
#endif /*FALSE*/

#ifndef TRUE
#define TRUE 1
#endif /*TRUE*/

#define FR_ERROR  -1
#define FR_EMPTY  0
#define FR_BASE   0
#define FR_SLASH  ((char) '/' )
#define FR_NL     ((char) '\n' )
#define FR_DIRSYM ((char) ':' )
#define FR_STDOUT 1

#define FR_FTOK_SYM 'X'

#define len_c( c ) (( c ) == NULL ? FR_EMPTY : strlen(( c )))

#define fr_err( e ) fprintf( stderr, "FR %s(): %s.\n", __FUNCTION__, ( e ))

#if HAVE_PERROR
#define fr_perror perror( __FUNCTION__ )
#else
#define fr_perror fr_err( "system error" )
#endif /*HAVE_PERROR*/

#if FR_ENABLE_PARAMCHECK
#define FR_PARAM_CHECK( r )    if (( r )) {
#define FR_PARAM_ERROR         } else { fr_err( "param check failed" ); }
#else
#define FR_PARAM_CHECK( r )
#define FR_PARAM_ERROR
#endif /*FR_ENABLE_PARAMCHECK*/

#define FR_R_PERROR( r )       if ( ! ( r )) { fr_perror; }

#ifndef _FILE_

extern int fr_file_size( off_t * size, const char * fname );
extern int fr_file_open( int * fd, const char * fname, const int flags );
extern int fr_file_put( const int fd, char * src, const size_t count );
extern int fr_file_pump( const int fd, const int fs, const off_t count );
extern int fr_file_close( int * fd );

#endif /*_FILE_*/

#ifndef _IPC_

extern int fr_ipc_ftok( key_t * key, char * path );
extern int fr_ipc_shm_attach( char * * addr, const key_t key, const int size );
extern int fr_ipc_shm_detach( char * * addr );

#endif /*_IPC_*/

#ifndef _MEM_

extern int fr_mem_new( void * * mem, const size_t size );
extern int fr_mem_resize( void * * mem, const size_t new_size );
extern int fr_mem_free( void * * mem );

#endif /*_MEM_*/

#ifndef _RND_

extern int fr_rnd_id( long * id );

#endif /*_RND_*/

#endif /*_FR_H_*/

/* End of fr.h */
