/*
 fr.c

 FR -- File Rotator -- Main

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: fr.c,v 0.2 2000/04/13 23:50:36 root Exp root $

 $Log: fr.c,v $
 Revision 0.2  2000/04/13 23:50:36  root
 Added unlimited dirs on command line

 Revision 0.1  2000/04/10 16:37:03  root
 Additional fallback features

 Revision 0.0  2000/04/07 14:54:19  root
 Initial check-in

*/

#ifndef _FR_
#define _FR_

#include <fr.h>

#define FR_MAIN_ARGC 2

int fr_from_shmem( char * * dst, off_t * count, char * fname )
{
	int r = FALSE;

FR_PARAM_CHECK( dst != NULL && (* dst) == NULL &&
		count != NULL && (* count) == FR_ERROR &&
		len_c( fname ) > FR_EMPTY )

	key_t  k = FR_ERROR;
	char * d = NULL;
	off_t  o = sizeof( o );

	if ( fr_ipc_ftok( &k, fname )) {
		if ( fr_ipc_shm_attach( &d, k, o )) {
			memcpy((void *) &o, (void *) d, sizeof( o ));
			if (fr_ipc_shm_detach(&d) && fr_ipc_shm_attach(&d,k,o)){
				o -= sizeof( o );
				if ( fr_mem_resize((void * *) dst, o )) {
					memcpy((void *) (* dst),
						(void *) ( d + sizeof(o)), o);
					(* count) = o;
					r = TRUE;
				}
				fr_ipc_shm_detach( &d );
			}
		}
	}

FR_R_PERROR( r )
FR_PARAM_ERROR

	return r;

}/* fr_from_shmem */

int fr_to_stdout( char * fname )
{
	int r = FALSE;

FR_PARAM_CHECK( len_c( fname ) > FR_EMPTY )

	char * b = NULL;
	off_t  o = FR_ERROR;

	if ( fr_from_shmem( &b, &o, fname ))
		r = fr_file_put( FR_STDOUT, b, o );

	if ( ! r ) {

		int f = FR_ERROR;

		o = FR_ERROR;
		if ( fr_file_size( &o, fname )) {
			if ( fr_file_open( &f, fname, O_RDONLY )) {
				r = fr_file_pump( FR_STDOUT, f, o );
				fr_file_close( &f );
			}
		}
	}

FR_R_PERROR( r )
FR_PARAM_ERROR

	return r;

}/* fr_to_stdout */

int main( int argc, char * argv[])
{
	off_t   oft = FR_ERROR;
	char  * buf = NULL;

	if (argc >= FR_MAIN_ARGC && fr_from_shmem( &buf, &oft, FR_CNF_FNAME)) {

		register size_t bp = FR_BASE;
		int    ap = 1;
		size_t sb = FR_EMPTY;

		for ( ; bp < oft; bp++ ) {
			if ( buf[ bp ] == FR_NL )
				buf[ bp ] = (char) FR_EMPTY;
		}

		for ( ; ap < argc; ap++ ) {

			bp = FR_BASE;

			while ( bp < oft ) {
				bp++;
				if ( buf[ bp - 1 ] == FR_DIRSYM &&
					! strcmp( argv[ ap ], buf + bp ))
					break;
			}

			if (( sb = strlen( buf + bp )) > FR_EMPTY ) {

				long id = FR_EMPTY;

				bp += ( sb + 1 );
				id  = atol( buf + bp );
				if ( fr_rnd_id ( &id )) {
					do {
						bp += (strlen( buf + bp ) + 1);
					}
					while ( id-- != FR_EMPTY );
					fr_to_stdout( buf + bp );
				}
			}
		}

		fr_mem_free((void * *) &buf );
	}

	return EXIT_SUCCESS;

}/* main */

#endif /*_FR_*/

/* End of fr.c */
