/*
 file.c

 FR -- File Rotator -- file operations

 Copyright (c) 2000 Edward V. POPKOV
 Distributed under GPL, see COPYING for details

 "Edward V. POPKOV" <evpopkov@carry.netnet.lv>

 $Id: file.c,v 0.2 2000/04/13 23:50:36 root Exp root $

 $Log: file.c,v $
 Revision 0.2  2000/04/13 23:50:36  root
 Added unlimited dirs on command line

 Revision 0.1  2000/04/10 16:37:03  root
 Additional fallback features

 Revision 0.0  2000/04/07 14:54:19  root
 Initial check-in

*/

#ifndef _FILE_
#define _FILE_

#include <fr.h>

#define FR_FILE_BUFSIZE 0x1000

int fr_file_size( off_t * size, const char * fname )
{
	int r = FALSE;

FR_PARAM_CHECK(size != NULL && (* size) == FR_ERROR && len_c(fname) > FR_EMPTY)

	struct stat st;

	if ( stat( fname, &st ) != FR_ERROR ) {
		(* size) = st.st_size;
		r = TRUE;
	}

FR_R_PERROR( r )
FR_PARAM_ERROR

	return r;

}/* fr_file_size */

int fr_file_open( int * fd, const char * fname, const int flags )
{
	int r = FALSE;

FR_PARAM_CHECK( fd != NULL && (* fd) == FR_ERROR && len_c( fname ) > FR_EMPTY )

	r = ((* fd) = open( fname, flags )) != FR_ERROR;

FR_R_PERROR( r )
FR_PARAM_ERROR

	return r;

}/* fr_file_open */

int fr_file_put( const int fd, char * src, const size_t count )
{
	int r = FALSE;

FR_PARAM_CHECK( fd != FR_ERROR && src != NULL && count > FR_EMPTY )

	ssize_t sw = FR_ERROR;
	size_t  ss = FR_EMPTY;

	while ( ss < count &&
		(sw = write(fd, (void *) ( src + ss ), count - ss)) > FR_EMPTY )
		ss += sw;

	r = sw != FR_ERROR;

FR_R_PERROR( r )
FR_PARAM_ERROR

	return r;

}/* fr_file_put */

int fr_file_pump( const int fd, const int fs, const off_t count )
{
	int r = FALSE;

FR_PARAM_CHECK( fd != FR_ERROR && fs != FR_ERROR && count > FR_EMPTY )

	char b[ FR_FILE_BUFSIZE ];
	ssize_t sr = FR_ERROR;
	ssize_t sw = FR_ERROR;

	while (( sr = read( fs, (void *) b, FR_FILE_BUFSIZE )) > FR_EMPTY )
		if (( sw = write( fd, (void *) b, sr )) != sr )
			break;

	r = sr != FR_ERROR && sw != FR_ERROR;

FR_R_PERROR( r )
FR_PARAM_ERROR

	return r;

}/* fr_file_pump */

int fr_file_close( int * fd )
{
	int r = FALSE;

FR_PARAM_CHECK( fd != NULL && (* fd) != FR_ERROR )

	r = close((* fd)) != FR_ERROR;

	if ( r )
		(* fd) = FR_ERROR;
	else
		fr_perror;

FR_PARAM_ERROR

	return r;

}/* fr_file_close */

#endif /*_FILE_*/

/* End of file.c */
