#ifndef FCUT_MANUAL_H
#define FCUT_MANUAL_H
const char * manual_string = 
"


CUT(1)                    Reker Software                   CUT(1)


NNAAMMEE
       cut, fcut - remove sections from each line of files

SSYYNNOOPPSSIISS
       ccuutt -h | --help | -V | --ver | --version

       ccuutt  {-c  <character-list>, --characters=<character-list>}
       [-l  <line-list>,   --lines=<line-list>]   [-i   <text-to-
       insert>,  --insert=<text-to-insert>] [-e <text-to-insert>,
       --substitute=<text-to-insert>] [-n]  [-m,  --only-matched-
       lines] [-o, --order] [-r, --reorder] [file...]

       ccuutt {-b <byte-list>, --bytes=<byte-list>} [-l <line-list>,
       --lines=<line-list>] [-i <text-to-insert>, --insert=<text-
       to-insert>]  [-e  <text-to-insert>, --substitute=<text-to-
       insert>] [-n]  [-m,  --only-matched-lines]  [-o,  --order]
       [-r, --reorder] [file...]

       ccuutt  {-f  <field-list>,  --fields=<field-list>} [-l <line-
       list>, --lines=<line-list>] [-d <delimiter-list>, --delim-
       iter=<delimiter-list>]  [-u  <new-delimiter>, --new-delim-
       iter=<new-delimiter>]        [-i         <text-to-insert>,
       --insert=<text-to-insert>] [-e <text-to-insert>, --substi-
       tute=<text-to-insert>] [-n]  [-s,  --only-delimited]  [-m,
       --only-matched-lines]   [-o,   --order]   [-r,  --reorder]
       [file...]



DDEESSCCRRIIPPTTIIOONN
       This manual page documents the Reker version of ccuutt.   ccuutt
       prints  sections  of  each line of each input file, or the
       standard input if no files are given.  A file name of  `-'
       means  standard  input.   Which  sections  are  printed is
       selected by the options.

       This version does provide more flexibility than the  stan-
       dard UN*X cut.  See the option list for more info.



OOPPTTIIOONNSS
       The  _b_y_t_e_-_l_i_s_t,  _c_h_a_r_a_c_t_e_r_-_l_i_s_t, and _f_i_e_l_d_-_l_i_s_t are one or
       more numbers or ranges (two numbers separated by  a  dash)
       separated by commas.  The first byte, character, and field
       are numbered 1.  Incomplete  ranges  may  be  given:  `-m'
       means  `1-m';  `n-'  means `n' through end of line or last
       field.  You also might specify negative fields,  bytes  or
       characters, with prepending a ~ (tilde), e.g. ~1 specifies
       the last field (character, byte), ~2 the second  last  and
       so on. Negative numbers might also be used in ranges (e.g.
       3-~2 means fields 3 to the  second  last).   Further  more
       ranges might be appended by a / (slash) followed by a num-
       ber.  This number defines a step, e.g. 1-5/2 means range 1



Frank Reker             November 26, 2000                       1





CUT(1)                    Reker Software                   CUT(1)


       to  5, but only every second, i.e. 1,3,5. The step parame-
       ter might also be used together  with  incomplete  ranges,
       e.g.  -/2  means  every second field, byte character, i.e.
       1,3,5...

       The order in which the numbers  in  the  lists  appear  is
       important,  e.g.  a field list of 3,2 prints first field 3
       and then field 2.  Negative ranges are excepted, too. E.g.
       --fields=~1-1  prints all fields in reverse order. Further
       more a field (byte, character) list might contain a number
       more  than once, e.g 2,2,3,2 prints the field (byte, char-
       acter) 2 twice then field 3 and field 2  again.   You  can
       change this behaviour with the options -r and -o (see also
       section DEFAULT BEHAVIOUR).

       _-_b_, _-_-_b_y_t_e_s _b_y_t_e_-_l_i_s_t
              Print only the bytes in positions listed  in  _b_y_t_e_-
              _l_i_s_t.   Tabs  and  backspaces  are treated like any
              other character; they take up 1 byte.

       _-_c_, _-_-_c_h_a_r_a_c_t_e_r_s _c_h_a_r_a_c_t_e_r_-_l_i_s_t
              Print only characters in positions listed in  _c_h_a_r_-
              _a_c_t_e_r_-_l_i_s_t.   The  same as -b for now, but interna-
              tionalization   will   change   that.    Tabs   and
              backspaces  are  treated  like any other character;
              they take up 1 character.

       _-_f_, _-_-_f_i_e_l_d_s _f_i_e_l_d_-_l_i_s_t
              Print only the fields listed in _f_i_e_l_d_-_l_i_s_t.  Fields
              are  separated  by a TAB or a space by default, see
              also DEFAULT BEHAVIOUR.

       _-_d_, _-_-_d_e_l_i_m_i_t_e_r _d_e_l_i_m_i_t_e_r_-_l_i_s_t
              For -f, fields are separated by all  characters  in
              _d_e_l_i_m_i_t_e_r_-_l_i_s_t  _.   You  can  specify more than one
              delimiter.

       _-_l_, _-_-_l_i_n_e_s _l_i_n_e_-_l_i_s_t
              Lines do not appear in the line-list are printed as
              they  are,  if not the option -m is given, in which
              case the line is supressed.   The  line-list  is  a
              comma  separated list of numbers and ranges.  Nega-
              tive numbers are not allowed.  For  now  lines  are
              always  printed  in  the  order they appear and are
              never printed more then once. E.g.  --lines=2,2,3,1
              is  equivalent  to  1,2,3 .  This might change in a
              future version.  The  default  is  to  process  all
              lines.

       _-_m_, _-_-_o_n_l_y_-_m_a_t_c_h_e_d_-_l_i_n_e_s
              Lines  that  are  not  in  a  given  line  list are
              supressed.





Frank Reker             November 26, 2000                       2





CUT(1)                    Reker Software                   CUT(1)


       _-_u_, _-_-_n_e_w_-_d_e_l_i_m_i_t_e_r _d_e_l_i_m_i_t_e_r
              All delimiters are substituted by the given  delim-
              iter.  If the given delimiter consists of more than
              one character, only the first character is used  as
              delimiter.  This might change in the future.

       _-_n     Do  not split multibyte characters (no-op for now).

       _-_s_, _-_-_o_n_l_y_-_d_e_l_i_m_i_t_e_d
              For -f, do not print lines that do not contain  the
              field separator character.

       _-_o_, _-_-_o_r_d_e_r
              This option does sort the fields, character, bytes.
              I.e. a list of 2,2,3,1 is equivalent to 1,2,3 .

       _-_r_, _-_-_r_e_o_r_d_e_r
              This option forces to use the  field-  (character-,
              byte-) list as given.

       _-_i_, _-_-_i_n_s_e_r_t _t_e_x_t_-_t_o_-_i_n_s_e_r_t
              If  this  option is given before / after each field
              (byte, character) given in the apropriated list the
              string  text-to-insert  is  inserted.  In case of a
              given field list the new string is  delimited  with
              the apropriated delimiter.  If the given field is a
              positive number (e.g. -f1)  the  text  is  inserted
              before that field. In case of a given negative num-
              ber (e.g. -f~1) the text  is  inserted  after  that
              field.

       _-_e_, _-_-_s_u_b_s_t_i_t_u_t_e _t_e_x_t_-_t_o_-_i_n_s_e_r_t
              If  this  option is given each field (byte, charac-
              ter) given in the apropriated list  is  substituted
              by  the  string  text-to-insert.   All other fields
              (characters,  bytes)  are  printed  as  they   are.
              Either --substitute or --insert may be specified.

       _-_-     All  parameters after -- are treated as file names.

       _-_h_, _-_-_h_e_l_p
              Print a usage message and exit with a  status  code
              indicating success.

       _-_-_u_s_a_g_e
              Prints a list of all available options and exit.

       _-_-_m_a_n_, _-_-_m_a_n_u_a_l
              Prints this man page to standard out and exit.

       _-_V_, _-_-_v_e_r_, _-_-_v_e_r_s_i_o_n
              Print  version  information on standard output then
              exit.  -V prints the version  number.   --ver  does
              print some more infos.  --version even more.



Frank Reker             November 26, 2000                       3





CUT(1)                    Reker Software                   CUT(1)


       _-_-_c_o_p_y_r_i_g_h_t_, _-_-_c_o_p_y_l_e_f_t
              Does  print the GPL licenes on standard output then
              exits.




EENNVVIIRROONNMMEENNTT
       This program does make use of  the  environment  variables
       PPOOSSIIXXLLYY__CCOORRRREECCTT  and  RREEKKEERR__SSTTYYLLEE  ..   See section DEFAULT
       BEHAVIOUR for more info.



DDEEFFAAUULLTT BBEEHHAAVVIIOOUURR
       This version of cut behaves a little different than  stan-
       dard  UN*X  cut does.  I.e. a given field-list (or charac-
       ter-list, byte-list) is interpreted in  the  order  it  is
       given,  e.g.  --fields=3,2  is different to --fields=2,3 .
       Further more this version uses space and  tab  as  default
       delimiters,  standard  UN*X  cut  only does use tab.  Also
       more than one character of the delimiter  list  is  inter-
       preted.

       If  the  environment  variable POSIXLY_CORRECT is set, but
       not REKER_STYLE, then it behaves like standard  UN*X  cut.
       Since   POSIXLY_CORRECT  is  not  defined  on  most  Linux
       machines, but some (few) scripts might  make  use  of  the
       restrictions  of  standard UN*X cut, this version now does
       behave different depending  by  the  program  name  it  is
       called. I.e. if it is called with the name ``cut'' and the
       variable REKER_STYLE is not set  it  also  behaves  as  if
       POSIXLY_CORRECT is set.



CCOOPPYYRRIIGGHHTT
       This  program  is  free  software; you can redistribute it
       and/or modify it under the terms of the GNU General Public
       License  as  published  by  the  Free Software Foundation;
       either version 2 of the License, or (at your  option)  any
       later version.

       This  program  is  distributed in the hope that it will be
       useful, but WITHOUT ANY WARRANTY; without even the implied
       warranty  of  MERCHANTABILITY  or FITNESS FOR A PARTICULAR
       PURPOSE.  See the GNU  General  Public  License  for  more
       details.

       You  should have received a copy of the GNU General Public
       License along with this program; if not, write to the Free
       Software  Foundation,  Inc.,  59  Temple Place, Suite 330,
       Boston, MA  02111-1307  USA




Frank Reker             November 26, 2000                       4





CUT(1)                    Reker Software                   CUT(1)


BBUUGGSS
       This version does not make use of multibyte characters  or
       locales for now.

       In rare cases the program might run out of memory; then it
       aborts with an error message.

       Giving the  invalid  fieldnumber  0  (zero)  does  produce
       strange effects.

       Bugreport   to   Frank  Reker  <frank@reker.net>.   Please
       describe the problem as detailed as possible.


SSEEEE AALLSSOO
       The README delivered with the sources.









































Frank Reker             November 26, 2000                       5


";

#endif /* FCUT_MANUAL_H */
