
/*

    File: pop3/pop3.h
    Version: 1.0
  
    Copyright (C) 1999  Wolfgang Zekoll  <wzk@quietsche-entchen.de>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
 
#ifndef _POP3_INCLUDED
#define	_POP3_INCLUDED


#define	VERSION		"1.2.0"

#define	POP3_TIMEOUT	600



extern char *program;
extern char progname[80];
extern int debug;


#define	IP_SERVER		1
#define	LOCAL_SERVER		2


typedef struct _config {
    int		type;
    char	server[200];

    int		timeout;
    int		selectserver;
    char	*serverlist;

    char	serverdelim[20];
    char	clientdir[200];

    char	acp[200];
    char	varname[80];
    } config_t;


typedef struct _channel {
    int		type;
    char	name[200];

    int		connected;
    union {
	struct {
	    char	hostname[200];
	    unsigned int port;
	    FILE	*fp;
	    } ip;
	
	struct {
	    char	program[200];
	    FILE	*sin, *sout;
	    } local;
	} u;
    } channel_t;


typedef struct _pop3 {
    config_t	*config;

    char	interface[80];
    unsigned int port;

    int		state;
    struct {
	char	username[200];
	char	password[80];

	char	name[200];
	char	ipnum[100];
	} client;

    struct {
	char	username[80];
	char	password[80];
	} local;

    channel_t	server;
    char	logfile[200];
    } pop3_t;


extern int proxy_request(config_t *config);


#endif

