
/*

    File: pop3/main.c
  
    Copyright (C) 1999  Wolfgang Zekoll  <wzk@quietsche-entchen.de>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
 

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <sys/socket.h>
#include <signal.h>
#include <netdb.h>
#include <netinet/in.h>
#include <syslog.h>
#include <sys/time.h>

#include "pop3.h"
#include "ip-lib.h"
#include "lib.h"


char	*program =		"";
char	progname[80] =		"";

int	debug =			0;
int	verbose =		1;



void missing_arg(int c, char *string)
{
	if (isatty(2))
		fprintf (stderr, "%s: missing arg: -%c, %s\n", program, c, string);

	exit (-1);
}

int main(int argc, char *argv[])
{
	int	c, i, k;
	char	*p, option[80];
	config_t config;
	

	if ((p = strrchr(argv[0], '/')) == NULL)
		program = argv[0];
	else {
		copy_string(progname, &p[1], sizeof(progname));
		program = progname;
		}

	memset(&config, 0, sizeof(config_t));
	config.timeout = POP3_TIMEOUT;
	config.type    = IP_SERVER;
	strcpy(config.serverdelim, "@");
	strcpy(config.varname, "PROXY_");
	openlog(program, LOG_PID, LOG_MAIL);

	k = 1;
	while (k < argc  &&  argv[k][0] == '-'  &&  argv[k][1] != 0) {
		copy_string(option, argv[k++], sizeof(option));
		for (i=1; (c = option[i]) != 0; i++) {
			if (c == 'd')
				debug = 1;
			else if (c == 'a') {
				if (k >= argc)
					missing_arg(c, "access control program");

				copy_string(config.acp, argv[k++], sizeof(config.acp));
				}
			else if (c == 'c') {
				if (k >= argc)
					missing_arg(c, "server delimeter");

				copy_string(config.serverdelim, argv[k++], sizeof(config.serverdelim));
				}
			else if (c == 'e')
				config.selectserver = 1;
			else if (c == 'l') {
				if (k >= argc)
					missing_arg(c, "client log directory");

				copy_string(config.clientdir, argv[k++], sizeof(config.clientdir));
				}
			else if (c == 'm')
				verbose = 0;
			else if (c == 's') {
				if (k >= argc)
					missing_arg(c, "server list");

				config.serverlist = allocate(strlen(argv[k]) + 1);
				strcpy(config.serverlist, argv[k++]);
				}
			else if (c == 't') {
				if (k >= argc)
					missing_arg(c, "timeout");

				config.timeout = atoi(argv[k++]);
				if (config.timeout < 1)
					config.timeout = 60;
				}
			else if (c == 'v') {
				if (k >= argc)
					missing_arg(c, "varname prefix");

				copy_string(config.varname, argv[k++], sizeof(config.varname));
				}
			else {
				if (isatty(2))
					fprintf (stderr, "%s: unknown option: -%c\n", program, c);

				exit (-1);
				}
			}
		}


	if (k < argc)
		copy_string(config.server, argv[k++], sizeof(config.server));
	else {
		if (isatty(2))
			fprintf (stderr, "%s: missing server\n", program);

		exit (1);
		}

	if (k < argc) {
		if (isatty(2))
			fprintf (stderr, "%s: unexpected arguments after server argument\n", program);

		exit (1);
		}


	proxy_request(&config);
	close(0);

	exit (0);
}


